/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.anthropic.api.utils;

import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.anthropic.api.AnthropicApi;
import org.springframework.ai.anthropic.api.AnthropicCacheOptions;
import org.springframework.ai.anthropic.api.AnthropicCacheStrategy;
import org.springframework.ai.anthropic.api.AnthropicCacheTtl;
import org.springframework.ai.anthropic.api.AnthropicCacheType;
import org.springframework.ai.anthropic.api.utils.CacheBreakpointTracker;
import org.springframework.ai.chat.messages.MessageType;

public class CacheEligibilityResolver {
    private static final Logger logger = LoggerFactory.getLogger(CacheEligibilityResolver.class);
    private static final MessageType TOOL_DEFINITION_MESSAGE_TYPE = MessageType.SYSTEM;
    private final CacheBreakpointTracker cacheBreakpointTracker = new CacheBreakpointTracker();
    private final AnthropicCacheType anthropicCacheType = AnthropicCacheType.EPHEMERAL;
    private final AnthropicCacheStrategy cacheStrategy;
    private final Map<MessageType, AnthropicCacheTtl> messageTypeTtl;
    private final Map<MessageType, Integer> messageTypeMinContentLengths;
    private final Function<String, Integer> contentLengthFunction;
    private final Set<MessageType> cacheEligibleMessageTypes;

    public CacheEligibilityResolver(AnthropicCacheStrategy cacheStrategy, Map<MessageType, AnthropicCacheTtl> messageTypeTtl, Map<MessageType, Integer> messageTypeMinContentLengths, Function<String, Integer> contentLengthFunction, Set<MessageType> cacheEligibleMessageTypes) {
        this.cacheStrategy = cacheStrategy;
        this.messageTypeTtl = messageTypeTtl;
        this.messageTypeMinContentLengths = messageTypeMinContentLengths;
        this.contentLengthFunction = contentLengthFunction;
        this.cacheEligibleMessageTypes = cacheEligibleMessageTypes;
    }

    public static CacheEligibilityResolver from(AnthropicCacheOptions anthropicCacheOptions) {
        AnthropicCacheStrategy strategy = anthropicCacheOptions.getStrategy();
        return new CacheEligibilityResolver(strategy, anthropicCacheOptions.getMessageTypeTtl(), anthropicCacheOptions.getMessageTypeMinContentLengths(), anthropicCacheOptions.getContentLengthFunction(), CacheEligibilityResolver.extractEligibleMessageTypes(strategy));
    }

    private static Set<MessageType> extractEligibleMessageTypes(AnthropicCacheStrategy anthropicCacheStrategy) {
        return switch (anthropicCacheStrategy) {
            default -> throw new IncompatibleClassChangeError();
            case AnthropicCacheStrategy.NONE -> Set.of();
            case AnthropicCacheStrategy.SYSTEM_ONLY, AnthropicCacheStrategy.SYSTEM_AND_TOOLS -> Set.of(MessageType.SYSTEM);
            case AnthropicCacheStrategy.CONVERSATION_HISTORY -> Set.of(MessageType.values());
        };
    }

    public AnthropicApi.ChatCompletionRequest.CacheControl resolve(MessageType messageType, String content) {
        Integer length = this.contentLengthFunction.apply(content);
        if (this.cacheStrategy == AnthropicCacheStrategy.NONE || !this.cacheEligibleMessageTypes.contains(messageType) || length == null || length < this.messageTypeMinContentLengths.get(messageType) || this.cacheBreakpointTracker.allBreakpointsAreUsed()) {
            logger.debug("Caching not enabled for messageType={}, contentLength={}, minContentLength={}, cacheStrategy={}, usedBreakpoints={}", new Object[]{messageType, length, this.messageTypeMinContentLengths.get(messageType), this.cacheStrategy, this.cacheBreakpointTracker.getCount()});
            return null;
        }
        AnthropicCacheTtl anthropicCacheTtl = this.messageTypeTtl.get(messageType);
        logger.debug("Caching enabled for messageType={}, ttl={}", (Object)messageType, (Object)anthropicCacheTtl);
        return this.anthropicCacheType.cacheControl(anthropicCacheTtl.getValue());
    }

    public AnthropicApi.ChatCompletionRequest.CacheControl resolveToolCacheControl() {
        if (!this.isCachingEnabled() || !this.cacheEligibleMessageTypes.contains(TOOL_DEFINITION_MESSAGE_TYPE) || this.cacheBreakpointTracker.allBreakpointsAreUsed()) {
            logger.debug("Caching not enabled for tool definition, usedBreakpoints={}", (Object)this.cacheBreakpointTracker.getCount());
            return null;
        }
        AnthropicCacheTtl anthropicCacheTtl = this.messageTypeTtl.get(TOOL_DEFINITION_MESSAGE_TYPE);
        logger.debug("Caching enabled for tool definition, ttl={}", (Object)anthropicCacheTtl);
        return this.anthropicCacheType.cacheControl(anthropicCacheTtl.getValue());
    }

    public boolean isCachingEnabled() {
        return this.cacheStrategy != AnthropicCacheStrategy.NONE;
    }

    public void useCacheBlock() {
        this.cacheBreakpointTracker.use();
    }
}

