/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.webflux.ui;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.springdoc.core.SwaggerUiConfigParameters;
import org.springdoc.core.SwaggerUiConfigProperties;
import org.springdoc.core.SwaggerUiOAuthProperties;
import org.springdoc.ui.AbstractSwaggerIndexTransformer;
import org.springdoc.ui.SpringDocUIException;
import org.springdoc.webflux.ui.SwaggerIndexTransformer;
import org.springframework.core.io.Resource;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.reactive.resource.ResourceTransformerChain;
import org.springframework.web.reactive.resource.TransformedResource;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class SwaggerIndexPageTransformer
extends AbstractSwaggerIndexTransformer
implements SwaggerIndexTransformer {
    public SwaggerIndexPageTransformer(SwaggerUiConfigProperties swaggerUiConfig, SwaggerUiOAuthProperties swaggerUiOAuthProperties, SwaggerUiConfigParameters swaggerUiConfigParameters, ObjectMapper objectMapper) {
        super(swaggerUiConfig, swaggerUiOAuthProperties, swaggerUiConfigParameters, objectMapper);
    }

    public Mono<Resource> transform(ServerWebExchange serverWebExchange, Resource resource, ResourceTransformerChain resourceTransformerChain) {
        AntPathMatcher antPathMatcher = new AntPathMatcher();
        try {
            boolean isIndexFound = antPathMatcher.match("**/swagger-ui/**/index.html", resource.getURL().toString());
            if (isIndexFound) {
                String html = this.defaultTransformations(resource.getInputStream());
                return Mono.just((Object)new TransformedResource(resource, html.getBytes()));
            }
            return Mono.just((Object)resource);
        }
        catch (Exception e) {
            throw new SpringDocUIException("Failed to transform Index", (Throwable)e);
        }
    }
}

