/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.webflux.ui;

import io.swagger.v3.oas.annotations.Operation;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springdoc.core.SpringDocConfigProperties;
import org.springdoc.core.SwaggerUiConfigParameters;
import org.springdoc.core.SwaggerUiConfigProperties;
import org.springdoc.webflux.ui.SwaggerWelcomeCommon;
import org.springframework.boot.actuate.autoconfigure.endpoint.web.WebEndpointProperties;
import org.springframework.boot.actuate.endpoint.web.annotation.ControllerEndpoint;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;

@ControllerEndpoint(id="swaggerui")
public class SwaggerWelcomeActuator
extends SwaggerWelcomeCommon {
    private WebEndpointProperties webEndpointProperties;
    private static final String SWAGGER_CONFIG_ACTUATOR_URL = "/swagger-config";

    public SwaggerWelcomeActuator(SwaggerUiConfigProperties swaggerUiConfig, SpringDocConfigProperties springDocConfigProperties, SwaggerUiConfigParameters swaggerUiConfigParameters, WebEndpointProperties webEndpointProperties) {
        super(swaggerUiConfig, springDocConfigProperties, swaggerUiConfigParameters);
        this.webEndpointProperties = webEndpointProperties;
    }

    @Override
    @Operation(hidden=true)
    @GetMapping(value={"/"})
    public Mono<Void> redirectToUi(ServerHttpRequest request, ServerHttpResponse response) {
        return super.redirectToUi(request, response);
    }

    @Override
    @Operation(hidden=true)
    @GetMapping(value={"/swagger-config"}, produces={"application/json"})
    @ResponseBody
    public Map<String, Object> getSwaggerUiConfig(ServerHttpRequest request) {
        return super.getSwaggerUiConfig(request);
    }

    protected void buildConfigUrl(String contextPath, UriComponentsBuilder uriComponentsBuilder) {
        String apiDocsUrl = "openapi";
        if (StringUtils.isEmpty((CharSequence)this.swaggerUiConfig.getConfigUrl())) {
            String url = this.buildUrl(contextPath + this.webEndpointProperties.getBasePath(), apiDocsUrl);
            String swaggerConfigUrl = contextPath + this.webEndpointProperties.getBasePath() + "/" + "swaggerui" + "/" + "swagger-config";
            this.swaggerUiConfigParameters.setConfigUrl(swaggerConfigUrl);
            if (CollectionUtils.isEmpty((Collection)this.swaggerUiConfigParameters.getUrls())) {
                String swaggerUiUrl = this.swaggerUiConfig.getUrl();
                if (StringUtils.isEmpty((CharSequence)swaggerUiUrl)) {
                    this.swaggerUiConfigParameters.setUrl(url);
                } else {
                    this.swaggerUiConfigParameters.setUrl(swaggerUiUrl);
                }
            } else {
                this.swaggerUiConfigParameters.addUrl(url);
            }
        }
        this.calculateOauth2RedirectUrl(uriComponentsBuilder);
    }

    protected void calculateUiRootPath(StringBuilder ... sbUrls) {
        StringBuilder sbUrl = new StringBuilder();
        sbUrl.append(this.webEndpointProperties.getBasePath());
        this.calculateUiRootCommon(sbUrl, sbUrls);
    }
}

