/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.webmvc.ui;

import io.swagger.v3.oas.annotations.Operation;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.springdoc.core.SpringDocConfigProperties;
import org.springdoc.core.SpringDocConfiguration;
import org.springdoc.core.SwaggerUiConfigParameters;
import org.springdoc.core.SwaggerUiConfigProperties;
import org.springdoc.ui.AbstractSwaggerWelcome;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.util.UriComponentsBuilder;

@Controller
@ConditionalOnProperty(name={"springdoc.swagger-ui.enabled"}, matchIfMissing=true)
@ConditionalOnBean(value={SpringDocConfiguration.class})
public class SwaggerWelcome
extends AbstractSwaggerWelcome {
    @Value(value="${spring.mvc.servlet.path:#{null}}")
    private String mvcServletPath;

    public SwaggerWelcome(SwaggerUiConfigProperties swaggerUiConfig, SpringDocConfigProperties springDocConfigProperties, SwaggerUiConfigParameters swaggerUiConfigParameters) {
        super(swaggerUiConfig, springDocConfigProperties, swaggerUiConfigParameters);
    }

    @Operation(hidden=true)
    @GetMapping(value={"${springdoc.swagger-ui.path:#{T(org.springdoc.core.Constants).DEFAULT_SWAGGER_UI_PATH}}"})
    public String redirectToUi(HttpServletRequest request) {
        this.buildConfigUrl(request.getContextPath(), (UriComponentsBuilder)ServletUriComponentsBuilder.fromCurrentContextPath());
        String sbUrl = "redirect:" + this.swaggerUiConfigParameters.getUiRootPath() + "/swagger-ui/index.html";
        UriComponentsBuilder uriBuilder = this.getUriComponentsBuilder(sbUrl);
        return uriBuilder.build().encode().toString();
    }

    @Operation(hidden=true)
    @GetMapping(value={"${springdoc.api-docs.path:#{T(org.springdoc.core.Constants).DEFAULT_API_DOCS_URL}}/swagger-config"}, produces={"application/json"})
    @ResponseBody
    public Map<String, Object> openapiJson(HttpServletRequest request) {
        this.buildConfigUrl(request.getContextPath(), (UriComponentsBuilder)ServletUriComponentsBuilder.fromCurrentContextPath());
        return this.swaggerUiConfigParameters.getConfigParameters();
    }

    protected void calculateUiRootPath(StringBuilder ... sbUrls) {
        String swaggerPath;
        StringBuilder sbUrl = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)this.mvcServletPath)) {
            sbUrl.append(this.mvcServletPath);
        }
        if (ArrayUtils.isNotEmpty((Object[])sbUrls)) {
            sbUrl = sbUrls[0];
        }
        if ((swaggerPath = this.swaggerUiConfigParameters.getPath()).contains("/")) {
            sbUrl.append(swaggerPath, 0, swaggerPath.lastIndexOf("/"));
        }
        this.swaggerUiConfigParameters.setUiRootPath(sbUrl.toString());
    }

    protected String buildUrl(String contextPath, String docsUrl) {
        if (StringUtils.isNotBlank((CharSequence)this.mvcServletPath)) {
            contextPath = contextPath + this.mvcServletPath;
        }
        return super.buildUrl(contextPath, docsUrl);
    }

    protected void calculateOauth2RedirectUrl(UriComponentsBuilder uriComponentsBuilder) {
        if (!this.swaggerUiConfigParameters.isValidUrl(this.swaggerUiConfigParameters.getOauth2RedirectUrl())) {
            this.swaggerUiConfigParameters.setOauth2RedirectUrl(uriComponentsBuilder.path(this.swaggerUiConfigParameters.getUiRootPath()).path(this.swaggerUiConfigParameters.getOauth2RedirectUrl()).build().toString());
        }
    }
}

