/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.ui;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springdoc.core.SwaggerUiOAuthProperties;
import org.springframework.core.io.Resource;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.CollectionUtils;
import org.springframework.web.servlet.resource.ResourceTransformer;
import org.springframework.web.servlet.resource.ResourceTransformerChain;
import org.springframework.web.servlet.resource.TransformedResource;

public class SwaggerIndexTransformer
implements ResourceTransformer {
    private SwaggerUiOAuthProperties swaggerUiOAuthProperties;
    private ObjectMapper objectMapper;

    public SwaggerIndexTransformer(SwaggerUiOAuthProperties swaggerUiOAuthProperties, ObjectMapper objectMapper) {
        this.swaggerUiOAuthProperties = swaggerUiOAuthProperties;
        this.objectMapper = objectMapper;
    }

    public Resource transform(HttpServletRequest request, Resource resource, ResourceTransformerChain transformerChain) throws IOException {
        AntPathMatcher antPathMatcher = new AntPathMatcher();
        boolean isIndexFound = antPathMatcher.match("**/swagger-ui/**/index.html", resource.getURL().toString());
        if (isIndexFound && !CollectionUtils.isEmpty((Map)this.swaggerUiOAuthProperties.getConfigParameters())) {
            String html = this.readFullyAsString(resource.getInputStream());
            html = this.addInitOauth(html);
            return new TransformedResource(resource, html.getBytes());
        }
        return resource;
    }

    private String addInitOauth(String html) throws JsonProcessingException {
        StringBuilder stringBuilder = new StringBuilder("window.ui = ui\n");
        stringBuilder.append("ui.initOAuth(\n");
        String json = this.objectMapper.writeValueAsString((Object)this.swaggerUiOAuthProperties.getConfigParameters());
        stringBuilder.append(json);
        stringBuilder.append(")");
        return html.replace("window.ui = ui", stringBuilder.toString());
    }

    private String readFullyAsString(InputStream inputStream) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int length = 0;
        while ((length = inputStream.read(buffer)) != -1) {
            baos.write(buffer, 0, length);
        }
        return baos.toString(StandardCharsets.UTF_8.name());
    }
}

