/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.webflux.scalar;

import com.scalar.maven.webjar.ScalarProperties;
import io.swagger.v3.oas.annotations.Operation;
import java.io.IOException;
import org.springdoc.scalar.AbstractScalarController;
import org.springframework.boot.actuate.autoconfigure.endpoint.web.WebEndpointProperties;
import org.springframework.boot.actuate.endpoint.web.annotation.ControllerEndpoint;
import org.springframework.http.ResponseEntity;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.web.bind.annotation.GetMapping;
import tools.jackson.databind.ObjectMapper;

@ControllerEndpoint(id="scalar")
public class ScalarActuatorController
extends AbstractScalarController {
    private final WebEndpointProperties webEndpointProperties;

    protected ScalarActuatorController(ScalarProperties scalarProperties, WebEndpointProperties webEndpointProperties, ObjectMapper objectMapper) {
        super(scalarProperties, objectMapper);
        this.webEndpointProperties = webEndpointProperties;
    }

    @Operation(hidden=true)
    @GetMapping(value={"/"})
    public ResponseEntity<String> getDocs(ServerHttpRequest serverHttpRequest) throws IOException {
        return super.getDocs(serverHttpRequest.getURI().toString());
    }

    @Operation(hidden=true)
    @GetMapping(value={"/scalar.js"})
    public ResponseEntity<byte[]> getScalarJs() throws IOException {
        return super.getScalarJs();
    }

    public String buildApiDocsUrl(String requestUrl) {
        return this.buildApiDocsUrl(requestUrl, "/openapi");
    }

    public String buildJsBundleUrl(String requestUrl) {
        String scalarPath = this.webEndpointProperties.getBasePath() + this.scalarProperties.getPath();
        return this.buildJsBundleUrl(requestUrl, scalarPath);
    }
}

