/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.webflux.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.v3.core.util.PathUtils;
import io.swagger.v3.oas.models.OpenAPI;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import org.springdoc.api.AbstractOpenApiResource;
import org.springdoc.core.customizers.OpenApiCustomizer;
import org.springdoc.core.customizers.OperationCustomizer;
import org.springdoc.core.filters.OpenApiMethodFilter;
import org.springdoc.core.properties.SpringDocConfigProperties;
import org.springdoc.core.providers.ActuatorProvider;
import org.springdoc.core.providers.SpringDocProviders;
import org.springdoc.core.service.AbstractRequestService;
import org.springdoc.core.service.GenericResponseService;
import org.springdoc.core.service.OpenAPIService;
import org.springdoc.core.service.OperationService;
import org.springdoc.webflux.core.visitor.RouterFunctionVisitor;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.util.MimeType;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.reactive.function.server.RouterFunction;
import org.springframework.web.reactive.function.server.RouterFunctions;
import org.springframework.web.reactive.result.method.RequestMappingInfo;
import reactor.core.publisher.Mono;

public abstract class OpenApiResource
extends AbstractOpenApiResource {
    public OpenApiResource(String groupName, ObjectFactory<OpenAPIService> openAPIBuilderObjectFactory, AbstractRequestService requestBuilder, GenericResponseService responseBuilder, OperationService operationParser, Optional<List<OperationCustomizer>> operationCustomizers, Optional<List<OpenApiCustomizer>> openApiCustomizers, Optional<List<OpenApiMethodFilter>> methodFilters, SpringDocConfigProperties springDocConfigProperties, SpringDocProviders springDocProviders) {
        super(groupName, openAPIBuilderObjectFactory, requestBuilder, responseBuilder, operationParser, operationCustomizers, openApiCustomizers, methodFilters, springDocConfigProperties, springDocProviders);
    }

    public OpenApiResource(ObjectFactory<OpenAPIService> openAPIBuilderObjectFactory, AbstractRequestService requestBuilder, GenericResponseService responseBuilder, OperationService operationParser, Optional<List<OperationCustomizer>> operationCustomizers, Optional<List<OpenApiCustomizer>> openApiCustomizers, Optional<List<OpenApiMethodFilter>> methodFilters, SpringDocConfigProperties springDocConfigProperties, SpringDocProviders springDocProviders) {
        super("springdocDefault", openAPIBuilderObjectFactory, requestBuilder, responseBuilder, operationParser, operationCustomizers, openApiCustomizers, methodFilters, springDocConfigProperties, springDocProviders);
    }

    protected Mono<String> openapiJson(ServerHttpRequest serverHttpRequest, String apiDocsUrl, Locale locale) throws JsonProcessingException {
        this.calculateServerUrl(serverHttpRequest, apiDocsUrl, locale);
        OpenAPI openAPI = this.getOpenApi(locale);
        return Mono.just((Object)this.writeJsonValue(openAPI));
    }

    protected Mono<String> openapiYaml(ServerHttpRequest serverHttpRequest, String apiDocsUrl, Locale locale) throws JsonProcessingException {
        this.calculateServerUrl(serverHttpRequest, apiDocsUrl, locale);
        OpenAPI openAPI = this.getOpenApi(locale);
        return Mono.just((Object)this.writeYamlValue(openAPI));
    }

    protected void getPaths(Map<String, Object> restControllers, Locale locale) {
        Optional springWebProviderOptional = this.springDocProviders.getSpringWebProvider();
        springWebProviderOptional.ifPresent(springWebProvider -> {
            Map map = springWebProvider.getHandlerMethods();
            Optional actuatorProviderOptional = this.springDocProviders.getActuatorProvider();
            if (actuatorProviderOptional.isPresent() && this.springDocConfigProperties.isShowActuator()) {
                Map actuatorMap = ((ActuatorProvider)actuatorProviderOptional.get()).getMethods();
                this.openAPIService.addTag(new HashSet(actuatorMap.values()), ActuatorProvider.getTag());
                map.putAll(actuatorMap);
            }
            this.calculatePath(restControllers, map, locale);
            this.getWebFluxRouterFunctionPaths(locale);
        });
    }

    protected void calculatePath(Map<String, Object> restControllers, Map<RequestMappingInfo, HandlerMethod> map, Locale locale) {
        TreeMap<RequestMappingInfo, HandlerMethod> methodTreeMap = new TreeMap<RequestMappingInfo, HandlerMethod>(this.byReversedRequestMappingInfos());
        methodTreeMap.putAll(map);
        Optional springWebProviderOptional = this.springDocProviders.getSpringWebProvider();
        springWebProviderOptional.ifPresent(springWebProvider -> {
            for (Map.Entry entry : methodTreeMap.entrySet()) {
                RequestMappingInfo requestMappingInfo = (RequestMappingInfo)entry.getKey();
                HandlerMethod handlerMethod = (HandlerMethod)entry.getValue();
                Set patterns = springWebProvider.getActivePatterns((Object)requestMappingInfo);
                for (String operationPath : patterns) {
                    LinkedHashMap regexMap = new LinkedHashMap();
                    operationPath = PathUtils.parsePath((String)operationPath, regexMap);
                    String[] produces = (String[])requestMappingInfo.getProducesCondition().getProducibleMediaTypes().stream().map(MimeType::toString).toArray(String[]::new);
                    String[] consumes = (String[])requestMappingInfo.getConsumesCondition().getConsumableMediaTypes().stream().map(MimeType::toString).toArray(String[]::new);
                    String[] headers = (String[])requestMappingInfo.getHeadersCondition().getExpressions().stream().map(Object::toString).toArray(String[]::new);
                    if (!this.isRestController(restControllers, handlerMethod, operationPath) && !this.isActuatorRestController(operationPath, handlerMethod) || !this.isFilterCondition(handlerMethod, operationPath, produces, consumes, headers)) continue;
                    Set requestMethods = requestMappingInfo.getMethodsCondition().getMethods();
                    if (requestMethods.isEmpty()) {
                        requestMethods = this.getDefaultAllowedHttpMethods();
                    }
                    this.calculatePath(handlerMethod, operationPath, requestMethods, locale);
                }
            }
        });
    }

    private Comparator<RequestMappingInfo> byReversedRequestMappingInfos() {
        return (o2, o1) -> o1.toString().compareTo(o2.toString());
    }

    protected void getWebFluxRouterFunctionPaths(Locale locale) {
        Map routerBeans = Objects.requireNonNull(this.openAPIService.getContext()).getBeansOfType(RouterFunction.class);
        for (Map.Entry entry : routerBeans.entrySet()) {
            RouterFunction routerFunction = (RouterFunction)entry.getValue();
            RouterFunctionVisitor routerFunctionVisitor = new RouterFunctionVisitor();
            routerFunction.accept((RouterFunctions.Visitor)routerFunctionVisitor);
            this.getRouterFunctionPaths((String)entry.getKey(), routerFunctionVisitor, locale);
        }
    }

    protected void calculateServerUrl(ServerHttpRequest serverHttpRequest, String apiDocsUrl, Locale locale) {
        this.initOpenAPIBuilder(locale);
        String serverUrl = this.getServerUrl(serverHttpRequest, apiDocsUrl);
        this.openAPIService.setServerBaseUrl(serverUrl);
    }

    protected abstract String getServerUrl(ServerHttpRequest var1, String var2);
}

