/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core.configuration;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.module.SimpleModule;
import io.swagger.v3.core.jackson.SwaggerAnnotationIntrospector;
import io.swagger.v3.oas.annotations.media.Schema;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SpringDocSealedClassModule
extends SimpleModule {
    public void setupModule(Module.SetupContext context) {
        context.insertAnnotationIntrospector((AnnotationIntrospector)new RespectSealedClassAnnotationIntrospector());
    }

    private static class RespectSealedClassAnnotationIntrospector
    extends SwaggerAnnotationIntrospector {
        private RespectSealedClassAnnotationIntrospector() {
        }

        public List<NamedType> findSubtypes(Annotated annotated) {
            Class clazz;
            ArrayList<NamedType> subTypes = new ArrayList<NamedType>();
            AnnotatedElement annotatedElement = annotated.getAnnotated();
            if (annotatedElement instanceof Class && (clazz = (Class)annotatedElement).isSealed() && !clazz.getPackage().getName().startsWith("java")) {
                Schema schema = clazz.getAnnotation(Schema.class);
                if (schema != null && schema.oneOf().length > 0) {
                    return new ArrayList<NamedType>();
                }
                JsonSubTypes jsonSubTypes = clazz.getAnnotation(JsonSubTypes.class);
                if (jsonSubTypes != null && jsonSubTypes.value().length > 0) {
                    return new ArrayList<NamedType>();
                }
                Class<?>[] permittedSubClasses = clazz.getPermittedSubclasses();
                if (permittedSubClasses.length > 0) {
                    Arrays.stream(permittedSubClasses).map(NamedType::new).forEach(subTypes::add);
                }
            }
            return subTypes;
        }
    }
}

