/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core.providers;

import io.swagger.v3.oas.models.ExternalDocumentation;
import io.swagger.v3.oas.models.tags.Tag;
import java.util.Map;
import java.util.Optional;
import org.springdoc.api.AbstractOpenApiResource;
import org.springdoc.core.properties.SpringDocConfigProperties;
import org.springframework.boot.actuate.autoconfigure.endpoint.web.WebEndpointProperties;
import org.springframework.boot.actuate.autoconfigure.web.server.ManagementServerProperties;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.web.context.WebServerApplicationContext;
import org.springframework.boot.web.context.WebServerInitializedEvent;
import org.springframework.boot.web.server.WebServer;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.web.method.HandlerMethod;

public abstract class ActuatorProvider
implements ApplicationListener<WebServerInitializedEvent> {
    protected ManagementServerProperties managementServerProperties;
    protected WebEndpointProperties webEndpointProperties;
    protected ServerProperties serverProperties;
    protected SpringDocConfigProperties springDocConfigProperties;
    protected WebServer actuatorWebServer;
    protected WebServer applicationWebServer;
    protected ApplicationContext managementApplicationContext;

    protected ActuatorProvider(Optional<ManagementServerProperties> managementServerProperties, Optional<WebEndpointProperties> webEndpointProperties, ServerProperties serverProperties, SpringDocConfigProperties springDocConfigProperties) {
        managementServerProperties.ifPresent(managementServerProperties1 -> {
            this.managementServerProperties = managementServerProperties1;
        });
        webEndpointProperties.ifPresent(webEndpointProperties1 -> {
            this.webEndpointProperties = webEndpointProperties1;
        });
        this.serverProperties = serverProperties;
        this.springDocConfigProperties = springDocConfigProperties;
    }

    public static Tag getTag() {
        Tag actuatorTag = new Tag();
        actuatorTag.setName("Actuator");
        actuatorTag.setDescription("Monitor and interact");
        actuatorTag.setExternalDocs(new ExternalDocumentation().url("https://docs.spring.io/spring-boot/docs/current/actuator-api/html/").description("Spring Boot Actuator Web API Documentation"));
        return actuatorTag;
    }

    public void onApplicationEvent(WebServerInitializedEvent event) {
        if (WebServerApplicationContext.hasServerNamespace((ApplicationContext)event.getApplicationContext(), (String)"management")) {
            this.managementApplicationContext = event.getApplicationContext();
            this.actuatorWebServer = event.getWebServer();
        } else {
            this.applicationWebServer = event.getWebServer();
        }
    }

    public boolean isRestController(String operationPath, HandlerMethod handlerMethod) {
        return operationPath.startsWith("/") && !AbstractOpenApiResource.isHiddenRestControllers(handlerMethod.getBeanType()) && AbstractOpenApiResource.containsResponseBody(handlerMethod);
    }

    public boolean isUseManagementPort() {
        return this.springDocConfigProperties.isUseManagementPort();
    }

    public String getBasePath() {
        return this.webEndpointProperties.getBasePath();
    }

    public String getContextPath() {
        return "";
    }

    public String getActuatorPath() {
        return this.managementServerProperties.getBasePath();
    }

    public int getApplicationPort() {
        return this.applicationWebServer.getPort();
    }

    public int getActuatorPort() {
        return this.actuatorWebServer.getPort();
    }

    public abstract Map getMethods();
}

