/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core.data;

import com.fasterxml.jackson.annotation.JsonView;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.ArrayUtils;
import org.springdoc.core.data.DataRestRepository;
import org.springdoc.core.discoverer.SpringDocParameterNameDiscoverer;
import org.springdoc.core.extractor.DelegatingMethodParameter;
import org.springdoc.core.models.MethodAttributes;
import org.springdoc.core.models.ParameterInfo;
import org.springdoc.core.models.RequestBodyInfo;
import org.springdoc.core.service.AbstractRequestService;
import org.springdoc.core.service.GenericParameterService;
import org.springdoc.core.service.RequestBodyService;
import org.springdoc.core.utils.SpringDocAnnotationsUtils;
import org.springdoc.core.utils.SpringDocDataRestUtils;
import org.springdoc.core.utils.SpringDocUtils;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.data.rest.core.mapping.ResourceMetadata;
import org.springframework.data.rest.webmvc.PersistentEntityResource;
import org.springframework.data.rest.webmvc.support.BackendId;
import org.springframework.data.rest.webmvc.support.DefaultedPageable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.method.HandlerMethod;

public class DataRestRequestService {
    private final SpringDocParameterNameDiscoverer localSpringDocParameterNameDiscoverer;
    private final GenericParameterService parameterBuilder;
    private final RequestBodyService requestBodyService;
    private final AbstractRequestService requestBuilder;
    private final SpringDocDataRestUtils springDocDataRestUtils;

    public DataRestRequestService(SpringDocParameterNameDiscoverer localSpringDocParameterNameDiscoverer, GenericParameterService parameterBuilder, RequestBodyService requestBodyService, AbstractRequestService requestBuilder, SpringDocDataRestUtils springDocDataRestUtils) {
        this.localSpringDocParameterNameDiscoverer = localSpringDocParameterNameDiscoverer;
        this.parameterBuilder = parameterBuilder;
        this.requestBodyService = requestBodyService;
        this.requestBuilder = requestBuilder;
        this.springDocDataRestUtils = springDocDataRestUtils;
    }

    public void buildParameters(OpenAPI openAPI, HandlerMethod handlerMethod, RequestMethod requestMethod, MethodAttributes methodAttributes, Operation operation, ResourceMetadata resourceMetadata, DataRestRepository dataRestRepository) {
        Optional<MethodParameter> methodParameterPage;
        String[] pNames = this.localSpringDocParameterNameDiscoverer.getParameterNames(handlerMethod.getMethod());
        Object[] parameters = handlerMethod.getMethodParameters();
        if (!resourceMetadata.isPagingResource() && (methodParameterPage = Arrays.stream(parameters).filter(methodParameter -> DefaultedPageable.class.equals((Object)methodParameter.getParameterType())).findFirst()).isPresent()) {
            parameters = (MethodParameter[])ArrayUtils.removeElement((Object[])parameters, (Object)methodParameterPage.get());
        }
        String[] reflectionParametersNames = (String[])Arrays.stream(handlerMethod.getMethod().getParameters()).map(java.lang.reflect.Parameter::getName).toArray(String[]::new);
        if (pNames == null || Arrays.stream(pNames).anyMatch(Objects::isNull)) {
            pNames = reflectionParametersNames;
        }
        this.buildCommonParameters(openAPI, requestMethod, methodAttributes, operation, pNames, (MethodParameter[])parameters, dataRestRepository);
    }

    public void buildCommonParameters(OpenAPI openAPI, RequestMethod requestMethod, MethodAttributes methodAttributes, Operation operation, String[] pNames, MethodParameter[] parameters, DataRestRepository dataRestRepository) {
        parameters = DelegatingMethodParameter.customize(pNames, parameters, this.parameterBuilder.getOptionalDelegatingMethodParameterCustomizers(), this.requestBuilder.isDefaultFlatParamObject());
        Class<?> domainType = dataRestRepository.getDomainType();
        for (MethodParameter methodParameter : parameters) {
            String pName = methodParameter.getParameterName();
            Parameter parameterDoc = (Parameter)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)AnnotatedElementUtils.forAnnotations((Annotation[])methodParameter.getParameterAnnotations()), Parameter.class);
            ParameterInfo parameterInfo = new ParameterInfo(pName, methodParameter, this.parameterBuilder, parameterDoc);
            if (!this.isParamToIgnore(methodParameter)) continue;
            if (PersistentEntityResource.class.equals((Object)methodParameter.getParameterType())) {
                Schema schema = SpringDocAnnotationsUtils.resolveSchemaFromType(domainType, openAPI.getComponents(), null, SpringDocUtils.getParameterAnnotations(methodParameter), openAPI.getSpecVersion());
                parameterInfo.setParameterModel(new io.swagger.v3.oas.models.parameters.Parameter().schema(schema));
            } else if (methodParameter.getParameterAnnotation(BackendId.class) != null) {
                parameterInfo.setParameterModel(new io.swagger.v3.oas.models.parameters.Parameter().name("id").in(ParameterIn.PATH.toString()).schema((Schema)new StringSchema()));
            }
            io.swagger.v3.oas.models.parameters.Parameter parameter = null;
            if (parameterDoc != null) {
                if (parameterDoc.hidden() || parameterDoc.schema().hidden()) continue;
                parameter = this.parameterBuilder.buildParameterFromDoc(parameterDoc, openAPI.getComponents(), methodAttributes.getJsonViewAnnotation(), methodAttributes.getLocale());
                parameterInfo.setParameterModel(parameter);
            }
            if (!ArrayUtils.isEmpty((Object[])methodParameter.getParameterAnnotations())) {
                parameter = this.requestBuilder.buildParams(parameterInfo, openAPI.getComponents(), requestMethod, methodAttributes, openAPI.getOpenapi());
            }
            this.addParameters(openAPI, requestMethod, methodAttributes, operation, methodParameter, parameterInfo, parameter);
        }
    }

    public io.swagger.v3.oas.models.parameters.Parameter buildParameterFromDoc(Parameter parameterDoc, Components components, JsonView jsonViewAnnotation, Locale locale) {
        return this.parameterBuilder.buildParameterFromDoc(parameterDoc, components, jsonViewAnnotation, locale);
    }

    private boolean isParamToIgnore(MethodParameter methodParameter) {
        return !this.requestBuilder.isParamToIgnore(methodParameter) && !this.isHeaderToIgnore(methodParameter) && !"property".equals(methodParameter.getParameterName());
    }

    private void addParameters(OpenAPI openAPI, RequestMethod requestMethod, MethodAttributes methodAttributes, Operation operation, MethodParameter methodParameter, ParameterInfo parameterInfo, io.swagger.v3.oas.models.parameters.Parameter parameter) {
        List<Annotation> parameterAnnotations = Arrays.asList(SpringDocUtils.getParameterAnnotations(methodParameter));
        if (this.requestBuilder.isValidParameter(parameter)) {
            this.requestBuilder.applyBeanValidatorAnnotations(parameter, parameterAnnotations);
            operation.addParametersItem(parameter);
        } else if (!RequestMethod.GET.equals((Object)requestMethod)) {
            RequestBodyInfo requestBodyInfo = new RequestBodyInfo();
            if (operation.getRequestBody() != null) {
                requestBodyInfo.setRequestBody(operation.getRequestBody());
            }
            this.requestBodyService.calculateRequestBodyInfo(openAPI.getComponents(), methodAttributes, parameterInfo, requestBodyInfo);
            this.requestBuilder.applyBeanValidatorAnnotations(requestBodyInfo.getRequestBody(), parameterAnnotations, methodParameter.isOptional());
            operation.setRequestBody(requestBodyInfo.getRequestBody());
            Content content = operation.getRequestBody().getContent();
            this.springDocDataRestUtils.buildTextUriContent(content);
            operation.getRequestBody().setRequired(Boolean.valueOf(true));
        }
    }

    private boolean isHeaderToIgnore(MethodParameter methodParameter) {
        RequestHeader requestHeader = (RequestHeader)methodParameter.getParameterAnnotation(RequestHeader.class);
        return requestHeader != null && "Accept".equals(requestHeader.value());
    }
}

