/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core.service;

import com.fasterxml.jackson.annotation.JsonView;
import io.swagger.v3.core.util.PrimitiveType;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import jakarta.validation.constraints.DecimalMax;
import jakarta.validation.constraints.DecimalMin;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.security.Principal;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TimeZone;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.springdoc.core.converters.SchemaPropertyDeprecatingConverter;
import org.springdoc.core.customizers.ParameterCustomizer;
import org.springdoc.core.extractor.DelegatingMethodParameter;
import org.springdoc.core.models.MethodAttributes;
import org.springdoc.core.models.ParameterId;
import org.springdoc.core.models.ParameterInfo;
import org.springdoc.core.models.RequestBodyInfo;
import org.springdoc.core.properties.SpringDocConfigProperties;
import org.springdoc.core.providers.JavadocProvider;
import org.springdoc.core.service.GenericParameterService;
import org.springdoc.core.service.OperationService;
import org.springdoc.core.service.RequestBodyService;
import org.springdoc.core.utils.SpringDocAnnotationsUtils;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.http.HttpMethod;
import org.springframework.ui.Model;
import org.springframework.ui.ModelMap;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.support.SessionStatus;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.util.UriComponentsBuilder;

public abstract class AbstractRequestService {
    private static final List<Class<?>> PARAM_TYPES_TO_IGNORE = Collections.synchronizedList(new ArrayList());
    private static final String[] ANNOTATIONS_FOR_REQUIRED = new String[]{"NotNull", "NonNull", "NotBlank", "NotEmpty"};
    private static final String POSITIVE_OR_ZERO = "PositiveOrZero";
    private static final String NEGATIVE_OR_ZERO = "NegativeOrZero";
    private final GenericParameterService parameterBuilder;
    private final RequestBodyService requestBodyService;
    private final OperationService operationService;
    private final LocalVariableTableParameterNameDiscoverer localSpringDocParameterNameDiscoverer;
    private final Optional<List<ParameterCustomizer>> parameterCustomizers;
    private final boolean defaultFlatParamObject;
    private boolean defaultSupportFormData;

    protected AbstractRequestService(GenericParameterService parameterBuilder, RequestBodyService requestBodyService, OperationService operationService, Optional<List<ParameterCustomizer>> parameterCustomizers, LocalVariableTableParameterNameDiscoverer localSpringDocParameterNameDiscoverer) {
        this.parameterBuilder = parameterBuilder;
        this.requestBodyService = requestBodyService;
        this.operationService = operationService;
        parameterCustomizers.ifPresent(customizers -> customizers.removeIf(Objects::isNull));
        this.parameterCustomizers = parameterCustomizers;
        this.localSpringDocParameterNameDiscoverer = localSpringDocParameterNameDiscoverer;
        this.defaultFlatParamObject = parameterBuilder.getPropertyResolverUtils().getSpringDocConfigProperties().isDefaultFlatParamObject();
        this.defaultSupportFormData = parameterBuilder.getPropertyResolverUtils().getSpringDocConfigProperties().isDefaultSupportFormData();
    }

    public static void addRequestWrapperToIgnore(Class<?> ... classes) {
        PARAM_TYPES_TO_IGNORE.addAll(Arrays.asList(classes));
    }

    public static void removeRequestWrapperToIgnore(Class<?> ... classes) {
        List<Class<?>> classesToIgnore = Arrays.asList(classes);
        if (PARAM_TYPES_TO_IGNORE.containsAll(classesToIgnore)) {
            PARAM_TYPES_TO_IGNORE.removeAll(Arrays.asList(classes));
        }
    }

    public static boolean isRequestTypeToIgnore(Class<?> rawClass) {
        return PARAM_TYPES_TO_IGNORE.stream().anyMatch(clazz -> clazz.isAssignableFrom(rawClass));
    }

    public Operation build(HandlerMethod handlerMethod, RequestMethod requestMethod, Operation operation, MethodAttributes methodAttributes, OpenAPI openAPI) {
        io.swagger.v3.oas.models.parameters.Parameter parameter;
        String operationId = this.operationService.getOperationId(handlerMethod.getMethod().getName(), operation.getOperationId(), openAPI);
        operation.setOperationId(operationId);
        String[] pNames = this.localSpringDocParameterNameDiscoverer.getParameterNames(handlerMethod.getMethod());
        MethodParameter[] parameters = handlerMethod.getMethodParameters();
        String[] reflectionParametersNames = (String[])Arrays.stream(handlerMethod.getMethod().getParameters()).map(java.lang.reflect.Parameter::getName).toArray(String[]::new);
        if (pNames == null || Arrays.stream(pNames).anyMatch(Objects::isNull)) {
            pNames = reflectionParametersNames;
        }
        parameters = DelegatingMethodParameter.customize(pNames, parameters, this.parameterBuilder.getDelegatingMethodParameterCustomizer(), this.defaultFlatParamObject);
        RequestBodyInfo requestBodyInfo = new RequestBodyInfo();
        List operationParameters = operation.getParameters() != null ? operation.getParameters() : new ArrayList();
        Map<String, Parameter> parametersDocMap = this.getApiParameters(handlerMethod.getMethod());
        Components components = openAPI.getComponents();
        JavadocProvider javadocProvider = this.operationService.getJavadocProvider();
        for (MethodParameter methodParameter : parameters) {
            io.swagger.v3.oas.annotations.media.Schema schema;
            Parameter parameterDoc = (Parameter)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)AnnotatedElementUtils.forAnnotations((Annotation[])methodParameter.getParameterAnnotations()), Parameter.class);
            String pName = methodParameter.getParameterName();
            ParameterInfo parameterInfo = new ParameterInfo(pName, methodParameter, this.parameterBuilder);
            if (parameterDoc == null) {
                parameterDoc = parametersDocMap.get(parameterInfo.getpName());
            }
            if (parameterDoc == null && (schema = (io.swagger.v3.oas.annotations.media.Schema)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)AnnotatedElementUtils.forAnnotations((Annotation[])methodParameter.getParameterAnnotations()), io.swagger.v3.oas.annotations.media.Schema.class)) != null) {
                parameterDoc = this.parameterBuilder.generateParameterBySchema(schema);
            }
            if (parameterDoc != null) {
                if (parameterDoc.hidden() || parameterDoc.schema().hidden()) continue;
                parameter = this.parameterBuilder.buildParameterFromDoc(parameterDoc, components, methodAttributes.getJsonViewAnnotation(), methodAttributes.getLocale());
                parameterInfo.setParameterModel(parameter);
            }
            if (this.isParamToIgnore(methodParameter)) continue;
            parameter = this.buildParams(parameterInfo, components, requestMethod, methodAttributes.getJsonViewAnnotation(), openAPI.getOpenapi());
            parameter = GenericParameterService.mergeParameter(operationParameters, parameter);
            List<Annotation> parameterAnnotations = Arrays.asList(methodParameter.getParameterAnnotations());
            if (this.isValidParameter(parameter)) {
                if (StringUtils.isBlank((CharSequence)parameter.getDescription()) && javadocProvider != null && !StringUtils.isBlank((CharSequence)(paramJavadocDescription = this.getParamJavadoc(javadocProvider, methodParameter, pName)))) {
                    parameter.setDescription(paramJavadocDescription);
                }
                this.applyBeanValidatorAnnotations(parameter, parameterAnnotations);
            } else if (!RequestMethod.GET.equals((Object)requestMethod) || SpringDocConfigProperties.ApiDocs.OpenApiVersion.OPENAPI_3_1.getVersion().equals(openAPI.getOpenapi())) {
                if (operation.getRequestBody() != null) {
                    requestBodyInfo.setRequestBody(operation.getRequestBody());
                }
                this.requestBodyService.calculateRequestBodyInfo(components, methodAttributes, parameterInfo, requestBodyInfo);
                if (StringUtils.isBlank((CharSequence)requestBodyInfo.getRequestBody().getDescription()) && javadocProvider != null && !StringUtils.isBlank((CharSequence)(paramJavadocDescription = this.getParamJavadoc(javadocProvider, methodParameter, pName)))) {
                    requestBodyInfo.getRequestBody().setDescription(paramJavadocDescription);
                }
                this.applyBeanValidatorAnnotations(requestBodyInfo.getRequestBody(), parameterAnnotations, methodParameter.isOptional());
            }
            this.customiseParameter(parameter, parameterInfo, operationParameters);
        }
        LinkedHashMap<ParameterId, io.swagger.v3.oas.models.parameters.Parameter> map = this.getParameterLinkedHashMap(components, methodAttributes, operationParameters, parametersDocMap);
        io.swagger.v3.oas.models.parameters.RequestBody requestBody = requestBodyInfo.getRequestBody();
        if (this.defaultSupportFormData && requestBody != null && requestBody.getContent() != null && requestBody.getContent().containsKey((Object)"multipart/form-data")) {
            Iterator<Map.Entry<ParameterId, io.swagger.v3.oas.models.parameters.Parameter>> it = map.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<ParameterId, io.swagger.v3.oas.models.parameters.Parameter> entry = it.next();
                parameter = entry.getValue();
                if (ParameterIn.PATH.toString().equals(parameter.getIn()) || ParameterIn.HEADER.toString().equals(parameter.getIn()) || ParameterIn.COOKIE.toString().equals(parameter.getIn())) continue;
                Schema itemSchema = new Schema();
                itemSchema.setName(entry.getKey().getpName());
                itemSchema.setDescription(parameter.getDescription());
                itemSchema.setDeprecated(parameter.getDeprecated());
                if (parameter.getExample() != null) {
                    itemSchema.setExample(parameter.getExample());
                }
                requestBodyInfo.addProperties(entry.getKey().getpName(), itemSchema);
                it.remove();
            }
        }
        this.setParams(operation, new ArrayList<io.swagger.v3.oas.models.parameters.Parameter>(map.values()), requestBodyInfo);
        return operation;
    }

    private LinkedHashMap<ParameterId, io.swagger.v3.oas.models.parameters.Parameter> getParameterLinkedHashMap(Components components, MethodAttributes methodAttributes, List<io.swagger.v3.oas.models.parameters.Parameter> operationParameters, Map<String, Parameter> parametersDocMap) {
        LinkedHashMap map = operationParameters.stream().collect(Collectors.toMap(ParameterId::new, parameter -> parameter, (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        }, LinkedHashMap::new));
        for (Map.Entry<String, Parameter> entry : parametersDocMap.entrySet()) {
            ParameterId parameterId2 = new ParameterId(entry.getValue());
            if (entry.getKey() == null || map.containsKey(parameterId2) || entry.getValue().hidden()) continue;
            io.swagger.v3.oas.models.parameters.Parameter parameter2 = this.parameterBuilder.buildParameterFromDoc(entry.getValue(), components, methodAttributes.getJsonViewAnnotation(), methodAttributes.getLocale());
            map.put(parameterId2, parameter2);
        }
        AbstractRequestService.getHeaders(methodAttributes, map);
        map.forEach((parameterId, parameter) -> {
            if (StringUtils.isBlank((CharSequence)parameter.getIn()) && StringUtils.isBlank((CharSequence)parameter.get$ref())) {
                parameter.setIn(ParameterIn.QUERY.toString());
            }
        });
        return map;
    }

    public static Collection<io.swagger.v3.oas.models.parameters.Parameter> getHeaders(MethodAttributes methodAttributes, Map<ParameterId, io.swagger.v3.oas.models.parameters.Parameter> map) {
        for (Map.Entry<String, String> entry : methodAttributes.getHeaders().entrySet()) {
            io.swagger.v3.oas.models.parameters.Parameter parameter;
            ParameterId parameterId;
            StringSchema schema = new StringSchema();
            if (StringUtils.isNotEmpty((CharSequence)entry.getValue())) {
                schema.addEnumItem(entry.getValue());
            }
            if (map.containsKey(parameterId = new ParameterId(parameter = new io.swagger.v3.oas.models.parameters.Parameter().in(ParameterIn.HEADER.toString()).name(entry.getKey()).schema((Schema)schema)))) {
                parameter = map.get(parameterId);
                List existingEnum = null;
                if (parameter.getSchema() != null && !CollectionUtils.isEmpty((Collection)parameter.getSchema().getEnum())) {
                    existingEnum = parameter.getSchema().getEnum();
                }
                if (StringUtils.isNotEmpty((CharSequence)entry.getValue()) && (existingEnum == null || !existingEnum.contains(entry.getValue()))) {
                    parameter.getSchema().addEnumItemObject((Object)entry.getValue());
                }
                parameter.setSchema(parameter.getSchema());
            }
            map.put(parameterId, parameter);
        }
        return map.values();
    }

    protected void customiseParameter(io.swagger.v3.oas.models.parameters.Parameter parameter, ParameterInfo parameterInfo, List<io.swagger.v3.oas.models.parameters.Parameter> operationParameters) {
        if (this.parameterCustomizers.isPresent()) {
            List<ParameterCustomizer> parameterCustomizerList = this.parameterCustomizers.get();
            int index = operationParameters.indexOf(parameter);
            for (ParameterCustomizer parameterCustomizer : parameterCustomizerList) {
                parameter = parameterCustomizer.customize(parameter, parameterInfo.getMethodParameter());
            }
            if (index != -1) {
                operationParameters.set(index, parameter);
            }
        }
    }

    public boolean isParamToIgnore(MethodParameter parameter) {
        if (SpringDocAnnotationsUtils.isAnnotationToIgnore(parameter)) {
            return true;
        }
        if (this.isRequiredAnnotation(parameter)) {
            return false;
        }
        return AbstractRequestService.isRequestTypeToIgnore(parameter.getParameterType());
    }

    private boolean isRequiredAnnotation(MethodParameter parameter) {
        RequestParam requestParam = (RequestParam)parameter.getParameterAnnotation(RequestParam.class);
        PathVariable pathVariable = (PathVariable)parameter.getParameterAnnotation(PathVariable.class);
        RequestBody requestBody = (RequestBody)parameter.getParameterAnnotation(RequestBody.class);
        return requestParam != null && requestParam.required() || pathVariable != null && pathVariable.required() || requestBody != null && requestBody.required();
    }

    private void setParams(Operation operation, List<io.swagger.v3.oas.models.parameters.Parameter> operationParameters, RequestBodyInfo requestBodyInfo) {
        if (!CollectionUtils.isEmpty(operationParameters)) {
            operation.setParameters(operationParameters);
        }
        if (requestBodyInfo.getRequestBody() != null) {
            operation.setRequestBody(requestBodyInfo.getRequestBody());
        }
    }

    public boolean isValidParameter(io.swagger.v3.oas.models.parameters.Parameter parameter) {
        return parameter != null && (parameter.getName() != null || parameter.get$ref() != null);
    }

    public io.swagger.v3.oas.models.parameters.Parameter buildParams(ParameterInfo parameterInfo, Components components, RequestMethod requestMethod, JsonView jsonView, String openApiVersion) {
        MethodParameter methodParameter = parameterInfo.getMethodParameter();
        if (parameterInfo.getParamType() != null) {
            if (!"\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n".equals(parameterInfo.getDefaultValue())) {
                parameterInfo.setRequired(false);
            } else {
                parameterInfo.setDefaultValue(null);
            }
            return this.buildParam(parameterInfo, components, jsonView);
        }
        if (!this.isRequestBodyParam(requestMethod, parameterInfo, openApiVersion)) {
            parameterInfo.setRequired(!((DelegatingMethodParameter)methodParameter).isNotRequired() && !methodParameter.isOptional());
            parameterInfo.setDefaultValue(null);
            return this.buildParam(parameterInfo, components, jsonView);
        }
        return null;
    }

    public io.swagger.v3.oas.models.parameters.Parameter buildParam(ParameterInfo parameterInfo, Components components, JsonView jsonView) {
        io.swagger.v3.oas.models.parameters.Parameter parameter = parameterInfo.getParameterModel();
        String name = parameterInfo.getpName();
        if (parameter == null) {
            parameter = new io.swagger.v3.oas.models.parameters.Parameter();
            parameterInfo.setParameterModel(parameter);
        }
        if (StringUtils.isBlank((CharSequence)parameter.getName())) {
            parameter.setName(name);
        }
        if (StringUtils.isBlank((CharSequence)parameter.getIn())) {
            parameter.setIn(parameterInfo.getParamType());
        }
        if (parameter.getRequired() == null) {
            parameter.setRequired(Boolean.valueOf(parameterInfo.isRequired()));
        }
        if (SchemaPropertyDeprecatingConverter.containsDeprecatedAnnotation(parameterInfo.getMethodParameter().getParameterAnnotations())) {
            parameter.setDeprecated(Boolean.valueOf(true));
        }
        if (parameter.getSchema() == null && parameter.getContent() == null) {
            Schema schema = this.parameterBuilder.calculateSchema(components, parameterInfo, null, jsonView);
            if (parameterInfo.getDefaultValue() != null && schema != null) {
                Object defaultValue = parameterInfo.getDefaultValue();
                PrimitiveType primitiveType = PrimitiveType.fromTypeAndFormat((String)schema.getType(), (String)schema.getFormat());
                if (primitiveType != null) {
                    Schema primitiveSchema = primitiveType.createProperty();
                    primitiveSchema.setDefault(parameterInfo.getDefaultValue());
                    defaultValue = primitiveSchema.getDefault();
                }
                schema.setDefault(defaultValue);
            }
            parameter.setSchema(schema);
        }
        return parameter;
    }

    public void applyBeanValidatorAnnotations(io.swagger.v3.oas.models.parameters.Parameter parameter, List<Annotation> annotations) {
        HashMap<String, Annotation> annos = new HashMap<String, Annotation>();
        if (annotations != null) {
            annotations.forEach(annotation -> annos.put(annotation.annotationType().getSimpleName(), (Annotation)annotation));
        }
        boolean annotationExists = Arrays.stream(ANNOTATIONS_FOR_REQUIRED).anyMatch(annos::containsKey);
        if (annotationExists) {
            parameter.setRequired(Boolean.valueOf(true));
        }
        Schema schema = parameter.getSchema();
        this.applyValidationsToSchema(annos, schema);
    }

    public void applyBeanValidatorAnnotations(io.swagger.v3.oas.models.parameters.RequestBody requestBody, List<Annotation> annotations, boolean isOptional) {
        HashMap<String, Annotation> annos = new HashMap<String, Annotation>();
        boolean requestBodyRequired = false;
        if (!CollectionUtils.isEmpty(annotations)) {
            annotations.forEach(annotation -> annos.put(annotation.annotationType().getSimpleName(), (Annotation)annotation));
            requestBodyRequired = annotations.stream().filter(annotation -> RequestBody.class.equals(annotation.annotationType())).anyMatch(annotation -> ((RequestBody)annotation).required());
        }
        boolean validationExists = Arrays.stream(ANNOTATIONS_FOR_REQUIRED).anyMatch(annos::containsKey);
        if (validationExists || !isOptional && requestBodyRequired) {
            requestBody.setRequired(Boolean.valueOf(true));
        }
        Content content = requestBody.getContent();
        for (MediaType mediaType : content.values()) {
            Schema schema = mediaType.getSchema();
            this.applyValidationsToSchema(annos, schema);
        }
    }

    private void calculateSize(Map<String, Annotation> annos, Schema<?> schema) {
        if (annos.containsKey(Size.class.getSimpleName())) {
            Size size = (Size)annos.get(Size.class.getSimpleName());
            if ("array".equals(schema.getType())) {
                schema.setMinItems(Integer.valueOf(size.min()));
                schema.setMaxItems(Integer.valueOf(size.max()));
            } else if ("string".equals(schema.getType())) {
                schema.setMinLength(Integer.valueOf(size.min()));
                schema.setMaxLength(Integer.valueOf(size.max()));
            }
        }
    }

    public RequestBodyService getRequestBodyBuilder() {
        return this.requestBodyService;
    }

    private Map<String, Parameter> getApiParameters(Method method) {
        Class<?> declaringClass = method.getDeclaringClass();
        Set apiParametersDoc = AnnotatedElementUtils.findAllMergedAnnotations((AnnotatedElement)method, Parameters.class);
        LinkedHashMap apiParametersMap = apiParametersDoc.stream().flatMap(x -> Stream.of(x.value())).collect(Collectors.toMap(Parameter::name, x -> x, (e1, e2) -> e2, LinkedHashMap::new));
        Set apiParametersDocDeclaringClass = AnnotatedElementUtils.findAllMergedAnnotations(declaringClass, Parameters.class);
        LinkedHashMap apiParametersDocDeclaringClassMap = apiParametersDocDeclaringClass.stream().flatMap(x -> Stream.of(x.value())).collect(Collectors.toMap(Parameter::name, x -> x, (e1, e2) -> e2, LinkedHashMap::new));
        apiParametersMap.putAll(apiParametersDocDeclaringClassMap);
        Set apiParameterDoc = AnnotatedElementUtils.findAllMergedAnnotations((AnnotatedElement)method, Parameter.class);
        LinkedHashMap apiParameterDocMap = apiParameterDoc.stream().collect(Collectors.toMap(Parameter::name, x -> x, (e1, e2) -> e2, LinkedHashMap::new));
        apiParametersMap.putAll(apiParameterDocMap);
        Set apiParameterDocDeclaringClass = AnnotatedElementUtils.findAllMergedAnnotations(declaringClass, Parameter.class);
        LinkedHashMap apiParameterDocDeclaringClassMap = apiParameterDocDeclaringClass.stream().collect(Collectors.toMap(Parameter::name, x -> x, (e1, e2) -> e2, LinkedHashMap::new));
        apiParametersMap.putAll(apiParameterDocDeclaringClassMap);
        return apiParametersMap;
    }

    private void applyValidationsToSchema(Map<String, Annotation> annos, Schema<?> schema) {
        Max max;
        Min min;
        if (annos.containsKey(Min.class.getSimpleName())) {
            min = (Min)annos.get(Min.class.getSimpleName());
            schema.setMinimum(BigDecimal.valueOf(min.value()));
        }
        if (annos.containsKey(Max.class.getSimpleName())) {
            max = (Max)annos.get(Max.class.getSimpleName());
            schema.setMaximum(BigDecimal.valueOf(max.value()));
        }
        this.calculateSize(annos, schema);
        if (annos.containsKey(DecimalMin.class.getSimpleName())) {
            min = (DecimalMin)annos.get(DecimalMin.class.getSimpleName());
            if (min.inclusive()) {
                schema.setMinimum(BigDecimal.valueOf(Double.parseDouble(min.value())));
            } else {
                schema.setExclusiveMinimum(Boolean.valueOf(true));
            }
        }
        if (annos.containsKey(DecimalMax.class.getSimpleName())) {
            max = (DecimalMax)annos.get(DecimalMax.class.getSimpleName());
            if (max.inclusive()) {
                schema.setMaximum(BigDecimal.valueOf(Double.parseDouble(max.value())));
            } else {
                schema.setExclusiveMaximum(Boolean.valueOf(true));
            }
        }
        if (annos.containsKey(POSITIVE_OR_ZERO)) {
            schema.setMinimum(BigDecimal.ZERO);
        }
        if (annos.containsKey(NEGATIVE_OR_ZERO)) {
            schema.setMaximum(BigDecimal.ZERO);
        }
        if (annos.containsKey(Pattern.class.getSimpleName())) {
            Pattern pattern = (Pattern)annos.get(Pattern.class.getSimpleName());
            schema.setPattern(pattern.regexp());
        }
    }

    private boolean isRequestBodyParam(RequestMethod requestMethod, ParameterInfo parameterInfo, String openApiVersion) {
        MethodParameter methodParameter = parameterInfo.getMethodParameter();
        DelegatingMethodParameter delegatingMethodParameter = (DelegatingMethodParameter)methodParameter;
        Boolean isBodyAllowed = !RequestMethod.GET.equals((Object)requestMethod) || SpringDocConfigProperties.ApiDocs.OpenApiVersion.OPENAPI_3_1.getVersion().equals(openApiVersion);
        return isBodyAllowed != false && (parameterInfo.getParameterModel() == null || parameterInfo.getParameterModel().getIn() == null) && !delegatingMethodParameter.isParameterObject() && (methodParameter.getParameterAnnotation(io.swagger.v3.oas.annotations.parameters.RequestBody.class) != null || methodParameter.getParameterAnnotation(RequestBody.class) != null || methodParameter.getParameterAnnotation(RequestPart.class) != null || AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)Objects.requireNonNull(methodParameter.getMethod()), io.swagger.v3.oas.annotations.parameters.RequestBody.class) != null || !ClassUtils.isPrimitiveOrWrapper((Class)methodParameter.getParameterType()) && !ArrayUtils.isEmpty((Object[])methodParameter.getParameterAnnotations()));
    }

    private String getParamJavadoc(JavadocProvider javadocProvider, MethodParameter methodParameter, String pName) {
        String paramJavadocDescription;
        DelegatingMethodParameter delegatingMethodParameter = (DelegatingMethodParameter)methodParameter;
        if (delegatingMethodParameter.isParameterObject()) {
            String fieldName = StringUtils.isNotEmpty((CharSequence)pName) && pName.contains(".") ? StringUtils.substringAfterLast((String)pName, (String)".") : pName;
            Field field = FieldUtils.getDeclaredField(((DelegatingMethodParameter)methodParameter).getExecutable().getDeclaringClass(), (String)fieldName, (boolean)true);
            paramJavadocDescription = javadocProvider.getFieldJavadoc(field);
        } else {
            paramJavadocDescription = javadocProvider.getParamJavadoc(methodParameter.getMethod(), pName);
        }
        return paramJavadocDescription;
    }

    public boolean isDefaultFlatParamObject() {
        return this.defaultFlatParamObject;
    }

    static {
        PARAM_TYPES_TO_IGNORE.add(WebRequest.class);
        PARAM_TYPES_TO_IGNORE.add(NativeWebRequest.class);
        PARAM_TYPES_TO_IGNORE.add(Principal.class);
        PARAM_TYPES_TO_IGNORE.add(HttpMethod.class);
        PARAM_TYPES_TO_IGNORE.add(Locale.class);
        PARAM_TYPES_TO_IGNORE.add(TimeZone.class);
        PARAM_TYPES_TO_IGNORE.add(InputStream.class);
        PARAM_TYPES_TO_IGNORE.add(ZoneId.class);
        PARAM_TYPES_TO_IGNORE.add(Reader.class);
        PARAM_TYPES_TO_IGNORE.add(OutputStream.class);
        PARAM_TYPES_TO_IGNORE.add(Writer.class);
        PARAM_TYPES_TO_IGNORE.add(Map.class);
        PARAM_TYPES_TO_IGNORE.add(Model.class);
        PARAM_TYPES_TO_IGNORE.add(ModelMap.class);
        PARAM_TYPES_TO_IGNORE.add(Errors.class);
        PARAM_TYPES_TO_IGNORE.add(BindingResult.class);
        PARAM_TYPES_TO_IGNORE.add(SessionStatus.class);
        PARAM_TYPES_TO_IGNORE.add(UriComponentsBuilder.class);
        PARAM_TYPES_TO_IGNORE.add(RequestAttribute.class);
    }
}

