/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core.converters;

import com.fasterxml.jackson.databind.JavaType;
import io.swagger.v3.core.converter.AnnotatedType;
import io.swagger.v3.core.converter.ModelConverter;
import io.swagger.v3.core.converter.ModelConverterContext;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.springdoc.core.providers.ObjectMapperProvider;

public class PolymorphicModelConverter
implements ModelConverter {
    private final ObjectMapperProvider springDocObjectMapper;

    public PolymorphicModelConverter(ObjectMapperProvider springDocObjectMapper) {
        this.springDocObjectMapper = springDocObjectMapper;
    }

    public Schema resolve(AnnotatedType type, ModelConverterContext context, Iterator<ModelConverter> chain) {
        JavaType javaType = this.springDocObjectMapper.jsonMapper().constructType(type.getType());
        if (javaType != null && chain.hasNext()) {
            Schema<?> resolvedSchema = chain.next().resolve(type, context, chain);
            if ((resolvedSchema = PolymorphicModelConverter.getResolvedSchema(javaType, resolvedSchema)) == null || resolvedSchema.get$ref() == null) {
                return resolvedSchema;
            }
            return this.composePolymorphicSchema(type, resolvedSchema, context.getDefinedModels().values());
        }
        return null;
    }

    private static Schema<?> getResolvedSchema(JavaType javaType, Schema<?> resolvedSchema) {
        if (resolvedSchema instanceof ObjectSchema && resolvedSchema.getProperties() != null) {
            if (resolvedSchema.getProperties().containsKey(javaType.getRawClass().getName())) {
                resolvedSchema = (Schema)resolvedSchema.getProperties().get(javaType.getRawClass().getName());
            } else if (resolvedSchema.getProperties().containsKey(javaType.getRawClass().getSimpleName())) {
                resolvedSchema = (Schema)resolvedSchema.getProperties().get(javaType.getRawClass().getSimpleName());
            }
        }
        return resolvedSchema;
    }

    private Schema composePolymorphicSchema(AnnotatedType type, Schema schema, Collection<Schema> schemas) {
        String ref = schema.get$ref();
        List<Schema> composedSchemas = schemas.stream().filter(ComposedSchema.class::isInstance).map(ComposedSchema.class::cast).filter(s -> s.getAllOf() != null).filter(s -> s.getAllOf().stream().anyMatch(s2 -> ref.equals(s2.get$ref()))).map(s -> new Schema().$ref("#/components/schemas/" + s.getName())).collect(Collectors.toList());
        if (composedSchemas.isEmpty()) {
            return schema;
        }
        ComposedSchema result = new ComposedSchema();
        if (this.isConcreteClass(type)) {
            result.addOneOfItem(schema);
        }
        composedSchemas.forEach(arg_0 -> ((ComposedSchema)result).addOneOfItem(arg_0));
        return result;
    }

    private boolean isConcreteClass(AnnotatedType type) {
        JavaType javaType = this.springDocObjectMapper.jsonMapper().constructType(type.getType());
        Class clazz = javaType.getRawClass();
        return !Modifier.isAbstract(clazz.getModifiers()) && !clazz.isInterface();
    }
}

