/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core.configuration;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.querydsl.core.types.Predicate;
import java.util.Optional;
import org.springdoc.core.configuration.SpringDocConfiguration;
import org.springdoc.core.converters.models.DefaultPageable;
import org.springdoc.core.customizers.QuerydslPredicateOperationCustomizer;
import org.springdoc.core.data.DataRestOperationService;
import org.springdoc.core.data.DataRestRequestService;
import org.springdoc.core.data.DataRestResponseService;
import org.springdoc.core.data.DataRestRouterOperationService;
import org.springdoc.core.data.DataRestTagsService;
import org.springdoc.core.properties.SpringDocConfigProperties;
import org.springdoc.core.providers.DataRestHalProvider;
import org.springdoc.core.providers.ObjectMapperProvider;
import org.springdoc.core.providers.SpringRepositoryRestResourceProvider;
import org.springdoc.core.service.AbstractRequestService;
import org.springdoc.core.service.GenericParameterService;
import org.springdoc.core.service.GenericResponseService;
import org.springdoc.core.service.OpenAPIService;
import org.springdoc.core.service.OperationService;
import org.springdoc.core.service.RequestBodyService;
import org.springdoc.core.utils.SpringDocDataRestUtils;
import org.springdoc.core.utils.SpringDocUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.hateoas.HateoasProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Primary;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.data.domain.Sort;
import org.springframework.data.mapping.context.PersistentEntities;
import org.springframework.data.querydsl.binding.QuerydslBindingsFactory;
import org.springframework.data.repository.support.Repositories;
import org.springframework.data.rest.core.config.RepositoryRestConfiguration;
import org.springframework.data.rest.core.mapping.ResourceMappings;
import org.springframework.data.rest.webmvc.PersistentEntityResourceAssembler;
import org.springframework.data.rest.webmvc.RepositoryRestHandlerMapping;
import org.springframework.data.rest.webmvc.RootResourceInformation;
import org.springframework.data.rest.webmvc.mapping.Associations;
import org.springframework.data.rest.webmvc.support.DefaultedPageable;
import org.springframework.data.rest.webmvc.support.ETag;
import org.springframework.hateoas.server.LinkRelationProvider;

@Lazy(value=false)
@Configuration(proxyBeanMethods=false)
@ConditionalOnExpression(value="${springdoc.api-docs.enabled:true} and ${springdoc.enable-data-rest:true}")
@ConditionalOnClass(value={RepositoryRestConfiguration.class})
@ConditionalOnWebApplication
@ConditionalOnBean(value={SpringDocConfiguration.class})
public class SpringDocDataRestConfiguration {
    @Bean
    @ConditionalOnMissingBean
    @Primary
    @Lazy(value=false)
    DataRestHalProvider halProvider(Optional<RepositoryRestConfiguration> repositoryRestConfiguration, Optional<HateoasProperties> hateoasPropertiesOptional, ObjectMapperProvider objectMapperProvider) {
        return new DataRestHalProvider(repositoryRestConfiguration, hateoasPropertiesOptional, objectMapperProvider);
    }

    @Lazy(value=false)
    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={RepositoryRestHandlerMapping.class})
    static class SpringRepositoryRestResourceProviderConfiguration {
        SpringRepositoryRestResourceProviderConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        @Lazy(value=false)
        SpringRepositoryRestResourceProvider springRepositoryRestResourceProvider(ResourceMappings mappings, Repositories repositories, Associations associations, ApplicationContext applicationContext, DataRestRouterOperationService dataRestRouterOperationService, PersistentEntities persistentEntities, ObjectMapper mapper, SpringDocDataRestUtils springDocDataRestUtils) {
            return new SpringRepositoryRestResourceProvider(mappings, repositories, associations, applicationContext, dataRestRouterOperationService, persistentEntities, mapper, springDocDataRestUtils);
        }

        @Bean
        @ConditionalOnMissingBean
        @Lazy(value=false)
        DataRestRouterOperationService dataRestRouterOperationBuilder(DataRestOperationService dataRestOperationService, SpringDocConfigProperties springDocConfigProperties, RepositoryRestConfiguration repositoryRestConfiguration, DataRestHalProvider dataRestHalProvider) {
            return new DataRestRouterOperationService(dataRestOperationService, springDocConfigProperties, repositoryRestConfiguration, dataRestHalProvider);
        }

        @Bean
        @ConditionalOnMissingBean
        @Lazy(value=false)
        DataRestOperationService dataRestOperationBuilder(DataRestRequestService dataRestRequestService, DataRestTagsService tagsBuilder, DataRestResponseService dataRestResponseService, OperationService operationService) {
            return new DataRestOperationService(dataRestRequestService, tagsBuilder, dataRestResponseService, operationService);
        }

        @Bean
        @ConditionalOnMissingBean
        @Lazy(value=false)
        DataRestRequestService dataRestRequestBuilder(LocalVariableTableParameterNameDiscoverer localSpringDocParameterNameDiscoverer, GenericParameterService parameterBuilder, RequestBodyService requestBodyService, AbstractRequestService requestBuilder, SpringDocDataRestUtils springDocDataRestUtils) {
            return new DataRestRequestService(localSpringDocParameterNameDiscoverer, parameterBuilder, requestBodyService, requestBuilder, springDocDataRestUtils);
        }

        @Bean
        @ConditionalOnMissingBean
        @Lazy(value=false)
        DataRestResponseService dataRestResponseBuilder(GenericResponseService genericResponseService, SpringDocDataRestUtils springDocDataRestUtils) {
            return new DataRestResponseService(genericResponseService, springDocDataRestUtils);
        }

        @Bean
        @ConditionalOnMissingBean
        @Lazy(value=false)
        DataRestTagsService dataRestTagsBuilder(OpenAPIService openAPIService) {
            return new DataRestTagsService(openAPIService);
        }

        @Bean
        @ConditionalOnMissingBean
        @Lazy(value=false)
        SpringDocDataRestUtils springDocDataRestUtils(LinkRelationProvider linkRelationProvider, RepositoryRestConfiguration repositoryRestConfiguration) {
            return new SpringDocDataRestUtils(linkRelationProvider, repositoryRestConfiguration);
        }

        static {
            SpringDocUtils.getConfig().replaceParameterObjectWithClass(DefaultedPageable.class, DefaultPageable.class).addRequestWrapperToIgnore(RootResourceInformation.class, PersistentEntityResourceAssembler.class, ETag.class, Sort.class).addResponseWrapperToIgnore(RootResourceInformation.class);
        }
    }

    @ConditionalOnClass(value={QuerydslBindingsFactory.class})
    class QuerydslProvider {
        QuerydslProvider() {
        }

        @Bean
        @ConditionalOnMissingBean
        @Lazy(value=false)
        QuerydslPredicateOperationCustomizer queryDslQuerydslPredicateOperationCustomizer(Optional<QuerydslBindingsFactory> querydslBindingsFactory) {
            if (querydslBindingsFactory.isPresent()) {
                SpringDocUtils.getConfig().addRequestWrapperToIgnore(Predicate.class);
                return new QuerydslPredicateOperationCustomizer(querydslBindingsFactory.get());
            }
            return null;
        }
    }
}

