/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.api;

import com.fasterxml.jackson.annotation.JsonView;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import io.swagger.v3.core.filter.SpecFilter;
import io.swagger.v3.core.util.ReflectionUtils;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.callbacks.Callback;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.responses.ApiResponses;
import io.swagger.v3.oas.models.servers.Server;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springdoc.core.annotations.RouterOperations;
import org.springdoc.core.converters.SchemaPropertyDeprecatingConverter;
import org.springdoc.core.customizers.OpenApiCustomizer;
import org.springdoc.core.customizers.OpenApiLocaleCustomizer;
import org.springdoc.core.customizers.OperationCustomizer;
import org.springdoc.core.filters.OpenApiMethodFilter;
import org.springdoc.core.fn.AbstractRouterFunctionVisitor;
import org.springdoc.core.fn.RouterFunctionData;
import org.springdoc.core.fn.RouterOperation;
import org.springdoc.core.models.MethodAttributes;
import org.springdoc.core.properties.SpringDocConfigProperties;
import org.springdoc.core.providers.ActuatorProvider;
import org.springdoc.core.providers.CloudFunctionProvider;
import org.springdoc.core.providers.JavadocProvider;
import org.springdoc.core.providers.ObjectMapperProvider;
import org.springdoc.core.providers.SpringDocProviders;
import org.springdoc.core.service.AbstractRequestService;
import org.springdoc.core.service.GenericParameterService;
import org.springdoc.core.service.GenericResponseService;
import org.springdoc.core.service.OpenAPIService;
import org.springdoc.core.service.OperationService;
import org.springdoc.core.utils.Constants;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.env.Environment;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.method.HandlerMethod;

public abstract class AbstractOpenApiResource
extends SpecFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractOpenApiResource.class);
    private static final List<Class<?>> ADDITIONAL_REST_CONTROLLERS = Collections.synchronizedList(new ArrayList());
    private static final List<Class<?>> HIDDEN_REST_CONTROLLERS = Collections.synchronizedList(new ArrayList());
    protected OpenAPIService openAPIService;
    private final ObjectFactory<OpenAPIService> openAPIBuilderObjectFactory;
    protected final SpringDocConfigProperties springDocConfigProperties;
    private final AbstractRequestService requestBuilder;
    private final GenericResponseService responseBuilder;
    private final OperationService operationParser;
    private final Optional<List<OpenApiCustomizer>> openApiCustomizers;
    private final Optional<List<OperationCustomizer>> operationCustomizers;
    private final Optional<List<OpenApiMethodFilter>> methodFilters;
    private final AntPathMatcher antPathMatcher = new AntPathMatcher();
    protected final String groupName;
    private static Class<?> modelAndViewClass;
    private final Map<String, OpenApiLocaleCustomizer> openApiLocaleCustomizers;
    protected final SpringDocProviders springDocProviders;

    protected AbstractOpenApiResource(String groupName, ObjectFactory<OpenAPIService> openAPIBuilderObjectFactory, AbstractRequestService requestBuilder, GenericResponseService responseBuilder, OperationService operationParser, Optional<List<OperationCustomizer>> operationCustomizers, Optional<List<OpenApiCustomizer>> openApiCustomizers, Optional<List<OpenApiMethodFilter>> methodFilters, SpringDocConfigProperties springDocConfigProperties, SpringDocProviders springDocProviders) {
        this.groupName = Objects.requireNonNull(groupName, "groupName");
        this.openAPIBuilderObjectFactory = openAPIBuilderObjectFactory;
        this.openAPIService = (OpenAPIService)openAPIBuilderObjectFactory.getObject();
        this.requestBuilder = requestBuilder;
        this.responseBuilder = responseBuilder;
        this.operationParser = operationParser;
        this.openApiCustomizers = openApiCustomizers;
        this.methodFilters = methodFilters;
        this.springDocProviders = springDocProviders;
        Map existingOpenApiCustomizers = this.openAPIService.getContext().getBeansOfType(OpenApiCustomizer.class);
        if (!CollectionUtils.isEmpty((Map)existingOpenApiCustomizers) && existingOpenApiCustomizers.containsKey("linksSchemaCustomizer")) {
            openApiCustomizers.ifPresent(openApiCustomizersList -> openApiCustomizersList.add((OpenApiCustomizer)existingOpenApiCustomizers.get("linksSchemaCustomizer")));
        }
        this.springDocConfigProperties = springDocConfigProperties;
        operationCustomizers.ifPresent(customizers -> customizers.removeIf(Objects::isNull));
        this.operationCustomizers = operationCustomizers;
        if (springDocConfigProperties.isPreLoadingEnabled()) {
            Executors.newSingleThreadExecutor().execute(this::getOpenApi);
        }
        this.openApiLocaleCustomizers = this.openAPIService.getContext().getBeansOfType(OpenApiLocaleCustomizer.class);
    }

    private void getOpenApi() {
        this.getOpenApi(Locale.getDefault());
    }

    public static void addRestControllers(Class<?> ... classes) {
        ADDITIONAL_REST_CONTROLLERS.addAll(Arrays.asList(classes));
    }

    public static void addHiddenRestControllers(Class<?> ... classes) {
        HIDDEN_REST_CONTROLLERS.addAll(Arrays.asList(classes));
    }

    public static void addHiddenRestControllers(String ... classes) {
        HashSet hiddenClasses = new HashSet();
        for (String aClass : classes) {
            try {
                hiddenClasses.add(Class.forName(aClass));
            }
            catch (ClassNotFoundException e) {
                LOGGER.warn("The following class doesn't exist and cannot be hidden: {}", (Object)aClass);
            }
        }
        HIDDEN_REST_CONTROLLERS.addAll(hiddenClasses);
    }

    protected synchronized OpenAPI getOpenApi(Locale locale) {
        OpenAPI openAPI;
        Locale finalLocale;
        Locale locale2 = finalLocale = locale == null ? Locale.getDefault() : locale;
        if (this.openAPIService.getCachedOpenAPI(finalLocale) == null || this.springDocConfigProperties.isCacheDisabled()) {
            Instant start = Instant.now();
            openAPI = this.openAPIService.build(finalLocale);
            Map<String, Object> mappingsMap = this.openAPIService.getMappingsMap().entrySet().stream().filter(controller -> AnnotationUtils.findAnnotation(controller.getValue().getClass(), Hidden.class) == null).filter(controller -> !AbstractOpenApiResource.isHiddenRestControllers(controller.getValue().getClass())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a1, a2) -> a1));
            Map<String, Object> findControllerAdvice = this.openAPIService.getControllerAdviceMap();
            if (SpringDocConfigProperties.ApiDocs.OpenApiVersion.OPENAPI_3_1 == this.springDocConfigProperties.getApiDocs().getVersion()) {
                openAPI.openapi(SpringDocConfigProperties.ApiDocs.OpenApiVersion.OPENAPI_3_1.getVersion());
            }
            if (this.springDocConfigProperties.isDefaultOverrideWithGenericResponse()) {
                if (!CollectionUtils.isEmpty(mappingsMap)) {
                    findControllerAdvice.putAll(mappingsMap);
                }
                this.responseBuilder.buildGenericResponse(openAPI.getComponents(), findControllerAdvice, finalLocale);
            }
            this.getPaths(mappingsMap, finalLocale, openAPI);
            Optional<CloudFunctionProvider> cloudFunctionProviderOptional = this.springDocProviders.getSpringCloudFunctionProvider();
            cloudFunctionProviderOptional.ifPresent(cloudFunctionProvider -> {
                List<RouterOperation> routerOperationList = cloudFunctionProvider.getRouterOperations(openAPI);
                if (!CollectionUtils.isEmpty(routerOperationList)) {
                    this.calculatePath(routerOperationList, locale, openAPI);
                }
            });
            if (!CollectionUtils.isEmpty((Collection)openAPI.getServers())) {
                this.openAPIService.setServersPresent(true);
            }
            this.openAPIService.updateServers(openAPI);
            if (this.springDocConfigProperties.isRemoveBrokenReferenceDefinitions()) {
                this.removeBrokenReferenceDefinitions(openAPI);
            }
            List servers = openAPI.getServers();
            List serversCopy = null;
            try {
                serversCopy = (List)this.springDocProviders.jsonMapper().readValue(this.springDocProviders.jsonMapper().writeValueAsString((Object)servers), (TypeReference)new TypeReference<List<Server>>(){});
            }
            catch (JsonProcessingException e) {
                LOGGER.warn("Json Processing Exception occurred: {}", (Object)e.getMessage());
            }
            this.openApiLocaleCustomizers.values().forEach(openApiLocaleCustomizer -> openApiLocaleCustomizer.customise(openAPI, finalLocale));
            this.openApiCustomizers.ifPresent(apiCustomisers -> apiCustomisers.forEach(openApiCustomizer -> openApiCustomizer.customise(openAPI)));
            if (!CollectionUtils.isEmpty((Collection)openAPI.getServers()) && !openAPI.getServers().equals(serversCopy)) {
                this.openAPIService.setServersPresent(true);
            }
            this.openAPIService.setCachedOpenAPI(openAPI, finalLocale);
            LOGGER.info("Init duration for springdoc-openapi is: {} ms", (Object)Duration.between(start, Instant.now()).toMillis());
        } else {
            LOGGER.debug("Fetching openApi document from cache");
            openAPI = this.openAPIService.updateServers(this.openAPIService.getCachedOpenAPI(finalLocale));
        }
        return openAPI;
    }

    protected abstract void getPaths(Map<String, Object> var1, Locale var2, OpenAPI var3);

    protected void calculatePath(HandlerMethod handlerMethod, RouterOperation routerOperation, Locale locale, OpenAPI openAPI) {
        String operationPath = routerOperation.getPath();
        HashSet<RequestMethod> requestMethods = new HashSet<RequestMethod>(Arrays.asList(routerOperation.getMethods()));
        Operation apiOperation = routerOperation.getOperation();
        String[] methodConsumes = routerOperation.getConsumes();
        String[] methodProduces = routerOperation.getProduces();
        String[] headers = routerOperation.getHeaders();
        Map<String, String> queryParams = routerOperation.getQueryParams();
        Components components = openAPI.getComponents();
        Paths paths = openAPI.getPaths();
        Map operationMap = null;
        if (paths.containsKey((Object)operationPath)) {
            PathItem pathItem = (PathItem)paths.get((Object)operationPath);
            operationMap = pathItem.readOperationsMap();
        }
        JavadocProvider javadocProvider = this.operationParser.getJavadocProvider();
        for (RequestMethod requestMethod : requestMethods) {
            io.swagger.v3.oas.models.Operation operation;
            io.swagger.v3.oas.models.Operation existingOperation = this.getExistingOperation(operationMap, requestMethod);
            Method method = handlerMethod.getMethod();
            if (this.operationParser.isHidden(method)) continue;
            RequestMapping reqMappingClass = (RequestMapping)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)handlerMethod.getBeanType(), RequestMapping.class);
            MethodAttributes methodAttributes = new MethodAttributes(this.springDocConfigProperties.getDefaultConsumesMediaType(), this.springDocConfigProperties.getDefaultProducesMediaType(), methodConsumes, methodProduces, headers, locale);
            methodAttributes.setMethodOverloaded(existingOperation != null);
            if (javadocProvider != null) {
                methodAttributes.setJavadocReturn(javadocProvider.getMethodJavadocReturn(handlerMethod.getMethod()));
            }
            if (reqMappingClass != null) {
                methodAttributes.setClassConsumes(reqMappingClass.consumes());
                methodAttributes.setClassProduces(reqMappingClass.produces());
            }
            methodAttributes.calculateHeadersForClass(method.getDeclaringClass());
            methodAttributes.calculateConsumesProduces(method);
            io.swagger.v3.oas.models.Operation operation2 = operation = existingOperation != null ? existingOperation : new io.swagger.v3.oas.models.Operation();
            if (SchemaPropertyDeprecatingConverter.isDeprecated(method)) {
                operation.setDeprecated(Boolean.valueOf(true));
            }
            if (apiOperation == null || StringUtils.isBlank((CharSequence)apiOperation.operationId())) {
                apiOperation = (Operation)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, Operation.class);
            }
            this.calculateJsonView(apiOperation, methodAttributes, method);
            if (apiOperation != null) {
                openAPI = this.operationParser.parse(apiOperation, operation, openAPI, methodAttributes);
            }
            this.fillParametersList(operation, queryParams, methodAttributes);
            operation = this.openAPIService.buildTags(handlerMethod, operation, openAPI, locale);
            io.swagger.v3.oas.annotations.parameters.RequestBody requestBodyDoc = (io.swagger.v3.oas.annotations.parameters.RequestBody)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, io.swagger.v3.oas.annotations.parameters.RequestBody.class);
            this.requestBuilder.getRequestBodyBuilder().buildRequestBodyFromDoc(requestBodyDoc, methodAttributes, components, methodAttributes.getJsonViewAnnotationForRequestBody()).ifPresent(arg_0 -> ((io.swagger.v3.oas.models.Operation)operation).setRequestBody(arg_0));
            operation = this.requestBuilder.build(handlerMethod, requestMethod, operation, methodAttributes, openAPI);
            ApiResponses apiResponses = this.responseBuilder.build(components, handlerMethod, operation, methodAttributes);
            operation.setResponses(apiResponses);
            if (javadocProvider != null) {
                String description = javadocProvider.getMethodJavadocDescription(handlerMethod.getMethod());
                String summary = javadocProvider.getFirstSentence(description);
                boolean emptyOverrideDescription = StringUtils.isEmpty((CharSequence)operation.getDescription());
                boolean emptyOverrideSummary = StringUtils.isEmpty((CharSequence)operation.getSummary());
                if (!StringUtils.isEmpty((CharSequence)description) && emptyOverrideDescription) {
                    operation.setDescription(description);
                }
                if (!StringUtils.isEmpty((CharSequence)summary) && emptyOverrideSummary && emptyOverrideDescription) {
                    operation.setSummary(javadocProvider.getFirstSentence(description));
                }
            }
            Set apiCallbacks = AnnotatedElementUtils.findMergedRepeatableAnnotations((AnnotatedElement)method, Callback.class);
            this.buildCallbacks(openAPI, methodAttributes, operation, apiCallbacks);
            operation = this.customiseOperation(operation, handlerMethod);
            PathItem pathItemObject = this.buildPathItem(requestMethod, operation, operationPath, paths);
            paths.addPathItem(operationPath, pathItemObject);
        }
    }

    private void buildCallbacks(OpenAPI openAPI, MethodAttributes methodAttributes, io.swagger.v3.oas.models.Operation operation, Set<Callback> apiCallbacks) {
        if (!CollectionUtils.isEmpty(apiCallbacks)) {
            this.operationParser.buildCallbacks(apiCallbacks, openAPI, methodAttributes).ifPresent(arg_0 -> ((io.swagger.v3.oas.models.Operation)operation).setCallbacks(arg_0));
        }
    }

    protected void calculatePath(List<RouterOperation> routerOperationList, Locale locale, OpenAPI openAPI) {
        ApplicationContext applicationContext = this.openAPIService.getContext();
        if (!CollectionUtils.isEmpty(routerOperationList)) {
            Collections.sort(routerOperationList);
            for (RouterOperation routerOperation : routerOperationList) {
                if (routerOperation.getBeanClass() != null && !Void.class.equals(routerOperation.getBeanClass())) {
                    Object handlerBean = applicationContext.getBean(routerOperation.getBeanClass());
                    HandlerMethod handlerMethod = null;
                    if (!StringUtils.isNotBlank((CharSequence)routerOperation.getBeanMethod())) continue;
                    try {
                        if (ArrayUtils.isEmpty((Object[])routerOperation.getParameterTypes())) {
                            Method[] declaredMethods = AopUtils.getTargetClass((Object)handlerBean).getDeclaredMethods();
                            Optional<Method> methodOptional = Arrays.stream(declaredMethods).filter(method -> routerOperation.getBeanMethod().equals(method.getName()) && method.getParameters().length == 0).findAny();
                            if (!methodOptional.isPresent()) {
                                methodOptional = Arrays.stream(declaredMethods).filter(method1 -> routerOperation.getBeanMethod().equals(method1.getName())).findAny();
                            }
                            if (methodOptional.isPresent()) {
                                handlerMethod = new HandlerMethod(handlerBean, methodOptional.get());
                            }
                        } else {
                            handlerMethod = new HandlerMethod(handlerBean, routerOperation.getBeanMethod(), (Class[])routerOperation.getParameterTypes());
                        }
                    }
                    catch (NoSuchMethodException e) {
                        LOGGER.error(e.getMessage());
                    }
                    if (handlerMethod == null || !this.isFilterCondition(handlerMethod, routerOperation.getPath(), routerOperation.getProduces(), routerOperation.getConsumes(), routerOperation.getHeaders())) continue;
                    this.calculatePath(handlerMethod, routerOperation, locale, openAPI);
                    continue;
                }
                if (routerOperation.getOperation() != null && StringUtils.isNotBlank((CharSequence)routerOperation.getOperation().operationId()) && this.isFilterCondition(routerOperation.getPath(), routerOperation.getProduces(), routerOperation.getConsumes(), routerOperation.getHeaders())) {
                    this.calculatePath(routerOperation, locale, openAPI);
                    continue;
                }
                if (routerOperation.getOperationModel() == null || !StringUtils.isNotBlank((CharSequence)routerOperation.getOperationModel().getOperationId()) || !this.isFilterCondition(routerOperation.getPath(), routerOperation.getProduces(), routerOperation.getConsumes(), routerOperation.getHeaders())) continue;
                this.calculatePath(routerOperation, locale, openAPI);
            }
        }
    }

    protected void calculatePath(RouterOperation routerOperation, Locale locale, OpenAPI openAPI) {
        String operationPath = routerOperation.getPath();
        Operation apiOperation = routerOperation.getOperation();
        String[] methodConsumes = routerOperation.getConsumes();
        String[] methodProduces = routerOperation.getProduces();
        String[] headers = routerOperation.getHeaders();
        Map<String, String> queryParams = routerOperation.getQueryParams();
        Paths paths = openAPI.getPaths();
        Map operationMap = null;
        if (paths.containsKey((Object)operationPath)) {
            PathItem pathItem = (PathItem)paths.get((Object)operationPath);
            operationMap = pathItem.readOperationsMap();
        }
        for (RequestMethod requestMethod : routerOperation.getMethods()) {
            io.swagger.v3.oas.models.Operation existingOperation = this.getExistingOperation(operationMap, requestMethod);
            MethodAttributes methodAttributes = new MethodAttributes(this.springDocConfigProperties.getDefaultConsumesMediaType(), this.springDocConfigProperties.getDefaultProducesMediaType(), methodConsumes, methodProduces, headers, locale);
            methodAttributes.setMethodOverloaded(existingOperation != null);
            io.swagger.v3.oas.models.Operation operation = this.getOperation(routerOperation, existingOperation);
            if (apiOperation != null) {
                openAPI = this.operationParser.parse(apiOperation, operation, openAPI, methodAttributes);
            }
            String operationId = this.operationParser.getOperationId(operation.getOperationId(), openAPI);
            operation.setOperationId(operationId);
            this.fillParametersList(operation, queryParams, methodAttributes);
            if (!CollectionUtils.isEmpty((Collection)operation.getParameters())) {
                operation.getParameters().stream().filter(parameter -> StringUtils.isEmpty((CharSequence)parameter.get$ref())).forEach(parameter -> {
                    if (parameter.getSchema() == null) {
                        parameter.setSchema((Schema)new StringSchema());
                    }
                    if (parameter.getIn() == null) {
                        parameter.setIn(ParameterIn.QUERY.toString());
                    }
                });
            }
            PathItem pathItemObject = this.buildPathItem(requestMethod, operation, operationPath, paths);
            paths.addPathItem(operationPath, pathItemObject);
        }
    }

    protected void calculatePath(HandlerMethod handlerMethod, String operationPath, Set<RequestMethod> requestMethods, String[] consumes, String[] produces, String[] headers, Locale locale, OpenAPI openAPI) {
        this.calculatePath(handlerMethod, new RouterOperation(operationPath, requestMethods.toArray(new RequestMethod[requestMethods.size()]), consumes, produces, headers), locale, openAPI);
    }

    protected void getRouterFunctionPaths(String beanName, AbstractRouterFunctionVisitor routerFunctionVisitor, Locale locale, OpenAPI openAPI) {
        boolean withRouterOperation = routerFunctionVisitor.getRouterFunctionDatas().stream().anyMatch(routerFunctionData -> routerFunctionData.getAttributes().containsKey(Constants.OPERATION_ATTRIBUTE));
        if (withRouterOperation) {
            List<RouterOperation> operationList = routerFunctionVisitor.getRouterFunctionDatas().stream().map(RouterOperation::new).collect(Collectors.toList());
            this.calculatePath(operationList, locale, openAPI);
        } else {
            ArrayList<org.springdoc.core.annotations.RouterOperation> routerOperationList = new ArrayList<org.springdoc.core.annotations.RouterOperation>();
            ApplicationContext applicationContext = this.openAPIService.getContext();
            RouterOperations routerOperations = (RouterOperations)applicationContext.findAnnotationOnBean(beanName, RouterOperations.class);
            if (routerOperations == null) {
                org.springdoc.core.annotations.RouterOperation routerOperation2 = (org.springdoc.core.annotations.RouterOperation)applicationContext.findAnnotationOnBean(beanName, org.springdoc.core.annotations.RouterOperation.class);
                if (routerOperation2 != null) {
                    routerOperationList.add(routerOperation2);
                }
            } else {
                routerOperationList.addAll(Arrays.asList(routerOperations.value()));
            }
            if (routerOperationList.size() == 1) {
                this.calculatePath(routerOperationList.stream().map(routerOperation -> new RouterOperation((org.springdoc.core.annotations.RouterOperation)routerOperation, routerFunctionVisitor.getRouterFunctionDatas().get(0))).collect(Collectors.toList()), locale, openAPI);
            } else {
                List<RouterOperation> operationList = routerOperationList.stream().map(RouterOperation::new).collect(Collectors.toList());
                this.mergeRouters(routerFunctionVisitor.getRouterFunctionDatas(), operationList);
                this.calculatePath(operationList, locale, openAPI);
            }
        }
    }

    protected boolean isFilterCondition(HandlerMethod handlerMethod, String operationPath, String[] produces, String[] consumes, String[] headers) {
        return this.isMethodToFilter(handlerMethod) && this.isPackageToScan(handlerMethod.getBeanType().getPackage()) && this.isFilterCondition(operationPath, produces, consumes, headers);
    }

    protected boolean isMethodToFilter(HandlerMethod handlerMethod) {
        return this.methodFilters.map(Collection::stream).map(stream -> stream.allMatch(m -> m.isMethodToInclude(handlerMethod.getMethod()))).orElse(true);
    }

    protected boolean isConditionToMatch(String[] existingConditions, ConditionType conditionType) {
        Optional<SpringDocConfigProperties.GroupConfig> optionalGroupConfig;
        List<String> conditionsToMatch = this.getConditionsToMatch(conditionType, new SpringDocConfigProperties.GroupConfig[0]);
        if (CollectionUtils.isEmpty(conditionsToMatch) && (optionalGroupConfig = this.springDocConfigProperties.getGroupConfigs().stream().filter(groupConfig -> this.groupName.equals(groupConfig.getGroup())).findAny()).isPresent()) {
            conditionsToMatch = this.getConditionsToMatch(conditionType, optionalGroupConfig.get());
        }
        return CollectionUtils.isEmpty(conditionsToMatch) || !ArrayUtils.isEmpty((Object[])existingConditions) && conditionsToMatch.size() == existingConditions.length && conditionsToMatch.containsAll(Arrays.asList(existingConditions));
    }

    protected boolean isPackageToScan(Package aPackage) {
        Optional<SpringDocConfigProperties.GroupConfig> optionalGroupConfig;
        if (aPackage == null) {
            return true;
        }
        String packageName = aPackage.getName();
        List<String> packagesToScan = this.springDocConfigProperties.getPackagesToScan();
        List<String> packagesToExclude = this.springDocConfigProperties.getPackagesToExclude();
        if (CollectionUtils.isEmpty(packagesToScan) && (optionalGroupConfig = this.springDocConfigProperties.getGroupConfigs().stream().filter(groupConfig -> this.groupName.equals(groupConfig.getGroup())).findAny()).isPresent()) {
            packagesToScan = optionalGroupConfig.get().getPackagesToScan();
        }
        if (CollectionUtils.isEmpty(packagesToExclude) && (optionalGroupConfig = this.springDocConfigProperties.getGroupConfigs().stream().filter(groupConfig -> this.groupName.equals(groupConfig.getGroup())).findAny()).isPresent()) {
            packagesToExclude = optionalGroupConfig.get().getPackagesToExclude();
        }
        boolean include = CollectionUtils.isEmpty(packagesToScan) || packagesToScan.stream().anyMatch(pack -> packageName.equals(pack) || packageName.startsWith(pack + "."));
        boolean exclude = !CollectionUtils.isEmpty(packagesToExclude) && packagesToExclude.stream().anyMatch(pack -> packageName.equals(pack) || packageName.startsWith(pack + "."));
        return include && !exclude;
    }

    protected boolean isPathToMatch(String operationPath) {
        Optional<SpringDocConfigProperties.GroupConfig> optionalGroupConfig;
        List<String> pathsToMatch = this.springDocConfigProperties.getPathsToMatch();
        List<String> pathsToExclude = this.springDocConfigProperties.getPathsToExclude();
        if (CollectionUtils.isEmpty(pathsToMatch) && (optionalGroupConfig = this.springDocConfigProperties.getGroupConfigs().stream().filter(groupConfig -> this.groupName.equals(groupConfig.getGroup())).findAny()).isPresent()) {
            pathsToMatch = optionalGroupConfig.get().getPathsToMatch();
        }
        if (CollectionUtils.isEmpty(pathsToExclude) && (optionalGroupConfig = this.springDocConfigProperties.getGroupConfigs().stream().filter(groupConfig -> this.groupName.equals(groupConfig.getGroup())).findAny()).isPresent()) {
            pathsToExclude = optionalGroupConfig.get().getPathsToExclude();
        }
        boolean include = CollectionUtils.isEmpty(pathsToMatch) || pathsToMatch.stream().anyMatch(pattern -> this.antPathMatcher.match(pattern, operationPath));
        boolean exclude = !CollectionUtils.isEmpty(pathsToExclude) && pathsToExclude.stream().anyMatch(pattern -> this.antPathMatcher.match(pattern, operationPath));
        return include && !exclude;
    }

    protected String decode(String requestURI) {
        try {
            return URLDecoder.decode(requestURI, StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException e) {
            return requestURI;
        }
    }

    protected boolean isAdditionalRestController(Class<?> rawClass) {
        return ADDITIONAL_REST_CONTROLLERS.stream().anyMatch(clazz -> clazz.isAssignableFrom(rawClass));
    }

    public static boolean containsResponseBody(HandlerMethod handlerMethod) {
        ResponseBody responseBodyAnnotation = (ResponseBody)AnnotationUtils.findAnnotation((Class)handlerMethod.getBeanType(), ResponseBody.class);
        if (responseBodyAnnotation == null) {
            responseBodyAnnotation = (ResponseBody)AnnotationUtils.findAnnotation((Method)handlerMethod.getMethod(), ResponseBody.class);
        }
        return responseBodyAnnotation != null;
    }

    protected boolean isRestController(Map<String, Object> restControllers, HandlerMethod handlerMethod, String operationPath) {
        boolean hasOperationAnnotation = AnnotatedElementUtils.hasAnnotation((AnnotatedElement)handlerMethod.getMethod(), Operation.class);
        return !((!AbstractOpenApiResource.containsResponseBody(handlerMethod) && !hasOperationAnnotation || !restControllers.containsKey(handlerMethod.getBean().toString())) && !this.isAdditionalRestController(handlerMethod.getBeanType()) || !operationPath.startsWith("/") || !this.springDocConfigProperties.isModelAndViewAllowed() && modelAndViewClass != null && modelAndViewClass.isAssignableFrom(handlerMethod.getMethod().getReturnType()));
    }

    public static boolean isHiddenRestControllers(Class<?> rawClass) {
        return HIDDEN_REST_CONTROLLERS.stream().anyMatch(clazz -> clazz.isAssignableFrom(rawClass));
    }

    protected Set<RequestMethod> getDefaultAllowedHttpMethods() {
        RequestMethod[] allowedRequestMethods = new RequestMethod[]{RequestMethod.GET, RequestMethod.POST, RequestMethod.PUT, RequestMethod.PATCH, RequestMethod.DELETE, RequestMethod.OPTIONS, RequestMethod.HEAD};
        return new HashSet<RequestMethod>(Arrays.asList(allowedRequestMethods));
    }

    protected io.swagger.v3.oas.models.Operation customiseOperation(io.swagger.v3.oas.models.Operation operation, HandlerMethod handlerMethod) {
        if (this.operationCustomizers.isPresent()) {
            List<OperationCustomizer> operationCustomizerList = this.operationCustomizers.get();
            for (OperationCustomizer operationCustomizer : operationCustomizerList) {
                operation = operationCustomizer.customize(operation, handlerMethod);
            }
        }
        return operation;
    }

    protected void mergeRouters(List<RouterFunctionData> routerFunctionDatas, List<RouterOperation> routerOperationList) {
        for (RouterOperation routerOperation : routerOperationList) {
            if (!StringUtils.isNotBlank((CharSequence)routerOperation.getPath())) continue;
            List routerFunctionDataList = routerFunctionDatas.stream().filter(routerFunctionData1 -> routerFunctionData1.getPath().equals(routerOperation.getPath())).collect(Collectors.toList());
            if (routerFunctionDataList.size() == 1) {
                this.fillRouterOperation((RouterFunctionData)routerFunctionDataList.get(0), routerOperation);
                continue;
            }
            if (routerFunctionDataList.size() > 1 && ArrayUtils.isNotEmpty((Object[])routerOperation.getMethods())) {
                routerFunctionDataList = routerFunctionDatas.stream().filter(routerFunctionData1 -> routerFunctionData1.getPath().equals(routerOperation.getPath()) && this.isEqualMethods(routerOperation.getMethods(), routerFunctionData1.getMethods())).collect(Collectors.toList());
                if (routerFunctionDataList.size() == 1) {
                    this.fillRouterOperation((RouterFunctionData)routerFunctionDataList.get(0), routerOperation);
                    continue;
                }
                if (routerFunctionDataList.size() > 1 && ArrayUtils.isNotEmpty((Object[])routerOperation.getProduces())) {
                    routerFunctionDataList = routerFunctionDatas.stream().filter(routerFunctionData1 -> routerFunctionData1.getPath().equals(routerOperation.getPath()) && this.isEqualMethods(routerOperation.getMethods(), routerFunctionData1.getMethods()) && this.isEqualArrays(routerFunctionData1.getProduces(), routerOperation.getProduces())).collect(Collectors.toList());
                    if (routerFunctionDataList.size() == 1) {
                        this.fillRouterOperation((RouterFunctionData)routerFunctionDataList.get(0), routerOperation);
                        continue;
                    }
                    if (routerFunctionDataList.size() <= 1 || !ArrayUtils.isNotEmpty((Object[])routerOperation.getConsumes()) || (routerFunctionDataList = routerFunctionDatas.stream().filter(routerFunctionData1 -> routerFunctionData1.getPath().equals(routerOperation.getPath()) && this.isEqualMethods(routerOperation.getMethods(), routerFunctionData1.getMethods()) && this.isEqualArrays(routerFunctionData1.getProduces(), routerOperation.getProduces()) && this.isEqualArrays(routerFunctionData1.getConsumes(), routerOperation.getConsumes())).collect(Collectors.toList())).size() != 1) continue;
                    this.fillRouterOperation((RouterFunctionData)routerFunctionDataList.get(0), routerOperation);
                    continue;
                }
                if (routerFunctionDataList.size() <= 1 || !ArrayUtils.isNotEmpty((Object[])routerOperation.getConsumes()) || (routerFunctionDataList = routerFunctionDatas.stream().filter(routerFunctionData1 -> routerFunctionData1.getPath().equals(routerOperation.getPath()) && this.isEqualMethods(routerOperation.getMethods(), routerFunctionData1.getMethods()) && this.isEqualArrays(routerFunctionData1.getConsumes(), routerOperation.getConsumes())).collect(Collectors.toList())).size() != 1) continue;
                this.fillRouterOperation((RouterFunctionData)routerFunctionDataList.get(0), routerOperation);
                continue;
            }
            if (routerFunctionDataList.size() > 1 && ArrayUtils.isNotEmpty((Object[])routerOperation.getProduces())) {
                routerFunctionDataList = routerFunctionDatas.stream().filter(routerFunctionData1 -> routerFunctionData1.getPath().equals(routerOperation.getPath()) && this.isEqualArrays(routerFunctionData1.getProduces(), routerOperation.getProduces())).collect(Collectors.toList());
                if (routerFunctionDataList.size() == 1) {
                    this.fillRouterOperation((RouterFunctionData)routerFunctionDataList.get(0), routerOperation);
                    continue;
                }
                if (routerFunctionDataList.size() <= 1 || !ArrayUtils.isNotEmpty((Object[])routerOperation.getConsumes()) || (routerFunctionDataList = routerFunctionDatas.stream().filter(routerFunctionData1 -> routerFunctionData1.getPath().equals(routerOperation.getPath()) && this.isEqualMethods(routerOperation.getMethods(), routerFunctionData1.getMethods()) && this.isEqualArrays(routerFunctionData1.getConsumes(), routerOperation.getConsumes()) && this.isEqualArrays(routerFunctionData1.getProduces(), routerOperation.getProduces())).collect(Collectors.toList())).size() != 1) continue;
                this.fillRouterOperation((RouterFunctionData)routerFunctionDataList.get(0), routerOperation);
                continue;
            }
            if (routerFunctionDataList.size() <= 1 || !ArrayUtils.isNotEmpty((Object[])routerOperation.getConsumes()) || (routerFunctionDataList = routerFunctionDatas.stream().filter(routerFunctionData1 -> routerFunctionData1.getPath().equals(routerOperation.getPath()) && this.isEqualArrays(routerFunctionData1.getConsumes(), routerOperation.getConsumes())).collect(Collectors.toList())).size() != 1) continue;
            this.fillRouterOperation((RouterFunctionData)routerFunctionDataList.get(0), routerOperation);
        }
    }

    private void calculateJsonView(Operation apiOperation, MethodAttributes methodAttributes, Method method) {
        JsonView jsonViewAnnotationForRequestBody;
        JsonView jsonViewAnnotation;
        if (apiOperation != null && apiOperation.ignoreJsonView()) {
            jsonViewAnnotation = null;
            jsonViewAnnotationForRequestBody = null;
        } else {
            jsonViewAnnotation = (JsonView)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, JsonView.class);
            jsonViewAnnotationForRequestBody = (JsonView)Arrays.stream(ReflectionUtils.getParameterAnnotations((Method)method)).filter(arr -> Arrays.stream(arr).anyMatch(annotation -> annotation.annotationType().equals(io.swagger.v3.oas.annotations.parameters.RequestBody.class) || annotation.annotationType().equals(RequestBody.class))).flatMap(Arrays::stream).filter(annotation -> annotation.annotationType().equals(JsonView.class)).reduce((a, b) -> null).orElse((Annotation)jsonViewAnnotation);
        }
        methodAttributes.setJsonViewAnnotation(jsonViewAnnotation);
        methodAttributes.setJsonViewAnnotationForRequestBody(jsonViewAnnotationForRequestBody);
    }

    private boolean isEqualArrays(String[] array1, String[] array2) {
        Arrays.sort(array1);
        Arrays.sort(array2);
        return Arrays.equals(array1, array2);
    }

    private boolean isEqualMethods(RequestMethod[] requestMethods1, RequestMethod[] requestMethods2) {
        Arrays.sort(requestMethods1);
        Arrays.sort(requestMethods2);
        return Arrays.equals(requestMethods1, requestMethods2);
    }

    private void fillParametersList(io.swagger.v3.oas.models.Operation operation, Map<String, String> queryParams, MethodAttributes methodAttributes) {
        ArrayList<Parameter> parametersList = operation.getParameters();
        if (parametersList == null) {
            parametersList = new ArrayList<Parameter>();
        }
        Collection<Parameter> headersMap = AbstractRequestService.getHeaders(methodAttributes, new LinkedHashMap<String, Parameter>());
        parametersList.addAll(headersMap);
        if (!CollectionUtils.isEmpty(queryParams)) {
            for (Map.Entry<String, String> entry : queryParams.entrySet()) {
                Parameter parameter = new Parameter();
                parameter.setName(entry.getKey());
                parameter.setSchema((Schema)new StringSchema()._default(entry.getValue()));
                parameter.setRequired(Boolean.valueOf(true));
                parameter.setIn(ParameterIn.QUERY.toString());
                GenericParameterService.mergeParameter(parametersList, parameter);
            }
            operation.setParameters(parametersList);
        }
    }

    private void fillRouterOperation(RouterFunctionData routerFunctionData, RouterOperation routerOperation) {
        if (ArrayUtils.isEmpty((Object[])routerOperation.getConsumes())) {
            routerOperation.setConsumes(routerFunctionData.getConsumes());
        }
        if (ArrayUtils.isEmpty((Object[])routerOperation.getProduces())) {
            routerOperation.setProduces(routerFunctionData.getProduces());
        }
        if (ArrayUtils.isEmpty((Object[])routerOperation.getHeaders())) {
            routerOperation.setHeaders(routerFunctionData.getHeaders());
        }
        if (ArrayUtils.isEmpty((Object[])routerOperation.getMethods())) {
            routerOperation.setMethods(routerFunctionData.getMethods());
        }
        if (CollectionUtils.isEmpty(routerOperation.getQueryParams())) {
            routerOperation.setQueryParams(routerFunctionData.getQueryParams());
        }
    }

    private PathItem buildPathItem(RequestMethod requestMethod, io.swagger.v3.oas.models.Operation operation, String operationPath, Paths paths) {
        PathItem pathItemObject = paths.containsKey((Object)operationPath) ? (PathItem)paths.get((Object)operationPath) : new PathItem();
        switch (requestMethod) {
            case POST: {
                pathItemObject.post(operation);
                break;
            }
            case GET: {
                pathItemObject.get(operation);
                break;
            }
            case DELETE: {
                pathItemObject.delete(operation);
                break;
            }
            case PUT: {
                pathItemObject.put(operation);
                break;
            }
            case PATCH: {
                pathItemObject.patch(operation);
                break;
            }
            case TRACE: {
                pathItemObject.trace(operation);
                break;
            }
            case HEAD: {
                pathItemObject.head(operation);
                break;
            }
            case OPTIONS: {
                pathItemObject.options(operation);
                break;
            }
        }
        return pathItemObject;
    }

    private io.swagger.v3.oas.models.Operation getExistingOperation(Map<PathItem.HttpMethod, io.swagger.v3.oas.models.Operation> operationMap, RequestMethod requestMethod) {
        io.swagger.v3.oas.models.Operation existingOperation = null;
        if (!CollectionUtils.isEmpty(operationMap)) {
            switch (requestMethod) {
                case GET: {
                    existingOperation = operationMap.get(PathItem.HttpMethod.GET);
                    break;
                }
                case POST: {
                    existingOperation = operationMap.get(PathItem.HttpMethod.POST);
                    break;
                }
                case PUT: {
                    existingOperation = operationMap.get(PathItem.HttpMethod.PUT);
                    break;
                }
                case DELETE: {
                    existingOperation = operationMap.get(PathItem.HttpMethod.DELETE);
                    break;
                }
                case PATCH: {
                    existingOperation = operationMap.get(PathItem.HttpMethod.PATCH);
                    break;
                }
                case HEAD: {
                    existingOperation = operationMap.get(PathItem.HttpMethod.HEAD);
                    break;
                }
                case OPTIONS: {
                    existingOperation = operationMap.get(PathItem.HttpMethod.OPTIONS);
                    break;
                }
            }
        }
        return existingOperation;
    }

    private io.swagger.v3.oas.models.Operation getOperation(RouterOperation routerOperation, io.swagger.v3.oas.models.Operation existingOperation) {
        io.swagger.v3.oas.models.Operation operationModel = routerOperation.getOperationModel();
        io.swagger.v3.oas.models.Operation operation = existingOperation != null && operationModel == null ? existingOperation : (existingOperation == null && operationModel != null ? operationModel : (existingOperation != null ? this.operationParser.mergeOperation(existingOperation, operationModel) : new io.swagger.v3.oas.models.Operation()));
        return operation;
    }

    protected void initOpenAPIBuilder(Locale locale) {
        Locale locale2 = locale = locale == null ? Locale.getDefault() : locale;
        if (this.openAPIService.getCachedOpenAPI(locale) != null && this.springDocConfigProperties.isCacheDisabled()) {
            this.openAPIService = (OpenAPIService)this.openAPIBuilderObjectFactory.getObject();
        }
    }

    protected String writeYamlValue(OpenAPI openAPI) throws JsonProcessingException {
        ObjectMapper objectMapper = this.springDocProviders.yamlMapper();
        if (this.springDocConfigProperties.isWriterWithOrderByKeys()) {
            ObjectMapperProvider.sortOutput(objectMapper, this.springDocConfigProperties);
        }
        YAMLFactory factory = (YAMLFactory)objectMapper.getFactory();
        factory.configure(YAMLGenerator.Feature.USE_NATIVE_TYPE_ID, false);
        String result = !this.springDocConfigProperties.isWriterWithDefaultPrettyPrinter() ? objectMapper.writerFor(OpenAPI.class).writeValueAsString((Object)openAPI) : objectMapper.writerWithDefaultPrettyPrinter().forType(OpenAPI.class).writeValueAsString((Object)openAPI);
        return result;
    }

    protected URI getActuatorURI(String scheme, String host) {
        Optional<ActuatorProvider> actuatorProviderOptional = this.springDocProviders.getActuatorProvider();
        URI uri = null;
        if (actuatorProviderOptional.isPresent()) {
            Object path;
            int port;
            ActuatorProvider actuatorProvider = actuatorProviderOptional.get();
            if ("x-actuator".equals(this.groupName)) {
                port = actuatorProvider.getActuatorPort();
                path = actuatorProvider.getActuatorPath();
            } else {
                port = actuatorProvider.getApplicationPort();
                path = actuatorProvider.getContextPath();
                String mvcServletPath = ((Environment)this.openAPIService.getContext().getBean(Environment.class)).getProperty("spring.mvc.servlet.path");
                if (StringUtils.isNotEmpty((CharSequence)mvcServletPath)) {
                    path = (String)path + mvcServletPath;
                }
            }
            try {
                uri = new URI((String)StringUtils.defaultIfEmpty((CharSequence)scheme, (CharSequence)"http"), null, (String)StringUtils.defaultIfEmpty((CharSequence)host, (CharSequence)"localhost"), port, (String)path, null, null);
            }
            catch (URISyntaxException e) {
                LOGGER.error("Unable to parse the URL: scheme {}, host {}, port {}, path {}", new Object[]{scheme, host, port, path});
            }
        }
        return uri;
    }

    protected boolean isActuatorRestController(String operationPath, HandlerMethod handlerMethod) {
        Optional<ActuatorProvider> actuatorProviderOptional = this.springDocProviders.getActuatorProvider();
        boolean isActuatorRestController = false;
        if (actuatorProviderOptional.isPresent()) {
            isActuatorRestController = actuatorProviderOptional.get().isRestController(operationPath, handlerMethod);
        }
        return this.springDocConfigProperties.isShowActuator() && isActuatorRestController;
    }

    protected String writeJsonValue(OpenAPI openAPI) throws JsonProcessingException {
        ObjectMapper objectMapper = this.springDocProviders.jsonMapper();
        if (this.springDocConfigProperties.isWriterWithOrderByKeys()) {
            ObjectMapperProvider.sortOutput(objectMapper, this.springDocConfigProperties);
        }
        String result = !this.springDocConfigProperties.isWriterWithDefaultPrettyPrinter() ? objectMapper.writerFor(OpenAPI.class).writeValueAsString((Object)openAPI) : objectMapper.writerWithDefaultPrettyPrinter().forType(OpenAPI.class).writeValueAsString((Object)openAPI);
        return result;
    }

    private List<String> getConditionsToMatch(ConditionType conditionType, SpringDocConfigProperties.GroupConfig ... groupConfigs) {
        List<String> conditionsToMatch = null;
        SpringDocConfigProperties.GroupConfig groupConfig = null;
        if (ArrayUtils.isNotEmpty((Object[])groupConfigs)) {
            groupConfig = groupConfigs[0];
        }
        switch (conditionType) {
            case HEADERS: {
                conditionsToMatch = groupConfig != null ? groupConfig.getHeadersToMatch() : this.springDocConfigProperties.getHeadersToMatch();
                break;
            }
            case PRODUCES: {
                conditionsToMatch = groupConfig != null ? groupConfig.getProducesToMatch() : this.springDocConfigProperties.getProducesToMatch();
                break;
            }
            case CONSUMES: {
                conditionsToMatch = groupConfig != null ? groupConfig.getConsumesToMatch() : this.springDocConfigProperties.getConsumesToMatch();
                break;
            }
        }
        return conditionsToMatch;
    }

    private boolean isFilterCondition(String operationPath, String[] produces, String[] consumes, String[] headers) {
        return this.isPathToMatch(operationPath) && this.isConditionToMatch(produces, ConditionType.PRODUCES) && this.isConditionToMatch(consumes, ConditionType.CONSUMES) && this.isConditionToMatch(headers, ConditionType.HEADERS);
    }

    public static void setModelAndViewClass(Class<?> modelAndViewClass) {
        AbstractOpenApiResource.modelAndViewClass = modelAndViewClass;
    }

    static enum ConditionType {
        PRODUCES,
        CONSUMES,
        HEADERS;

    }
}

