/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.hateoas;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Optional;
import javax.annotation.PostConstruct;
import org.springdoc.core.providers.ObjectMapperProvider;
import org.springframework.boot.autoconfigure.hateoas.HateoasProperties;
import org.springframework.hateoas.mediatype.hal.Jackson2HalModule;

public class HateoasHalProvider {
    protected final ObjectMapperProvider objectMapperProvider;
    private final Optional<HateoasProperties> hateoasPropertiesOptional;

    public HateoasHalProvider(Optional<HateoasProperties> hateoasPropertiesOptional, ObjectMapperProvider objectMapperProvider) {
        this.hateoasPropertiesOptional = hateoasPropertiesOptional;
        this.objectMapperProvider = objectMapperProvider;
    }

    @PostConstruct
    protected void init() {
        if (!this.isHalEnabled()) {
            return;
        }
        if (!Jackson2HalModule.isAlreadyRegisteredIn((ObjectMapper)this.objectMapperProvider.jsonMapper())) {
            this.objectMapperProvider.jsonMapper().registerModule((Module)new Jackson2HalModule());
        }
    }

    public boolean isHalEnabled() {
        return this.hateoasPropertiesOptional.map(HateoasProperties::getUseHalAsDefaultJsonMediaType).orElse(true);
    }
}

