/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core;

import com.fasterxml.jackson.annotation.JsonView;
import io.swagger.v3.core.util.AnnotationsUtils;
import io.swagger.v3.core.util.ReflectionUtils;
import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.callbacks.Callback;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.links.Link;
import io.swagger.v3.oas.annotations.servers.Server;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.headers.Header;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springdoc.core.AbstractParameterBuilder;
import org.springdoc.core.MethodAttributes;
import org.springdoc.core.OpenAPIBuilder;
import org.springdoc.core.RequestBodyBuilder;
import org.springdoc.core.SecurityParser;
import org.springdoc.core.SpringDocAnnotationsUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class OperationBuilder {
    private AbstractParameterBuilder parameterBuilder;
    private RequestBodyBuilder requestBodyBuilder;
    private SecurityParser securityParser;
    private OpenAPIBuilder openAPIBuilder;

    public OperationBuilder(AbstractParameterBuilder parameterBuilder, RequestBodyBuilder requestBodyBuilder, SecurityParser securityParser, OpenAPIBuilder openAPIBuilder) {
        this.parameterBuilder = parameterBuilder;
        this.requestBodyBuilder = requestBodyBuilder;
        this.securityParser = securityParser;
        this.openAPIBuilder = openAPIBuilder;
    }

    public OpenAPI parse(Components components, io.swagger.v3.oas.annotations.Operation apiOperation, Operation operation, OpenAPI openAPI, MethodAttributes methodAttributes) {
        if (StringUtils.isNotBlank((CharSequence)apiOperation.summary())) {
            operation.setSummary(apiOperation.summary());
        }
        if (StringUtils.isNotBlank((CharSequence)apiOperation.description())) {
            operation.setDescription(apiOperation.description());
        }
        if (StringUtils.isNotBlank((CharSequence)apiOperation.operationId())) {
            operation.setOperationId(this.getOperationId(apiOperation.operationId(), openAPI));
        }
        if (apiOperation.deprecated()) {
            operation.setDeprecated(Boolean.valueOf(apiOperation.deprecated()));
        }
        this.buildTags(apiOperation, operation);
        if (operation.getExternalDocs() == null) {
            AnnotationsUtils.getExternalDocumentation((ExternalDocumentation)apiOperation.externalDocs()).ifPresent(arg_0 -> ((Operation)operation).setExternalDocs(arg_0));
        }
        AnnotationsUtils.getServers((Server[])apiOperation.servers()).ifPresent(servers -> servers.forEach(arg_0 -> ((Operation)operation).addServersItem(arg_0)));
        for (Parameter parameterDoc : apiOperation.parameters()) {
            io.swagger.v3.oas.models.parameters.Parameter parameter = this.parameterBuilder.buildParameterFromDoc(parameterDoc, components, methodAttributes.getJsonViewAnnotation());
            operation.addParametersItem(parameter);
        }
        this.requestBodyBuilder.buildRequestBodyFromDoc(apiOperation.requestBody(), methodAttributes.getClassConsumes(), methodAttributes.getMethodConsumes(), components, null).ifPresent(arg_0 -> ((Operation)operation).setRequestBody(arg_0));
        this.buildResponse(components, apiOperation, operation, methodAttributes);
        this.securityParser.buildSecurityRequirement(apiOperation.security(), operation);
        this.buildExtensions(apiOperation, operation);
        return openAPI;
    }

    public boolean isHidden(Method method) {
        io.swagger.v3.oas.annotations.Operation apiOperation = (io.swagger.v3.oas.annotations.Operation)ReflectionUtils.getAnnotation((Method)method, io.swagger.v3.oas.annotations.Operation.class);
        return apiOperation != null && apiOperation.hidden() || ReflectionUtils.getAnnotation((Method)method, Hidden.class) != null;
    }

    public Optional<Map<String, io.swagger.v3.oas.models.callbacks.Callback>> buildCallbacks(List<Callback> apiCallbacks, Components components, OpenAPI openAPI, MethodAttributes methodAttributes) {
        LinkedHashMap callbacks = new LinkedHashMap();
        boolean doBreak = false;
        for (Callback methodCallback : apiCallbacks) {
            HashMap<String, io.swagger.v3.oas.models.callbacks.Callback> callbackMap = new HashMap<String, io.swagger.v3.oas.models.callbacks.Callback>();
            if (methodCallback == null) {
                callbacks.putAll(callbackMap);
                doBreak = true;
            }
            io.swagger.v3.oas.models.callbacks.Callback callbackObject = new io.swagger.v3.oas.models.callbacks.Callback();
            if (!doBreak && StringUtils.isNotBlank((CharSequence)methodCallback.ref())) {
                callbackObject.set$ref(methodCallback.ref());
                callbackMap.put(methodCallback.name(), callbackObject);
                callbacks.putAll(callbackMap);
                doBreak = true;
            }
            if (doBreak) break;
            PathItem pathItemObject = new PathItem();
            for (io.swagger.v3.oas.annotations.Operation callbackOperation : methodCallback.operation()) {
                Operation callbackNewOperation = new Operation();
                this.parse(components, callbackOperation, callbackNewOperation, openAPI, methodAttributes);
                this.setPathItemOperation(pathItemObject, callbackOperation.method(), callbackNewOperation);
            }
            callbackObject.addPathItem(methodCallback.callbackUrlExpression(), pathItemObject);
            callbackMap.put(methodCallback.name(), callbackObject);
            callbacks.putAll(callbackMap);
        }
        if (CollectionUtils.isEmpty(callbacks)) {
            return Optional.empty();
        }
        return Optional.of(callbacks);
    }

    private void setPathItemOperation(PathItem pathItemObject, String method, Operation operation) {
        switch (method) {
            case "post": {
                pathItemObject.post(operation);
                break;
            }
            case "get": {
                pathItemObject.get(operation);
                break;
            }
            case "delete": {
                pathItemObject.delete(operation);
                break;
            }
            case "put": {
                pathItemObject.put(operation);
                break;
            }
            case "patch": {
                pathItemObject.patch(operation);
                break;
            }
            case "trace": {
                pathItemObject.trace(operation);
                break;
            }
            case "head": {
                pathItemObject.head(operation);
                break;
            }
            case "options": {
                pathItemObject.options(operation);
                break;
            }
        }
    }

    private void buildExtensions(io.swagger.v3.oas.annotations.Operation apiOperation, Operation operation) {
        if (apiOperation.extensions().length > 0) {
            Map extensions = AnnotationsUtils.getExtensions((Extension[])apiOperation.extensions());
            for (Map.Entry entry : extensions.entrySet()) {
                operation.addExtension((String)entry.getKey(), entry.getValue());
            }
        }
    }

    private void buildTags(io.swagger.v3.oas.annotations.Operation apiOperation, Operation operation) {
        Optional<List<String>> mlist = this.getStringListFromStringArray(apiOperation.tags());
        if (mlist.isPresent()) {
            List tags = mlist.get().stream().filter(t -> operation.getTags() == null || operation.getTags() != null && !operation.getTags().contains(t)).collect(Collectors.toList());
            for (String tagsItem : tags) {
                operation.addTagsItem(tagsItem);
            }
        }
    }

    private String getOperationId(String operationId, OpenAPI openAPI) {
        boolean operationIdUsed = this.existOperationId(operationId, openAPI);
        String operationIdToFind = null;
        int counter = 0;
        while (operationIdUsed) {
            operationIdToFind = String.format("%s_%d", operationId, ++counter);
            operationIdUsed = this.existOperationId(operationIdToFind, openAPI);
        }
        if (operationIdToFind != null) {
            operationId = operationIdToFind;
        }
        return operationId;
    }

    private boolean existOperationId(String operationId, OpenAPI openAPI) {
        if (openAPI == null) {
            return false;
        }
        if (openAPI.getPaths() == null || openAPI.getPaths().isEmpty()) {
            return false;
        }
        for (PathItem path : openAPI.getPaths().values()) {
            Set<String> pathOperationIds = this.extractOperationIdFromPathItem(path);
            if (!pathOperationIds.contains(operationId)) continue;
            return true;
        }
        return false;
    }

    private Set<String> extractOperationIdFromPathItem(PathItem path) {
        HashSet<String> ids = new HashSet<String>();
        if (path.getGet() != null && StringUtils.isNotBlank((CharSequence)path.getGet().getOperationId())) {
            ids.add(path.getGet().getOperationId());
        }
        if (path.getPost() != null && StringUtils.isNotBlank((CharSequence)path.getPost().getOperationId())) {
            ids.add(path.getPost().getOperationId());
        }
        if (path.getPut() != null && StringUtils.isNotBlank((CharSequence)path.getPut().getOperationId())) {
            ids.add(path.getPut().getOperationId());
        }
        if (path.getDelete() != null && StringUtils.isNotBlank((CharSequence)path.getDelete().getOperationId())) {
            ids.add(path.getDelete().getOperationId());
        }
        if (path.getOptions() != null && StringUtils.isNotBlank((CharSequence)path.getOptions().getOperationId())) {
            ids.add(path.getOptions().getOperationId());
        }
        if (path.getHead() != null && StringUtils.isNotBlank((CharSequence)path.getHead().getOperationId())) {
            ids.add(path.getHead().getOperationId());
        }
        if (path.getPatch() != null && StringUtils.isNotBlank((CharSequence)path.getPatch().getOperationId())) {
            ids.add(path.getPatch().getOperationId());
        }
        return ids;
    }

    private Optional<ApiResponses> getApiResponses(io.swagger.v3.oas.annotations.responses.ApiResponse[] responses, String[] classProduces, String[] methodProduces, Components components, JsonView jsonViewAnnotation) {
        ApiResponses apiResponsesObject = new ApiResponses();
        for (io.swagger.v3.oas.annotations.responses.ApiResponse response : responses) {
            ApiResponse apiResponseObject = new ApiResponse();
            if (StringUtils.isNotBlank((CharSequence)response.ref())) {
                this.setRef(apiResponsesObject, response, apiResponseObject);
                continue;
            }
            this.setDescription(response, apiResponseObject);
            this.setExtensions(response, apiResponseObject);
            SpringDocAnnotationsUtils.getContent(response.content(), classProduces == null ? new String[]{} : classProduces, methodProduces == null ? new String[]{} : methodProduces, null, components, jsonViewAnnotation).ifPresent(arg_0 -> ((ApiResponse)apiResponseObject).content(arg_0));
            AnnotationsUtils.getHeaders((io.swagger.v3.oas.annotations.headers.Header[])response.headers(), (JsonView)jsonViewAnnotation).ifPresent(arg_0 -> ((ApiResponse)apiResponseObject).headers(arg_0));
            this.calculateHeader(apiResponseObject, jsonViewAnnotation);
            if (!this.isResponseObject(apiResponseObject)) continue;
            this.setLinks(response, apiResponseObject);
            if (StringUtils.isNotBlank((CharSequence)response.responseCode())) {
                apiResponsesObject.addApiResponse(response.responseCode(), apiResponseObject);
                continue;
            }
            apiResponsesObject._default(apiResponseObject);
        }
        return Optional.of(apiResponsesObject);
    }

    private boolean isResponseObject(ApiResponse apiResponseObject) {
        return StringUtils.isNotBlank((CharSequence)apiResponseObject.getDescription()) || apiResponseObject.getContent() != null || apiResponseObject.getHeaders() != null;
    }

    private void setLinks(io.swagger.v3.oas.annotations.responses.ApiResponse response, ApiResponse apiResponseObject) {
        Map links = AnnotationsUtils.getLinks((Link[])response.links());
        if (links.size() > 0) {
            apiResponseObject.setLinks(links);
        }
    }

    private void setDescription(io.swagger.v3.oas.annotations.responses.ApiResponse response, ApiResponse apiResponseObject) {
        if (StringUtils.isNotBlank((CharSequence)response.description())) {
            apiResponseObject.setDescription(response.description());
        } else {
            apiResponseObject.setDescription("default response");
        }
    }

    private void calculateHeader(ApiResponse apiResponseObject, JsonView jsonViewAnnotation) {
        Map headers = apiResponseObject.getHeaders();
        if (!CollectionUtils.isEmpty((Map)headers)) {
            for (Map.Entry entry : headers.entrySet()) {
                Header header = (Header)entry.getValue();
                if (header.getSchema() != null) continue;
                Schema schema = AnnotationsUtils.resolveSchemaFromType(String.class, null, (JsonView)jsonViewAnnotation);
                header.setSchema(schema);
                entry.setValue(header);
            }
        }
    }

    private void setRef(ApiResponses apiResponsesObject, io.swagger.v3.oas.annotations.responses.ApiResponse response, ApiResponse apiResponseObject) {
        apiResponseObject.set$ref(response.ref());
        if (StringUtils.isNotBlank((CharSequence)response.responseCode())) {
            apiResponsesObject.addApiResponse(response.responseCode(), apiResponseObject);
        } else {
            apiResponsesObject._default(apiResponseObject);
        }
    }

    private void setExtensions(io.swagger.v3.oas.annotations.responses.ApiResponse response, ApiResponse apiResponseObject) {
        if (response.extensions().length > 0) {
            Map extensions = AnnotationsUtils.getExtensions((Extension[])response.extensions());
            for (Map.Entry entry : extensions.entrySet()) {
                apiResponseObject.addExtension((String)entry.getKey(), entry.getValue());
            }
        }
    }

    private void buildResponse(Components components, io.swagger.v3.oas.annotations.Operation apiOperation, Operation operation, MethodAttributes methodAttributes) {
        this.getApiResponses(apiOperation.responses(), methodAttributes.getClassProduces(), methodAttributes.getMethodProduces(), components, null).ifPresent(responses -> {
            if (operation.getResponses() == null) {
                operation.setResponses(responses);
            } else {
                responses.forEach((arg_0, arg_1) -> ((ApiResponses)operation.getResponses()).addApiResponse(arg_0, arg_1));
            }
        });
    }

    private Optional<List<String>> getStringListFromStringArray(String[] array) {
        if (array == null) {
            return Optional.empty();
        }
        ArrayList<String> list = new ArrayList<String>();
        boolean isEmpty = true;
        for (String value : array) {
            if (StringUtils.isNotBlank((CharSequence)value)) {
                isEmpty = false;
            }
            list.add(value);
        }
        if (isEmpty) {
            return Optional.empty();
        }
        return Optional.of(list);
    }

    public String getOperationId(String operationId, String oldOperationId) {
        if (StringUtils.isNotBlank((CharSequence)oldOperationId)) {
            return this.getOperationId(oldOperationId, this.openAPIBuilder.getOpenAPI());
        }
        return this.getOperationId(operationId, this.openAPIBuilder.getOpenAPI());
    }
}

