/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core;

import io.swagger.v3.core.util.AnnotationsUtils;
import io.swagger.v3.core.util.ReflectionUtils;
import io.swagger.v3.oas.annotations.headers.Header;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.responses.ApiResponse;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.springdoc.core.MethodAttributes;
import org.springdoc.core.OperationBuilder;
import org.springdoc.core.SpringDocAnnotationsUtils;
import org.springframework.aop.support.AopUtils;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.method.HandlerMethod;

public abstract class AbstractResponseBuilder {
    private Map<String, ApiResponse> genericMapResponse = new LinkedHashMap<String, ApiResponse>();
    private OperationBuilder operationBuilder;

    protected AbstractResponseBuilder(OperationBuilder operationBuilder) {
        this.operationBuilder = operationBuilder;
    }

    public io.swagger.v3.oas.models.responses.ApiResponses build(Components components, HandlerMethod handlerMethod, Operation operation, MethodAttributes methodAttributes) {
        io.swagger.v3.oas.models.responses.ApiResponses apiResponses = operation.getResponses();
        if (apiResponses == null) {
            apiResponses = new io.swagger.v3.oas.models.responses.ApiResponses();
        }
        for (Map.Entry<String, ApiResponse> entry : this.genericMapResponse.entrySet()) {
            apiResponses.addApiResponse(entry.getKey(), entry.getValue());
        }
        this.computeResponse(components, handlerMethod.getMethod(), apiResponses, methodAttributes, false);
        return apiResponses;
    }

    public void buildGenericResponse(Components components, Map<String, Object> findControllerAdvice) {
        List<Method> methods = this.getMethods(findControllerAdvice);
        for (Method method : methods) {
            if (this.operationBuilder.isHidden(method)) continue;
            RequestMapping reqMappringMethod = (RequestMapping)ReflectionUtils.getAnnotation((Method)method, RequestMapping.class);
            String[] methodProduces = new String[]{"*/*"};
            if (reqMappringMethod != null) {
                methodProduces = reqMappringMethod.produces();
            }
            Map<String, ApiResponse> apiResponses = this.computeResponse(components, method, new io.swagger.v3.oas.models.responses.ApiResponses(), new MethodAttributes(methodProduces), true);
            for (Map.Entry<String, ApiResponse> entry : apiResponses.entrySet()) {
                this.genericMapResponse.put(entry.getKey(), entry.getValue());
            }
        }
    }

    protected abstract Schema calculateSchemaFromParameterizedType(Components var1, ParameterizedType var2);

    protected Schema calculateSchemaParameterizedType(Components components, ParameterizedType parameterizedType) {
        Schema schemaN = null;
        if (parameterizedType.getActualTypeArguments()[0] instanceof Class && !Void.class.equals((Object)parameterizedType.getActualTypeArguments()[0])) {
            schemaN = this.calculateSchema(components, parameterizedType);
        } else if (parameterizedType.getActualTypeArguments()[0] instanceof ParameterizedType && !Void.class.equals((Object)parameterizedType.getActualTypeArguments()[0])) {
            parameterizedType = (ParameterizedType)parameterizedType.getActualTypeArguments()[0];
            schemaN = SpringDocAnnotationsUtils.extractSchema(components, parameterizedType);
        } else if (Void.class.equals((Object)parameterizedType.getActualTypeArguments()[0])) {
            schemaN = AnnotationsUtils.resolveSchemaFromType(String.class, null, null);
        }
        return schemaN;
    }

    private List<Method> getMethods(Map<String, Object> findControllerAdvice) {
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Map.Entry<String, Object> entry : findControllerAdvice.entrySet()) {
            Object controllerAdvice = entry.getValue();
            Class objClz = controllerAdvice.getClass();
            if (AopUtils.isAopProxy((Object)controllerAdvice)) {
                objClz = AopUtils.getTargetClass((Object)controllerAdvice);
            }
            for (Method m : objClz.getDeclaredMethods()) {
                if (!m.isAnnotationPresent(ExceptionHandler.class)) continue;
                methods.add(m);
            }
        }
        return methods;
    }

    private Map<String, ApiResponse> computeResponse(Components components, Method method, io.swagger.v3.oas.models.responses.ApiResponses apiResponsesOp, MethodAttributes methodAttributes, boolean isGeneric) {
        Object[] responsesArray = this.getApiResponses(method);
        if (ArrayUtils.isNotEmpty((Object[])responsesArray)) {
            for (Object apiResponse2 : responsesArray) {
                ApiResponse apiResponse1 = new ApiResponse();
                apiResponse1.setDescription(apiResponse2.description());
                io.swagger.v3.oas.annotations.media.Content[] contentdoc = apiResponse2.content();
                SpringDocAnnotationsUtils.getContent(contentdoc, new String[]{}, methodAttributes.getAllProduces() == null ? new String[]{} : methodAttributes.getAllProduces(), null, components, null).ifPresent(arg_0 -> ((ApiResponse)apiResponse1).content(arg_0));
                AnnotationsUtils.getHeaders((Header[])apiResponse2.headers(), null).ifPresent(arg_0 -> ((ApiResponse)apiResponse1).headers(arg_0));
                apiResponsesOp.addApiResponse(apiResponse2.responseCode(), apiResponse1);
            }
        }
        if (!CollectionUtils.isEmpty((Map)apiResponsesOp) && apiResponsesOp.size() != this.genericMapResponse.size()) {
            for (Map.Entry entry : apiResponsesOp.entrySet()) {
                String httpCode = (String)entry.getKey();
                ApiResponse apiResponse = (ApiResponse)entry.getValue();
                this.buildApiResponses(components, method, apiResponsesOp, methodAttributes, httpCode, apiResponse, isGeneric);
            }
        } else {
            ApiResponse apiResponse;
            String httpCode = this.evaluateResponseStatus(method, method.getClass(), isGeneric);
            ApiResponse apiResponse2 = apiResponse = this.genericMapResponse.containsKey(httpCode) ? this.genericMapResponse.get(httpCode) : new ApiResponse();
            if (httpCode != null) {
                this.buildApiResponses(components, method, apiResponsesOp, methodAttributes, httpCode, apiResponse, isGeneric);
            }
        }
        return apiResponsesOp;
    }

    private io.swagger.v3.oas.annotations.responses.ApiResponse[] getApiResponses(Method method) {
        io.swagger.v3.oas.annotations.responses.ApiResponse[] responsesArray = null;
        ApiResponses apiResponsesDoc = (ApiResponses)ReflectionUtils.getAnnotation((Method)method, ApiResponses.class);
        if (apiResponsesDoc != null) {
            responsesArray = apiResponsesDoc.value();
        } else {
            List apiResponseDoc = ReflectionUtils.getRepeatableAnnotations((Method)method, io.swagger.v3.oas.annotations.responses.ApiResponse.class);
            if (!CollectionUtils.isEmpty((Collection)apiResponseDoc)) {
                responsesArray = (io.swagger.v3.oas.annotations.responses.ApiResponse[])apiResponseDoc.stream().toArray(io.swagger.v3.oas.annotations.responses.ApiResponse[]::new);
            }
        }
        return responsesArray;
    }

    private Content buildContent(Components components, Method method, String[] methodProduces) {
        Schema<?> schemaN;
        Content content = new Content();
        Type returnType = method.getGenericReturnType();
        if (this.isVoid(returnType)) {
            content = null;
        } else if (ArrayUtils.isNotEmpty((Object[])methodProduces) && (schemaN = this.calculateSchema(components, returnType)) != null) {
            MediaType mediaType = new MediaType();
            mediaType.setSchema(schemaN);
            this.setContent(methodProduces, content, mediaType);
        }
        return content;
    }

    private Schema<?> calculateSchema(Components components, Type returnType) {
        Schema schemaN = null;
        if (this.isVoid(returnType)) {
            return schemaN;
        }
        if (returnType instanceof ParameterizedType) {
            schemaN = this.calculateSchemaFromParameterizedType(components, (ParameterizedType)returnType);
        } else if (ResponseEntity.class.getName().equals(returnType.getTypeName())) {
            schemaN = AnnotationsUtils.resolveSchemaFromType(String.class, null, null);
        }
        if (schemaN == null) {
            schemaN = SpringDocAnnotationsUtils.extractSchema(components, returnType);
        }
        if (schemaN == null && returnType instanceof Class) {
            schemaN = AnnotationsUtils.resolveSchemaFromType((Class)((Class)returnType), null, null);
        }
        return schemaN;
    }

    private void setContent(String[] methodProduces, Content content, MediaType mediaType) {
        for (String mediaTypeStr : methodProduces) {
            content.addMediaType(mediaTypeStr, mediaType);
        }
    }

    private Schema calculateSchema(Components components, ParameterizedType parameterizedType) {
        Schema schemaN = AnnotationsUtils.resolveSchemaFromType((Class)((Class)parameterizedType.getActualTypeArguments()[0]), null, null);
        if (schemaN.getType() == null) {
            schemaN = SpringDocAnnotationsUtils.extractSchema(components, parameterizedType.getActualTypeArguments()[0]);
        }
        return schemaN;
    }

    private void buildApiResponses(Components components, Method method, io.swagger.v3.oas.models.responses.ApiResponses apiResponsesOp, MethodAttributes methodAttributes, String httpCode, ApiResponse apiResponse, boolean isGeneric) {
        if (apiResponse.getContent() == null) {
            Content content = this.buildContent(components, method, methodAttributes.getAllProduces());
            apiResponse.setContent(content);
        }
        if (StringUtils.isBlank((CharSequence)apiResponse.getDescription())) {
            apiResponse.setDescription("default response");
        }
        if (apiResponse.getContent() != null && (isGeneric || methodAttributes.isMethodOverloaded())) {
            Content existingContent = apiResponse.getContent();
            Schema<?> schemaN = this.calculateSchema(components, method.getGenericReturnType());
            if (schemaN != null && ArrayUtils.isNotEmpty((Object[])methodAttributes.getAllProduces())) {
                for (String mediaTypeStr : methodAttributes.getAllProduces()) {
                    this.mergeSchema(existingContent, schemaN, mediaTypeStr);
                }
            }
        }
        apiResponsesOp.addApiResponse(httpCode, apiResponse);
    }

    private void mergeSchema(Content existingContent, Schema<?> schemaN, String mediaTypeStr) {
        if (existingContent.containsKey((Object)mediaTypeStr)) {
            MediaType mediaType = (MediaType)existingContent.get((Object)mediaTypeStr);
            if (!schemaN.equals((Object)mediaType.getSchema())) {
                ComposedSchema schemaObject;
                Schema firstSchema = mediaType.getSchema();
                if (firstSchema instanceof ComposedSchema) {
                    schemaObject = (ComposedSchema)firstSchema;
                    List listOneOf = schemaObject.getOneOf();
                    if (!CollectionUtils.isEmpty((Collection)listOneOf) && !listOneOf.contains(schemaN)) {
                        schemaObject.addOneOfItem(schemaN);
                    }
                } else {
                    schemaObject = new ComposedSchema();
                    schemaObject.addOneOfItem(schemaN);
                    schemaObject.addOneOfItem(firstSchema);
                }
                mediaType.setSchema((Schema)schemaObject);
                existingContent.addMediaType(mediaTypeStr, mediaType);
            }
        } else {
            existingContent.addMediaType(mediaTypeStr, new MediaType().schema(schemaN));
        }
    }

    private String evaluateResponseStatus(Method method, Class<?> beanType, boolean isGeneric) {
        String responseStatus = null;
        ResponseStatus annotation = (ResponseStatus)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, ResponseStatus.class);
        if (annotation == null && beanType != null) {
            annotation = (ResponseStatus)AnnotatedElementUtils.findMergedAnnotation(beanType, ResponseStatus.class);
        }
        if (annotation != null) {
            responseStatus = String.valueOf(annotation.code().value());
        }
        if (annotation == null && !isGeneric) {
            responseStatus = String.valueOf(HttpStatus.OK.value());
        }
        return responseStatus;
    }

    private boolean isVoid(Type returnType) {
        return Void.TYPE.equals(returnType) || returnType instanceof ParameterizedType && Void.class.equals((Object)((ParameterizedType)returnType).getActualTypeArguments()[0]);
    }
}

