/*
 * Decompiled with CFR 0.152.
 */
package org.springaicommunity.mcp.context;

import com.fasterxml.jackson.core.type.TypeReference;
import io.modelcontextprotocol.common.McpTransportContext;
import io.modelcontextprotocol.server.McpSyncServerExchange;
import io.modelcontextprotocol.spec.McpSchema;
import io.modelcontextprotocol.util.Assert;
import io.modelcontextprotocol.util.Utils;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springaicommunity.mcp.context.DefaultElicitationSpec;
import org.springaicommunity.mcp.context.DefaultLoggingSpec;
import org.springaicommunity.mcp.context.DefaultProgressSpec;
import org.springaicommunity.mcp.context.DefaultSamplingSpec;
import org.springaicommunity.mcp.context.McpRequestContextTypes;
import org.springaicommunity.mcp.context.McpSyncRequestContext;
import org.springaicommunity.mcp.context.StructuredElicitResult;
import org.springaicommunity.mcp.method.tool.utils.ConcurrentReferenceHashMap;
import org.springaicommunity.mcp.method.tool.utils.JsonParser;
import org.springaicommunity.mcp.method.tool.utils.JsonSchemaGenerator;

public class DefaultMcpSyncRequestContext
implements McpSyncRequestContext {
    private static final Logger logger = LoggerFactory.getLogger(DefaultMcpSyncRequestContext.class);
    private static final Map<Type, Map<String, Object>> typeSchemaCache = new ConcurrentReferenceHashMap<Type, Map<String, Object>>(256);
    private static TypeReference<Map<String, Object>> MAP_TYPE_REF = new TypeReference<Map<String, Object>>(){};
    private final McpSchema.Request request;
    private final McpSyncServerExchange exchange;

    private DefaultMcpSyncRequestContext(McpSchema.Request request, McpSyncServerExchange exchange) {
        Assert.notNull((Object)request, (String)"Request must not be null");
        Assert.notNull((Object)exchange, (String)"Exchange must not be null");
        this.request = request;
        this.exchange = exchange;
    }

    @Override
    public boolean rootsEnabled() {
        return this.exchange.getClientCapabilities() != null && this.exchange.getClientCapabilities().roots() != null;
    }

    @Override
    public McpSchema.ListRootsResult roots() {
        if (!this.rootsEnabled()) {
            throw new IllegalStateException("Roots not supported by the client: " + String.valueOf(this.exchange.getClientInfo()));
        }
        return this.exchange.listRoots();
    }

    @Override
    public boolean elicitEnabled() {
        return this.exchange.getClientCapabilities() != null && this.exchange.getClientCapabilities().elicitation() != null;
    }

    @Override
    public <T> StructuredElicitResult<T> elicit(Class<T> type) {
        if (!this.elicitEnabled()) {
            throw new IllegalStateException("Elicitation not supported by the client: " + String.valueOf(this.exchange.getClientInfo()));
        }
        Assert.notNull(type, (String)"Elicitation response type must not be null");
        McpSchema.ElicitResult elicitResult = this.elicitationInternal("Please provide the required information.", type, null);
        if (elicitResult.action() != McpSchema.ElicitResult.Action.ACCEPT) {
            return new StructuredElicitResult<Object>(elicitResult.action(), null, elicitResult.meta());
        }
        return new StructuredElicitResult<T>(elicitResult.action(), JsonParser.convertMapToType((Map<String, Object>)elicitResult.content(), type), elicitResult.meta());
    }

    @Override
    public <T> StructuredElicitResult<T> elicit(TypeReference<T> type) {
        if (!this.elicitEnabled()) {
            throw new IllegalStateException("Elicitation not supported by the client: " + String.valueOf(this.exchange.getClientInfo()));
        }
        Assert.notNull(type, (String)"Elicitation response type must not be null");
        McpSchema.ElicitResult elicitResult = this.elicitationInternal("Please provide the required information.", type.getType(), null);
        if (elicitResult.action() != McpSchema.ElicitResult.Action.ACCEPT) {
            return new StructuredElicitResult<Object>(elicitResult.action(), null, elicitResult.meta());
        }
        return new StructuredElicitResult<T>(elicitResult.action(), JsonParser.convertMapToType((Map<String, Object>)elicitResult.content(), type), elicitResult.meta());
    }

    @Override
    public <T> StructuredElicitResult<T> elicit(Consumer<McpRequestContextTypes.ElicitationSpec> params, Class<T> returnType) {
        if (!this.elicitEnabled()) {
            throw new IllegalStateException("Elicitation not supported by the client: " + String.valueOf(this.exchange.getClientInfo()));
        }
        Assert.notNull(returnType, (String)"Elicitation response type must not be null");
        Assert.notNull(params, (String)"Elicitation params must not be null");
        DefaultElicitationSpec paramSpec = new DefaultElicitationSpec();
        params.accept(paramSpec);
        McpSchema.ElicitResult elicitResult = this.elicitationInternal(paramSpec.message(), returnType, paramSpec.meta());
        if (elicitResult.action() != McpSchema.ElicitResult.Action.ACCEPT) {
            return new StructuredElicitResult<Object>(elicitResult.action(), null, null);
        }
        return new StructuredElicitResult<T>(elicitResult.action(), JsonParser.convertMapToType((Map<String, Object>)elicitResult.content(), returnType), elicitResult.meta());
    }

    @Override
    public <T> StructuredElicitResult<T> elicit(Consumer<McpRequestContextTypes.ElicitationSpec> params, TypeReference<T> returnType) {
        if (!this.elicitEnabled()) {
            throw new IllegalStateException("Elicitation not supported by the client: " + String.valueOf(this.exchange.getClientInfo()));
        }
        Assert.notNull(returnType, (String)"Elicitation response type must not be null");
        Assert.notNull(params, (String)"Elicitation params must not be null");
        DefaultElicitationSpec paramSpec = new DefaultElicitationSpec();
        params.accept(paramSpec);
        McpSchema.ElicitResult elicitResult = this.elicitationInternal(paramSpec.message(), returnType.getType(), paramSpec.meta());
        if (elicitResult.action() != McpSchema.ElicitResult.Action.ACCEPT) {
            return new StructuredElicitResult<Object>(elicitResult.action(), null, null);
        }
        return new StructuredElicitResult<T>(elicitResult.action(), JsonParser.convertMapToType((Map<String, Object>)elicitResult.content(), returnType), elicitResult.meta());
    }

    @Override
    public McpSchema.ElicitResult elicit(McpSchema.ElicitRequest elicitRequest) {
        if (!this.elicitEnabled()) {
            throw new IllegalStateException("Elicitation not supported by the client: " + String.valueOf(this.exchange.getClientInfo()));
        }
        Assert.notNull((Object)elicitRequest, (String)"Elicit request must not be null");
        return this.exchange.createElicitation(elicitRequest);
    }

    private McpSchema.ElicitResult elicitationInternal(String message, Type type, Map<String, Object> meta) {
        Map schema = typeSchemaCache.computeIfAbsent(type, t -> this.generateElicitSchema((Type)t));
        McpSchema.ElicitRequest elicitRequest = McpSchema.ElicitRequest.builder().message(message).requestedSchema(schema).meta(meta).build();
        return this.exchange.createElicitation(elicitRequest);
    }

    private Map<String, Object> generateElicitSchema(Type type) {
        Map<String, Object> schema = JsonParser.fromJson(JsonSchemaGenerator.generateFromType(type), MAP_TYPE_REF);
        schema.remove("$schema");
        return schema;
    }

    @Override
    public boolean sampleEnabled() {
        return this.exchange.getClientCapabilities() != null && this.exchange.getClientCapabilities().sampling() != null;
    }

    @Override
    public McpSchema.CreateMessageResult sample(String ... messages) {
        return this.sample((McpRequestContextTypes.SamplingSpec s) -> s.message(messages));
    }

    @Override
    public McpSchema.CreateMessageResult sample(Consumer<McpRequestContextTypes.SamplingSpec> samplingSpec) {
        if (!this.sampleEnabled()) {
            throw new IllegalStateException("Sampling not supported by the client: " + String.valueOf(this.exchange.getClientInfo()));
        }
        Assert.notNull(samplingSpec, (String)"Sampling spec consumer must not be null");
        DefaultSamplingSpec spec = new DefaultSamplingSpec();
        samplingSpec.accept(spec);
        String progressToken = this.request.progressToken();
        return this.sample(McpSchema.CreateMessageRequest.builder().messages(spec.messages).modelPreferences(spec.modelPreferences).systemPrompt(spec.systemPrompt).temperature(spec.temperature).maxTokens(spec.maxTokens != null && spec.maxTokens > 0 ? spec.maxTokens : 500).stopSequences(spec.stopSequences.isEmpty() ? null : spec.stopSequences).includeContext(spec.includeContextStrategy).meta(spec.metadata.isEmpty() ? null : spec.metadata).progressToken(progressToken).meta(spec.meta.isEmpty() ? null : spec.meta).build());
    }

    @Override
    public McpSchema.CreateMessageResult sample(McpSchema.CreateMessageRequest createMessageRequest) {
        if (!this.sampleEnabled()) {
            throw new IllegalStateException("Sampling not supported by the client: " + String.valueOf(this.exchange.getClientInfo()));
        }
        return this.exchange.createMessage(createMessageRequest);
    }

    @Override
    public void progress(int percentage) {
        Assert.isTrue((percentage >= 0 && percentage <= 100 ? 1 : 0) != 0, (String)"Percentage must be between 0 and 100");
        this.progress((McpRequestContextTypes.ProgressSpec p) -> p.progress((double)percentage / 100.0).total(1.0).message(null));
    }

    @Override
    public void progress(Consumer<McpRequestContextTypes.ProgressSpec> progressSpec) {
        Assert.notNull(progressSpec, (String)"Progress spec consumer must not be null");
        DefaultProgressSpec spec = new DefaultProgressSpec();
        progressSpec.accept(spec);
        if (!Utils.hasText((String)this.request.progressToken())) {
            logger.warn("Progress notification not supported by the client!");
            return;
        }
        this.progress(new McpSchema.ProgressNotification(this.request.progressToken(), Double.valueOf(spec.progress), Double.valueOf(spec.total), spec.message, spec.meta));
    }

    @Override
    public void progress(McpSchema.ProgressNotification progressNotification) {
        this.exchange.progressNotification(progressNotification);
    }

    @Override
    public void ping() {
        this.exchange.ping();
    }

    @Override
    public void log(Consumer<McpRequestContextTypes.LoggingSpec> logSpec) {
        Assert.notNull(logSpec, (String)"Logging spec consumer must not be null");
        DefaultLoggingSpec spec = new DefaultLoggingSpec();
        logSpec.accept(spec);
        this.exchange.loggingNotification(McpSchema.LoggingMessageNotification.builder().data(spec.message).level(spec.level).logger(spec.logger).meta(spec.meta).build());
    }

    @Override
    public void debug(String message) {
        this.logInternal(message, McpSchema.LoggingLevel.DEBUG);
    }

    @Override
    public void info(String message) {
        this.logInternal(message, McpSchema.LoggingLevel.INFO);
    }

    @Override
    public void warn(String message) {
        this.logInternal(message, McpSchema.LoggingLevel.WARNING);
    }

    @Override
    public void error(String message) {
        this.logInternal(message, McpSchema.LoggingLevel.ERROR);
    }

    private void logInternal(String message, McpSchema.LoggingLevel level) {
        Assert.hasText((String)message, (String)"Log message must not be empty");
        this.exchange.loggingNotification(McpSchema.LoggingMessageNotification.builder().data(message).level(level).build());
    }

    @Override
    public McpSchema.Request request() {
        return this.request;
    }

    @Override
    public McpSyncServerExchange exchange() {
        return this.exchange;
    }

    @Override
    public String sessionId() {
        return this.exchange.sessionId();
    }

    @Override
    public McpSchema.Implementation clientInfo() {
        return this.exchange.getClientInfo();
    }

    @Override
    public McpSchema.ClientCapabilities clientCapabilities() {
        return this.exchange.getClientCapabilities();
    }

    @Override
    public Map<String, Object> requestMeta() {
        return this.request.meta();
    }

    @Override
    public McpTransportContext transportContext() {
        return this.exchange.transportContext();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private McpSchema.Request request;
        private McpSyncServerExchange exchange;

        private Builder() {
        }

        public Builder request(McpSchema.Request request) {
            this.request = request;
            return this;
        }

        public Builder exchange(McpSyncServerExchange exchange) {
            this.exchange = exchange;
            return this;
        }

        public McpSyncRequestContext build() {
            return new DefaultMcpSyncRequestContext(this.request, this.exchange);
        }
    }
}

