/*
 * Decompiled with CFR 0.152.
 */
package org.springaicommunity.mcp.provider.tool;

import io.modelcontextprotocol.server.McpServerFeatures;
import io.modelcontextprotocol.spec.McpSchema;
import io.modelcontextprotocol.util.Utils;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springaicommunity.mcp.annotation.McpTool;
import org.springaicommunity.mcp.method.tool.ReturnMode;
import org.springaicommunity.mcp.method.tool.SyncMcpToolMethodCallback;
import org.springaicommunity.mcp.method.tool.utils.ClassUtils;
import org.springaicommunity.mcp.method.tool.utils.JsonSchemaGenerator;
import org.springaicommunity.mcp.provider.McpProviderUtils;
import org.springaicommunity.mcp.provider.tool.AbstractMcpToolProvider;

public class SyncMcpToolProvider
extends AbstractMcpToolProvider {
    private static final Logger logger = LoggerFactory.getLogger(SyncMcpToolProvider.class);

    public SyncMcpToolProvider(List<Object> toolObjects) {
        super(toolObjects);
    }

    public List<McpServerFeatures.SyncToolSpecification> getToolSpecifications() {
        List<McpServerFeatures.SyncToolSpecification> toolSpecs = this.toolObjects.stream().map(toolObject -> Stream.of(this.doGetClassMethods(toolObject)).filter(method -> method.isAnnotationPresent(McpTool.class)).filter(McpProviderUtils.filterReactiveReturnTypeMethod()).sorted((m1, m2) -> m1.getName().compareTo(m2.getName())).map(mcpToolMethod -> {
            McpSchema.Tool tool;
            boolean useStructuredOtput;
            McpTool toolJavaAnnotation = this.doGetMcpToolAnnotation((Method)mcpToolMethod);
            String toolName = Utils.hasText((String)toolJavaAnnotation.name()) ? toolJavaAnnotation.name() : mcpToolMethod.getName();
            String toolDescription = toolJavaAnnotation.description();
            String inputSchema = JsonSchemaGenerator.generateForMethodInput(mcpToolMethod);
            McpSchema.Tool.Builder toolBuilder = McpSchema.Tool.builder().name(toolName).description(toolDescription).inputSchema(this.getJsonMapper(), inputSchema);
            String title = toolJavaAnnotation.title();
            if (toolJavaAnnotation.annotations() != null) {
                McpTool.McpAnnotations toolAnnotations = toolJavaAnnotation.annotations();
                toolBuilder.annotations(new McpSchema.ToolAnnotations(toolAnnotations.title(), Boolean.valueOf(toolAnnotations.readOnlyHint()), Boolean.valueOf(toolAnnotations.destructiveHint()), Boolean.valueOf(toolAnnotations.idempotentHint()), Boolean.valueOf(toolAnnotations.openWorldHint()), null));
                if (!Utils.hasText((String)title)) {
                    title = toolAnnotations.title();
                }
            }
            if (!Utils.hasText((String)title)) {
                title = toolName;
            }
            toolBuilder.title(title);
            Class<?> methodReturnType = mcpToolMethod.getReturnType();
            if (toolJavaAnnotation.generateOutputSchema() && methodReturnType != null && methodReturnType != McpSchema.CallToolResult.class && methodReturnType != Void.class && methodReturnType != Void.TYPE && !ClassUtils.isPrimitiveOrWrapper(methodReturnType) && !ClassUtils.isSimpleValueType(methodReturnType)) {
                toolBuilder.outputSchema(this.getJsonMapper(), JsonSchemaGenerator.generateFromType(mcpToolMethod.getGenericReturnType()));
            }
            boolean bl = useStructuredOtput = (tool = toolBuilder.build()).outputSchema() != null;
            ReturnMode returnMode = useStructuredOtput ? ReturnMode.STRUCTURED : (methodReturnType == Void.TYPE || methodReturnType == Void.TYPE ? ReturnMode.VOID : ReturnMode.TEXT);
            SyncMcpToolMethodCallback methodCallback = new SyncMcpToolMethodCallback(returnMode, (Method)mcpToolMethod, toolObject, this.doGetToolCallException());
            McpServerFeatures.SyncToolSpecification toolSpec = McpServerFeatures.SyncToolSpecification.builder().tool(tool).callHandler((BiFunction)methodCallback).build();
            return toolSpec;
        }).toList()).flatMap(Collection::stream).toList();
        if (toolSpecs.isEmpty()) {
            logger.warn("No tool methods found in the provided tool objects: {}", (Object)this.toolObjects);
        }
        return toolSpecs;
    }
}

