/*
 * Decompiled with CFR 0.152.
 */
package org.springaicommunity.mcp.provider.prompt;

import io.modelcontextprotocol.server.McpServerFeatures;
import io.modelcontextprotocol.spec.McpSchema;
import io.modelcontextprotocol.util.Assert;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springaicommunity.mcp.adapter.PromptAdapter;
import org.springaicommunity.mcp.annotation.McpPrompt;
import org.springaicommunity.mcp.method.prompt.AsyncMcpPromptMethodCallback;
import org.springaicommunity.mcp.provider.McpProviderUtils;

public class AsyncMcpPromptProvider {
    private static final Logger logger = LoggerFactory.getLogger(AsyncMcpPromptProvider.class);
    private final List<Object> promptObjects;

    public AsyncMcpPromptProvider(List<Object> promptObjects) {
        Assert.notNull(promptObjects, (String)"promptObjects cannot be null");
        this.promptObjects = promptObjects;
    }

    public List<McpServerFeatures.AsyncPromptSpecification> getPromptSpecifications() {
        List<McpServerFeatures.AsyncPromptSpecification> promptSpecs = this.promptObjects.stream().map(promptObject -> Stream.of(this.doGetClassMethods(promptObject)).filter(method -> method.isAnnotationPresent(McpPrompt.class)).filter(McpProviderUtils.filterNonReactiveReturnTypeMethod()).sorted((m1, m2) -> m1.getName().compareTo(m2.getName())).map(mcpPromptMethod -> {
            McpPrompt promptAnnotation = mcpPromptMethod.getAnnotation(McpPrompt.class);
            McpSchema.Prompt mcpPrompt = PromptAdapter.asPrompt(promptAnnotation, mcpPromptMethod);
            AsyncMcpPromptMethodCallback methodCallback = ((AsyncMcpPromptMethodCallback.Builder)((AsyncMcpPromptMethodCallback.Builder)((AsyncMcpPromptMethodCallback.Builder)AsyncMcpPromptMethodCallback.builder().method((Method)mcpPromptMethod)).bean(promptObject)).prompt(mcpPrompt)).build();
            return new McpServerFeatures.AsyncPromptSpecification(mcpPrompt, (BiFunction)methodCallback);
        }).toList()).flatMap(Collection::stream).toList();
        if (promptSpecs.isEmpty()) {
            logger.warn("No prompt methods found in the provided prompt objects: {}", this.promptObjects);
        }
        return promptSpecs;
    }

    protected Method[] doGetClassMethods(Object bean) {
        return bean.getClass().getDeclaredMethods();
    }
}

