/*
 * Decompiled with CFR 0.152.
 */
package org.springaicommunity.mcp.provider;

import java.lang.reflect.Method;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class McpProviderUtils {
    private static final Logger logger = LoggerFactory.getLogger(McpProviderUtils.class);
    private static final Pattern URI_VARIABLE_PATTERN = Pattern.compile("\\{([^/]+?)\\}");
    public static final Predicate<Method> isReactiveReturnType = method -> Mono.class.isAssignableFrom(method.getReturnType()) || Flux.class.isAssignableFrom(method.getReturnType()) || Publisher.class.isAssignableFrom(method.getReturnType());
    public static final Predicate<Method> isNotReactiveReturnType = method -> !Mono.class.isAssignableFrom(method.getReturnType()) && !Flux.class.isAssignableFrom(method.getReturnType()) && !Publisher.class.isAssignableFrom(method.getReturnType());

    public static boolean isUriTemplate(String uri) {
        return URI_VARIABLE_PATTERN.matcher(uri).find();
    }

    public static Predicate<Method> filterNonReactiveReturnTypeMethod() {
        return method -> {
            if (isReactiveReturnType.test((Method)method)) {
                return true;
            }
            logger.info("Sync providers doesn't support reactive return types. Skipping method {} with reactive return type {}", method, method.getReturnType());
            return false;
        };
    }

    public static Predicate<Method> filterReactiveReturnTypeMethod() {
        return method -> {
            if (isNotReactiveReturnType.test((Method)method)) {
                return true;
            }
            logger.info("Sync providers doesn't support reactive return types. Skipping method {} with reactive return type {}", method, method.getReturnType());
            return false;
        };
    }
}

