/*
 * Decompiled with CFR 0.152.
 */
package org.springaicommunity.mcp.method.tool.utils;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.victools.jsonschema.generator.FieldScope;
import com.github.victools.jsonschema.generator.MemberScope;
import com.github.victools.jsonschema.generator.Module;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfigBuilder;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfigPart;
import io.modelcontextprotocol.util.Utils;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.stream.Stream;
import org.springaicommunity.mcp.annotation.McpToolParam;

public final class SpringAiSchemaModule
implements Module {
    private final boolean requiredByDefault;

    public SpringAiSchemaModule(Option ... options) {
        this.requiredByDefault = Stream.of(options).noneMatch(option -> option == Option.PROPERTY_REQUIRED_FALSE_BY_DEFAULT);
    }

    public void applyToConfigBuilder(SchemaGeneratorConfigBuilder builder) {
        this.applyToConfigBuilder((SchemaGeneratorConfigPart<FieldScope>)builder.forFields());
    }

    private void applyToConfigBuilder(SchemaGeneratorConfigPart<FieldScope> configPart) {
        configPart.withDescriptionResolver(this::resolveDescription);
        configPart.withRequiredCheck(this::checkRequired);
    }

    private String resolveDescription(MemberScope<?, ?> member) {
        McpToolParam toolParamAnnotation = (McpToolParam)member.getAnnotationConsideringFieldAndGetter(McpToolParam.class);
        if (toolParamAnnotation != null && Utils.hasText((String)toolParamAnnotation.description())) {
            return toolParamAnnotation.description();
        }
        return null;
    }

    private boolean checkRequired(MemberScope<?, ?> member) {
        McpToolParam toolParamAnnotation = (McpToolParam)member.getAnnotationConsideringFieldAndGetter(McpToolParam.class);
        if (toolParamAnnotation != null) {
            return toolParamAnnotation.required();
        }
        JsonProperty propertyAnnotation = (JsonProperty)member.getAnnotationConsideringFieldAndGetter(JsonProperty.class);
        if (propertyAnnotation != null) {
            return propertyAnnotation.required();
        }
        Schema schemaAnnotation = (Schema)member.getAnnotationConsideringFieldAndGetter(Schema.class);
        if (schemaAnnotation != null) {
            return schemaAnnotation.requiredMode() == Schema.RequiredMode.REQUIRED || schemaAnnotation.requiredMode() == Schema.RequiredMode.AUTO || schemaAnnotation.required();
        }
        return this.requiredByDefault;
    }

    public static enum Option {
        PROPERTY_REQUIRED_FALSE_BY_DEFAULT;

    }
}

