/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.utility.compare;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spdx.library.InvalidSPDXAnalysisException;
import org.spdx.library.model.license.AnyLicenseInfo;
import org.spdx.library.model.license.ConjunctiveLicenseSet;
import org.spdx.library.model.license.DisjunctiveLicenseSet;
import org.spdx.library.model.license.ExtractedLicenseInfo;
import org.spdx.library.model.license.License;
import org.spdx.library.model.license.LicenseException;
import org.spdx.library.model.license.LicenseSet;
import org.spdx.library.model.license.ListedLicenseException;
import org.spdx.library.model.license.ListedLicenses;
import org.spdx.library.model.license.SpdxListedLicense;
import org.spdx.licenseTemplate.LicenseParserException;
import org.spdx.licenseTemplate.LicenseTemplateRuleException;
import org.spdx.licenseTemplate.SpdxLicenseTemplateHelper;
import org.spdx.utility.compare.CompareTemplateOutputHandler;
import org.spdx.utility.compare.FilterTemplateOutputHandler;
import org.spdx.utility.compare.LineColumn;
import org.spdx.utility.compare.SpdxCompareException;
import org.spdx.utility.compare.TemplateRegexMatcher;

public class LicenseCompareHelper {
    static final Logger logger = LoggerFactory.getLogger(LicenseCompareHelper.class);
    protected static final String TOKEN_SPLIT_REGEX = "(^|[^\\s\\.,?'();:\"/\\[\\]]{1,100})((\\s|\\.|,|\\?|'|\"|\\(|\\)|;|:|/|\\[|\\]|$){1,100})";
    protected static final Pattern TOKEN_SPLIT_PATTERN = Pattern.compile("(^|[^\\s\\.,?'();:\"/\\[\\]]{1,100})((\\s|\\.|,|\\?|'|\"|\\(|\\)|;|:|/|\\[|\\]|$){1,100})");
    protected static final Set<String> PUNCTUATION = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(".", ",", "?", "\"", "'", "(", ")", ";", ":", "/", "[", "]")));
    protected static final Set<String> SKIPPABLE_TOKENS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("//", "/*", "*/", "/**", "#", "##", "*", "**", "\"\"\"", "/", "=begin", "=end")));
    protected static final Map<String, String> NORMALIZE_TOKENS = new HashMap<String, String>();
    protected static final Integer CROSS_REF_NUM_WORDS_MATCH = 80;
    protected static final Pattern REGEX_QUANTIFIER_PATTERN = Pattern.compile(".*\\.\\{(\\d+),(\\d+)\\}$");
    static final String DASHES_REGEX = "[\\u2012\\u2013\\u2014\\u2015]";
    static final Pattern SPACE_PATTERN;
    static final Pattern COMMA_PATTERN;
    static final Pattern PER_CENT_PATTERN;
    static final Pattern COPYRIGHT_HOLDER_PATTERN;
    static final Pattern COPYRIGHT_HOLDERS_PATTERN;
    static final Pattern COPYRIGHT_OWNERS_PATTERN;
    static final Pattern COPYRIGHT_OWNER_PATTERN;
    static final Pattern PER_CENT_PATTERN_LF;
    static final Pattern COPYRIGHT_HOLDERS_PATTERN_LF;
    static final Pattern COPYRIGHT_HOLDER_PATTERN_LF;
    static final Pattern COPYRIGHT_OWNERS_PATTERN_LF;
    static final Pattern COPYRIGHT_OWNER_PATTERN_LF;
    static final Pattern COPYRIGHT_SYMBOL_PATTERN;
    static final String START_COMMENT_CHAR_PATTERN = "(//|/\\*|\\*|#|' |REM |<!--|--|;|\\(\\*|\\{-)|\\.\\\\\"";

    public static boolean isLicenseTextEquivalent(String licenseTextA, String licenseTextB) {
        if (licenseTextA == null) {
            return licenseTextB == null || licenseTextB.isEmpty();
        }
        if (licenseTextB == null) {
            return licenseTextA.isEmpty();
        }
        if (licenseTextA.equals(licenseTextB)) {
            return true;
        }
        HashMap<Integer, LineColumn> tokenToLocationA = new HashMap<Integer, LineColumn>();
        HashMap<Integer, LineColumn> tokenToLocationB = new HashMap<Integer, LineColumn>();
        String[] licenseATokens = LicenseCompareHelper.tokenizeLicenseText(licenseTextA, tokenToLocationA);
        String[] licenseBTokens = LicenseCompareHelper.tokenizeLicenseText(licenseTextB, tokenToLocationB);
        int bTokenCounter = 0;
        int aTokenCounter = 0;
        String nextAToken = LicenseCompareHelper.getTokenAt(licenseATokens, aTokenCounter++);
        String nextBToken = LicenseCompareHelper.getTokenAt(licenseBTokens, bTokenCounter++);
        while (nextAToken != null) {
            if (nextBToken == null) {
                while (nextAToken != null && LicenseCompareHelper.canSkip(nextAToken)) {
                    nextAToken = LicenseCompareHelper.getTokenAt(licenseATokens, aTokenCounter++);
                }
                if (nextAToken == null) continue;
                return false;
            }
            if (LicenseCompareHelper.tokensEquivalent(nextAToken, nextBToken)) {
                nextAToken = LicenseCompareHelper.getTokenAt(licenseATokens, aTokenCounter++);
                nextBToken = LicenseCompareHelper.getTokenAt(licenseBTokens, bTokenCounter++);
                continue;
            }
            while (nextBToken != null && LicenseCompareHelper.canSkip(nextBToken)) {
                nextBToken = LicenseCompareHelper.getTokenAt(licenseBTokens, bTokenCounter++);
            }
            while (nextAToken != null && LicenseCompareHelper.canSkip(nextAToken)) {
                nextAToken = LicenseCompareHelper.getTokenAt(licenseATokens, aTokenCounter++);
            }
            if (!LicenseCompareHelper.tokensEquivalent(nextAToken, nextBToken)) {
                return false;
            }
            nextAToken = LicenseCompareHelper.getTokenAt(licenseATokens, aTokenCounter++);
            nextBToken = LicenseCompareHelper.getTokenAt(licenseBTokens, bTokenCounter++);
        }
        while (nextBToken != null && LicenseCompareHelper.canSkip(nextBToken)) {
            nextBToken = LicenseCompareHelper.getTokenAt(licenseBTokens, bTokenCounter++);
        }
        return nextBToken == null;
    }

    public static String removeLineSeparators(String s) {
        return s.replaceAll("(-|=|\\*){3,}\\s*$", "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String removeCommentChars(String s) {
        StringBuilder sb = new StringBuilder();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new StringReader(s));
            String line = reader.readLine();
            while (line != null) {
                line = line.replaceAll("(\\*/|-->|-\\}|\\*\\)|\\s\\*)\\s*$", "");
                line = line.replaceAll("^\\s*(//|/\\*|\\*|#|' |REM |<!--|--|;|\\(\\*|\\{-)|\\.\\\\\"", "");
                line = line.replaceAll("^\\s*<<beginOptional>>\\s*(//|/\\*|\\*|#|' |REM |<!--|--|;|\\(\\*|\\{-)|\\.\\\\\"", "<<beginOptional>>");
                sb.append(line);
                sb.append("\n");
                line = reader.readLine();
            }
            String string = sb.toString();
            return string;
        }
        catch (IOException e) {
            logger.warn("IO error reading strings?!?", (Throwable)e);
            String string = s;
            return string;
        }
        finally {
            if (Objects.nonNull(reader)) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    logger.warn("IO error closing a string reader?!?", (Throwable)e);
                }
            }
        }
    }

    public static String normalizeText(String s) {
        return s.replaceAll("\u2018|\u2019|\u201b|\u201a|`", "'").replaceAll("http://", "https://").replaceAll("''", "\"").replaceAll("\u201c|\u201d|\u201f|\u201e", "\"").replaceAll("\\u00A0", " ").replaceAll("\u2014|\u2013", "-").replaceAll("\\u2028", "\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String locateOriginalText(String fullLicenseText, int startToken, int endToken, Map<Integer, LineColumn> tokenToLocation, String[] tokens) {
        if (startToken > endToken) {
            return "";
        }
        LineColumn start = tokenToLocation.get(startToken);
        if (start == null) {
            return "";
        }
        LineColumn end = tokenToLocation.get(endToken);
        BufferedReader reader = null;
        try {
            int currentLine;
            reader = new BufferedReader(new StringReader(fullLicenseText));
            String line = reader.readLine();
            for (currentLine = 1; line != null && currentLine < start.getLine(); ++currentLine) {
                line = reader.readLine();
            }
            if (line == null) {
                String string = "";
                return string;
            }
            if (end == null) {
                StringBuilder sb = new StringBuilder(line.substring(start.getColumn(), line.length()));
                ++currentLine;
                line = reader.readLine();
                while (true) {
                    if (line == null) {
                        String string = sb.toString();
                        return string;
                    }
                    sb.append(line);
                    ++currentLine;
                    line = reader.readLine();
                }
            }
            if (end.getLine() == currentLine) {
                String sb = line.substring(start.getColumn(), end.getColumn() + end.getLen());
                return sb;
            }
            StringBuilder sb = new StringBuilder(line.substring(start.getColumn(), line.length()));
            ++currentLine;
            line = reader.readLine();
            while (line != null && currentLine < end.getLine()) {
                sb.append("\n");
                sb.append(line);
                ++currentLine;
                line = reader.readLine();
            }
            if (line != null && end.getColumn() + end.getLen() > 0) {
                sb.append("\n");
                sb.append(line.substring(0, end.getColumn() + end.getLen()));
            }
            String string = sb.toString();
            return string;
        }
        catch (IOException e) {
            StringBuilder sb = new StringBuilder(tokens[startToken]);
            int i = startToken + 1;
            while (true) {
                if (i > endToken) {
                    String string = sb.toString();
                    return string;
                }
                sb.append(' ');
                sb.append(tokens[i]);
                ++i;
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] tokenizeLicenseText(String licenseText, Map<Integer, LineColumn> tokenToLocation) {
        String textToTokenize = LicenseCompareHelper.normalizeText(LicenseCompareHelper.replaceMultWord(LicenseCompareHelper.replaceSpaceComma(licenseText))).toLowerCase();
        ArrayList<String> tokens = new ArrayList<String>();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new StringReader(textToTokenize));
            int currentLine = 1;
            int currentToken = 0;
            String line = reader.readLine();
            while (line != null) {
                line = LicenseCompareHelper.removeLineSeparators(line);
                Matcher lineMatcher = TOKEN_SPLIT_PATTERN.matcher(line);
                while (lineMatcher.find()) {
                    String token = lineMatcher.group(1).trim();
                    if (!token.isEmpty()) {
                        tokens.add(token);
                        tokenToLocation.put(currentToken, new LineColumn(currentLine, lineMatcher.start(), token.length()));
                        ++currentToken;
                    }
                    String fullMatch = lineMatcher.group(0);
                    for (int i = lineMatcher.group(1).length(); i < fullMatch.length(); ++i) {
                        String possiblePunctuation = fullMatch.substring(i, i + 1);
                        if (!PUNCTUATION.contains(possiblePunctuation)) continue;
                        tokens.add(possiblePunctuation);
                        tokenToLocation.put(currentToken, new LineColumn(currentLine, lineMatcher.start() + i, 1));
                        ++currentToken;
                    }
                }
                ++currentLine;
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            Matcher m = TOKEN_SPLIT_PATTERN.matcher(textToTokenize);
            while (m.find()) {
                String word = m.group(1).trim();
                String seperator = m.group(2).trim();
                tokens.add(word);
                if (!PUNCTUATION.contains(seperator)) continue;
                tokens.add(seperator);
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return tokens.toArray(new String[tokens.size()]);
    }

    public static String getFirstLicenseToken(String text) {
        String textToTokenize = LicenseCompareHelper.normalizeText(LicenseCompareHelper.replaceMultWord(LicenseCompareHelper.replaceSpaceComma(LicenseCompareHelper.removeLineSeparators(LicenseCompareHelper.removeCommentChars(text))))).toLowerCase();
        Matcher m = TOKEN_SPLIT_PATTERN.matcher(textToTokenize);
        while (m.find()) {
            if (m.group(1).trim().isEmpty()) continue;
            return m.group(1).trim();
        }
        return null;
    }

    public static boolean isSingleTokenString(String text) {
        if (text.contains("\n")) {
            return false;
        }
        Matcher m = TOKEN_SPLIT_PATTERN.matcher(text);
        boolean found = false;
        while (m.find()) {
            if (m.group(1).trim().isEmpty()) continue;
            if (found) {
                return false;
            }
            found = true;
        }
        return true;
    }

    static String replaceSpaceComma(String s) {
        Matcher spaceMatcher = SPACE_PATTERN.matcher(s);
        Matcher commaMatcher = COMMA_PATTERN.matcher(spaceMatcher.replaceAll(" "));
        return commaMatcher.replaceAll(",");
    }

    static String replaceMultWord(String s) {
        Matcher m = COPYRIGHT_HOLDERS_PATTERN.matcher(s);
        String retval = m.replaceAll("copyright-holders");
        m = COPYRIGHT_HOLDERS_PATTERN_LF.matcher(retval);
        retval = m.replaceAll("copyright-holders\n");
        m = COPYRIGHT_OWNERS_PATTERN.matcher(retval);
        retval = m.replaceAll("copyright-owners");
        m = COPYRIGHT_OWNERS_PATTERN_LF.matcher(retval);
        retval = m.replaceAll("copyright-owners\n");
        m = COPYRIGHT_HOLDER_PATTERN.matcher(retval);
        retval = m.replaceAll("copyright-holder");
        m = COPYRIGHT_HOLDER_PATTERN_LF.matcher(retval);
        retval = m.replaceAll("copyright-holder\n");
        m = COPYRIGHT_OWNER_PATTERN.matcher(retval);
        retval = m.replaceAll("copyright-owner");
        m = COPYRIGHT_OWNER_PATTERN_LF.matcher(retval);
        retval = m.replaceAll("copyright-owner\n");
        m = PER_CENT_PATTERN.matcher(retval);
        retval = m.replaceAll("percent");
        m = PER_CENT_PATTERN.matcher(retval);
        retval = m.replaceAll("percent\n");
        m = COPYRIGHT_SYMBOL_PATTERN.matcher(retval);
        retval = m.replaceAll("-c-");
        return retval;
    }

    static String getTokenAt(String[] tokens, int tokenIndex) {
        if (tokenIndex >= tokens.length) {
            return null;
        }
        return tokens[tokenIndex];
    }

    static boolean tokensEquivalent(String tokenA, String tokenB) {
        String ns2;
        String s2;
        if (tokenA == null) {
            return tokenB == null;
        }
        if (tokenB == null) {
            return false;
        }
        String s1 = tokenA.trim().toLowerCase().replaceAll(DASHES_REGEX, "-");
        if (s1.equals(s2 = tokenB.trim().toLowerCase().replaceAll(DASHES_REGEX, "-"))) {
            return true;
        }
        String ns1 = NORMALIZE_TOKENS.get(s1);
        if (ns1 == null) {
            ns1 = s1;
        }
        if ((ns2 = NORMALIZE_TOKENS.get(s2)) == null) {
            ns2 = s2;
        }
        return ns1.equals(ns2);
    }

    static boolean canSkip(String token) {
        if (token == null) {
            return false;
        }
        if (token.trim().isEmpty()) {
            return true;
        }
        return SKIPPABLE_TOKENS.contains(token.trim().toLowerCase());
    }

    public static boolean isLicenseEqual(AnyLicenseInfo license1, AnyLicenseInfo license2, Map<String, String> xlationMap) throws SpdxCompareException, InvalidSPDXAnalysisException {
        if (license1 instanceof ConjunctiveLicenseSet) {
            if (!(license2 instanceof ConjunctiveLicenseSet)) {
                return false;
            }
            return LicenseCompareHelper.isLicenseSetsEqual((ConjunctiveLicenseSet)license1, (ConjunctiveLicenseSet)license2, xlationMap);
        }
        if (license1 instanceof DisjunctiveLicenseSet) {
            if (!(license2 instanceof DisjunctiveLicenseSet)) {
                return false;
            }
            return LicenseCompareHelper.isLicenseSetsEqual((DisjunctiveLicenseSet)license1, (DisjunctiveLicenseSet)license2, xlationMap);
        }
        if (license1 instanceof ExtractedLicenseInfo) {
            if (!(license2 instanceof ExtractedLicenseInfo)) {
                return false;
            }
            String licenseid1 = ((ExtractedLicenseInfo)license1).getLicenseId();
            String licenseid2 = ((ExtractedLicenseInfo)license2).getLicenseId();
            String xlatedLicenseId = xlationMap.get(licenseid1);
            if (xlatedLicenseId == null) {
                return false;
            }
            return xlatedLicenseId.equals(licenseid2);
        }
        return license1.equals(license2);
    }

    private static boolean isLicenseSetsEqual(LicenseSet license1, LicenseSet license2, Map<String, String> xlationMap) throws SpdxCompareException, InvalidSPDXAnalysisException {
        Collection<AnyLicenseInfo> licenseInfos1 = license1.getMembers();
        Collection<AnyLicenseInfo> licenseInfos2 = license2.getMembers();
        if (licenseInfos1 == null) {
            return licenseInfos2 == null;
        }
        if (licenseInfos2 == null) {
            return false;
        }
        if (licenseInfos1.size() != licenseInfos2.size()) {
            return false;
        }
        for (AnyLicenseInfo ali1 : licenseInfos1) {
            boolean found = false;
            for (AnyLicenseInfo ali2 : licenseInfos2) {
                if (!LicenseCompareHelper.isLicenseEqual(ali1, ali2, xlationMap)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    @Deprecated
    public static List<String> getNonOptionalLicenseText(String licenseTemplate, boolean includeVarText) throws SpdxCompareException {
        return LicenseCompareHelper.getNonOptionalLicenseText(licenseTemplate, includeVarText ? FilterTemplateOutputHandler.VarTextHandling.ORIGINAL : FilterTemplateOutputHandler.VarTextHandling.OMIT, FilterTemplateOutputHandler.OptionalTextHandling.OMIT);
    }

    public static List<String> getNonOptionalLicenseText(String licenseTemplate, FilterTemplateOutputHandler.VarTextHandling varTextHandling) throws SpdxCompareException {
        return LicenseCompareHelper.getNonOptionalLicenseText(licenseTemplate, varTextHandling, FilterTemplateOutputHandler.OptionalTextHandling.OMIT);
    }

    public static List<String> getNonOptionalLicenseText(String licenseTemplate, FilterTemplateOutputHandler.VarTextHandling varTextHandling, FilterTemplateOutputHandler.OptionalTextHandling optionalTextHandling) throws SpdxCompareException {
        FilterTemplateOutputHandler filteredOutput = new FilterTemplateOutputHandler(varTextHandling, optionalTextHandling);
        try {
            SpdxLicenseTemplateHelper.parseTemplate(licenseTemplate, filteredOutput);
        }
        catch (LicenseTemplateRuleException e) {
            throw new SpdxCompareException("Invalid template rule found during filter: " + e.getMessage(), e);
        }
        catch (LicenseParserException e) {
            throw new SpdxCompareException("Invalid template found during filter: " + e.getMessage(), e);
        }
        return filteredOutput.getFilteredText();
    }

    @Deprecated
    public static Pair<Pattern, Pattern> nonOptionalTextToPatterns(List<String> nonOptionalText, int numberOfWords) {
        if (Objects.isNull(nonOptionalText) || nonOptionalText.size() == 0 || numberOfWords < 1) {
            return new ImmutablePair((Object)Pattern.compile(""), (Object)Pattern.compile(""));
        }
        int startWordCount = 0;
        int startTextIndex = 0;
        int wordsInLastLine = 0;
        StringBuilder startPatternBuilder = new StringBuilder();
        String regexLimit = "," + Integer.toString(numberOfWords * 10) + "}";
        String lastRegex = "";
        while (startWordCount < numberOfWords && startTextIndex < nonOptionalText.size()) {
            String line = nonOptionalText.get(startTextIndex++);
            String[] regexSplits = line.trim().split("~~~");
            boolean inRegex = false;
            for (String regexSplit : regexSplits) {
                if (inRegex && startWordCount < numberOfWords) {
                    String regexToAppend = regexSplit.endsWith(".+") ? regexSplit.substring(0, regexSplit.length() - 1) + "{1" + regexLimit : (regexSplit.endsWith(".*") ? regexSplit.substring(0, regexSplit.length() - 1) + "{0" + regexLimit : regexSplit);
                    if (startPatternBuilder.toString().endsWith("}") && regexToAppend.endsWith("}")) {
                        Matcher lastRegexMatch = REGEX_QUANTIFIER_PATTERN.matcher(lastRegex);
                        Matcher regexToAppendMatch = REGEX_QUANTIFIER_PATTERN.matcher(regexToAppend);
                        if (lastRegexMatch.matches() && regexToAppendMatch.matches()) {
                            int thisRegexMax;
                            int lastRegexMax = Integer.parseInt(lastRegexMatch.group(2));
                            if (lastRegexMax >= (thisRegexMax = Integer.parseInt(regexToAppendMatch.group(2)))) {
                                regexToAppend = "";
                            } else {
                                startPatternBuilder.setLength(startPatternBuilder.length() - (lastRegexMatch.group(2).length() + 1));
                                regexToAppend = regexToAppend.substring(regexToAppend.indexOf(44) + 1);
                            }
                        }
                    }
                    startPatternBuilder.append(regexToAppend);
                    lastRegex = regexToAppend;
                    ++startWordCount;
                    inRegex = false;
                    continue;
                }
                String[] tokens = LicenseCompareHelper.normalizeText(regexSplit.trim()).split("\\s");
                int tokenIndex = 0;
                wordsInLastLine = 0;
                while (tokenIndex < tokens.length && startWordCount < numberOfWords) {
                    String token;
                    if ((token = tokens[tokenIndex++].trim()).length() <= 0) continue;
                    if (NORMALIZE_TOKENS.containsKey(token.toLowerCase())) {
                        token = NORMALIZE_TOKENS.get(token.toLowerCase());
                    }
                    startPatternBuilder.append(Pattern.quote(token));
                    startPatternBuilder.append("\\s*");
                    ++startWordCount;
                    ++wordsInLastLine;
                }
                inRegex = true;
            }
        }
        StringBuilder endPatternBuilder = new StringBuilder();
        ArrayList<String> endTextReversePattern = new ArrayList<String>();
        int endTextIndex = nonOptionalText.size() - 1;
        int endWordCount = 0;
        int lastProcessedStartLine = startTextIndex - 1;
        while (endWordCount < numberOfWords && (endTextIndex > lastProcessedStartLine || endTextIndex == lastProcessedStartLine && numberOfWords - endWordCount < nonOptionalText.get(endTextIndex).length() - wordsInLastLine)) {
            ArrayList<String> nonEmptyTokens = new ArrayList<String>();
            String line = nonOptionalText.get(endTextIndex);
            String[] regexSplits = line.trim().split("~~~");
            boolean inRegex = false;
            for (String regexSplit : regexSplits) {
                String[] tokens;
                if (inRegex) {
                    if (!regexSplit.isEmpty()) {
                        nonEmptyTokens.add("~~~" + regexSplit);
                    }
                    inRegex = false;
                    continue;
                }
                for (String token : tokens = LicenseCompareHelper.normalizeText(regexSplit.trim()).split("\\s")) {
                    String trimmedToken = token.trim();
                    if (trimmedToken.isEmpty()) continue;
                    nonEmptyTokens.add(trimmedToken);
                }
                inRegex = true;
            }
            int remainingTokens = endTextIndex == lastProcessedStartLine && nonEmptyTokens.size() - wordsInLastLine > numberOfWords - endWordCount ? numberOfWords - endWordCount : nonEmptyTokens.size() - wordsInLastLine;
            --endTextIndex;
            int tokenIndex = nonEmptyTokens.size() - 1;
            while (tokenIndex >= 0 && remainingTokens > 0) {
                String token;
                if ((token = (String)nonEmptyTokens.get(tokenIndex--)).startsWith("~~~")) {
                    endTextReversePattern.add(token.substring("~~~".length()));
                } else {
                    endTextReversePattern.add("\\s*");
                    if (NORMALIZE_TOKENS.containsKey(token.toLowerCase())) {
                        token = NORMALIZE_TOKENS.get(token.toLowerCase());
                    }
                    endTextReversePattern.add(Pattern.quote(token));
                }
                --remainingTokens;
                ++endWordCount;
            }
        }
        int revPatternIndex = endTextReversePattern.size() - 1;
        while (revPatternIndex >= 0) {
            endPatternBuilder.append((String)endTextReversePattern.get(revPatternIndex--));
        }
        return new ImmutablePair((Object)Pattern.compile(startPatternBuilder.toString(), 34), (Object)Pattern.compile(endPatternBuilder.toString(), 34));
    }

    public static CompareTemplateOutputHandler.DifferenceDescription isTextMatchingTemplate(String template, String compareText) throws SpdxCompareException, InvalidSPDXAnalysisException {
        CompareTemplateOutputHandler compareTemplateOutputHandler = null;
        try {
            compareTemplateOutputHandler = new CompareTemplateOutputHandler(LicenseCompareHelper.removeLineSeparators(LicenseCompareHelper.removeCommentChars(compareText)));
        }
        catch (IOException e1) {
            throw new SpdxCompareException("IO Error reading the compare text: " + e1.getMessage(), e1);
        }
        try {
            SpdxLicenseTemplateHelper.parseTemplate(LicenseCompareHelper.removeCommentChars(template), compareTemplateOutputHandler);
        }
        catch (LicenseTemplateRuleException e) {
            throw new SpdxCompareException("Invalid template rule found during compare: " + e.getMessage(), e);
        }
        catch (LicenseParserException e) {
            throw new SpdxCompareException("Invalid template found during compare: " + e.getMessage(), e);
        }
        return compareTemplateOutputHandler.getDifferences();
    }

    public static CompareTemplateOutputHandler.DifferenceDescription isTextStandardLicense(License license, String compareText) throws SpdxCompareException, InvalidSPDXAnalysisException {
        String licenseTemplate = license.getStandardLicenseTemplate();
        if (licenseTemplate == null || licenseTemplate.trim().isEmpty()) {
            licenseTemplate = license.getLicenseText();
        }
        return LicenseCompareHelper.isTextMatchingTemplate(licenseTemplate, compareText);
    }

    public static CompareTemplateOutputHandler.DifferenceDescription isTextStandardException(LicenseException exception, String compareText) throws SpdxCompareException, InvalidSPDXAnalysisException {
        String exceptionTemplate = exception.getLicenseExceptionTemplate();
        if (exceptionTemplate == null || exceptionTemplate.trim().isEmpty()) {
            exceptionTemplate = exception.getLicenseExceptionText();
        }
        return LicenseCompareHelper.isTextMatchingTemplate(exceptionTemplate, compareText);
    }

    public static boolean isStandardLicenseWithinText(String text, SpdxListedLicense license) {
        try {
            return new TemplateRegexMatcher(license.getStandardLicenseTemplate()).isTemplateMatchWithinText(text);
        }
        catch (SpdxCompareException e) {
            logger.warn("Error getting optional text for license ID " + license.getLicenseId(), (Throwable)e);
            return false;
        }
        catch (InvalidSPDXAnalysisException e) {
            logger.warn("Error getting optional text for license ID " + license.getLicenseId(), (Throwable)e);
            return false;
        }
    }

    public static boolean isStandardLicenseExceptionWithinText(String text, ListedLicenseException exception) {
        boolean result = false;
        if (text == null || text.isEmpty() || exception == null) {
            return false;
        }
        try {
            return new TemplateRegexMatcher(exception.getLicenseExceptionTemplate()).isTemplateMatchWithinText(text);
        }
        catch (SpdxCompareException e) {
            logger.warn("Error getting optional text for license exception ID " + exception.getLicenseExceptionId(), (Throwable)e);
        }
        catch (InvalidSPDXAnalysisException e) {
            logger.warn("Error getting optional text for license exception ID " + exception.getLicenseExceptionId(), (Throwable)e);
        }
        return result;
    }

    public static String[] matchingStandardLicenseIds(String licenseText) throws InvalidSPDXAnalysisException, SpdxCompareException {
        List<String> stdLicenseIds = ListedLicenses.getListedLicenses().getSpdxListedLicenseIds();
        ArrayList<String> matchingIds = new ArrayList<String>();
        for (String stdLicId : stdLicenseIds) {
            SpdxListedLicense license = ListedLicenses.getListedLicenses().getListedLicenseById(stdLicId);
            if (LicenseCompareHelper.isTextStandardLicense(license, licenseText).isDifferenceFound()) continue;
            matchingIds.add(license.getLicenseId());
        }
        return matchingIds.toArray(new String[matchingIds.size()]);
    }

    public static List<String> matchingStandardLicenseIdsWithinText(String text, List<String> licenseIds) throws InvalidSPDXAnalysisException, SpdxCompareException {
        ArrayList<String> result = new ArrayList<String>();
        if (text != null && !text.isEmpty() && licenseIds != null && !licenseIds.isEmpty()) {
            for (String stdLicId : licenseIds) {
                SpdxListedLicense license = ListedLicenses.getListedLicenses().getListedLicenseById(stdLicId);
                if (!LicenseCompareHelper.isStandardLicenseWithinText(text, license)) continue;
                result.add(license.getLicenseId());
            }
        }
        return result;
    }

    public static List<String> matchingStandardLicenseIdsWithinText(String text) throws InvalidSPDXAnalysisException, SpdxCompareException {
        return LicenseCompareHelper.matchingStandardLicenseIdsWithinText(text, ListedLicenses.getListedLicenses().getSpdxListedLicenseIds());
    }

    public static List<String> matchingStandardLicenseExceptionIdsWithinText(String text, List<String> licenseExceptionIds) throws InvalidSPDXAnalysisException, SpdxCompareException {
        ArrayList<String> result = new ArrayList<String>();
        if (text != null && !text.isEmpty() && licenseExceptionIds != null && !licenseExceptionIds.isEmpty()) {
            for (String stdLicExcId : licenseExceptionIds) {
                ListedLicenseException licenseException = ListedLicenses.getListedLicenses().getListedExceptionById(stdLicExcId);
                if (!LicenseCompareHelper.isStandardLicenseExceptionWithinText(text, licenseException)) continue;
                result.add(licenseException.getLicenseExceptionId());
            }
        }
        return result;
    }

    public static List<String> matchingStandardLicenseExceptionIdsWithinText(String text) throws InvalidSPDXAnalysisException, SpdxCompareException {
        return LicenseCompareHelper.matchingStandardLicenseExceptionIdsWithinText(text, ListedLicenses.getListedLicenses().getSpdxListedExceptionIds());
    }

    private static <T> boolean contains(T[] array, T value) {
        for (T t : array) {
            if (!Objects.equals(t, value)) continue;
            return true;
        }
        return false;
    }

    public static boolean isLicensePassBlackList(AnyLicenseInfo license, String ... blackList) throws InvalidSPDXAnalysisException {
        if (license == null) {
            return true;
        }
        if (blackList == null || blackList.length == 0) {
            return true;
        }
        if (license instanceof ConjunctiveLicenseSet) {
            for (AnyLicenseInfo member : ((ConjunctiveLicenseSet)license).getMembers()) {
                if (LicenseCompareHelper.isLicensePassBlackList(member, blackList)) continue;
                return false;
            }
            return true;
        }
        if (license instanceof DisjunctiveLicenseSet) {
            for (AnyLicenseInfo member : ((DisjunctiveLicenseSet)license).getMembers()) {
                if (!LicenseCompareHelper.isLicensePassBlackList(member, blackList)) continue;
                return true;
            }
            return false;
        }
        return !LicenseCompareHelper.contains(blackList, license.toString());
    }

    public static boolean isLicensePassWhiteList(AnyLicenseInfo license, String ... whiteList) throws InvalidSPDXAnalysisException {
        if (license == null) {
            return false;
        }
        if (whiteList == null || whiteList.length == 0) {
            return false;
        }
        if (license instanceof ConjunctiveLicenseSet) {
            for (AnyLicenseInfo member : ((ConjunctiveLicenseSet)license).getMembers()) {
                if (LicenseCompareHelper.isLicensePassWhiteList(member, whiteList)) continue;
                return false;
            }
            return true;
        }
        if (license instanceof DisjunctiveLicenseSet) {
            for (AnyLicenseInfo member : ((DisjunctiveLicenseSet)license).getMembers()) {
                if (!LicenseCompareHelper.isLicensePassWhiteList(member, whiteList)) continue;
                return true;
            }
            return false;
        }
        return LicenseCompareHelper.contains(whiteList, license.toString());
    }

    static {
        NORMALIZE_TOKENS.put("&", "and");
        NORMALIZE_TOKENS.put("acknowledgment", "acknowledgement");
        NORMALIZE_TOKENS.put("analogue", "analog");
        NORMALIZE_TOKENS.put("analyse", "analyze");
        NORMALIZE_TOKENS.put("artefact", "artifact");
        NORMALIZE_TOKENS.put("authorisation", "authorization");
        NORMALIZE_TOKENS.put("authorised", "authorized");
        NORMALIZE_TOKENS.put("calibre", "caliber");
        NORMALIZE_TOKENS.put("cancelled", "canceled");
        NORMALIZE_TOKENS.put("apitalisations", "apitalizations");
        NORMALIZE_TOKENS.put("catalogue", "catalog");
        NORMALIZE_TOKENS.put("categorise", "categorize");
        NORMALIZE_TOKENS.put("centre", "center");
        NORMALIZE_TOKENS.put("emphasised", "emphasized");
        NORMALIZE_TOKENS.put("favour", "favor");
        NORMALIZE_TOKENS.put("favourite", "favorite");
        NORMALIZE_TOKENS.put("fulfil", "fulfill");
        NORMALIZE_TOKENS.put("fulfilment", "fulfillment");
        NORMALIZE_TOKENS.put("initialise", "initialize");
        NORMALIZE_TOKENS.put("judgment", "judgement");
        NORMALIZE_TOKENS.put("labelling", "labeling");
        NORMALIZE_TOKENS.put("labour", "labor");
        NORMALIZE_TOKENS.put("licence", "license");
        NORMALIZE_TOKENS.put("maximise", "maximize");
        NORMALIZE_TOKENS.put("modelled", "modeled");
        NORMALIZE_TOKENS.put("modelling", "modeling");
        NORMALIZE_TOKENS.put("offence", "offense");
        NORMALIZE_TOKENS.put("optimise", "optimize");
        NORMALIZE_TOKENS.put("organisation", "organization");
        NORMALIZE_TOKENS.put("organise", "organize");
        NORMALIZE_TOKENS.put("practise", "practice");
        NORMALIZE_TOKENS.put("programme", "program");
        NORMALIZE_TOKENS.put("realise", "realize");
        NORMALIZE_TOKENS.put("recognise", "recognize");
        NORMALIZE_TOKENS.put("signalling", "signaling");
        NORMALIZE_TOKENS.put("utilisation", "utilization");
        NORMALIZE_TOKENS.put("whilst", "while");
        NORMALIZE_TOKENS.put("wilful", "wilfull");
        NORMALIZE_TOKENS.put("non-commercial", "noncommercial");
        NORMALIZE_TOKENS.put("copyright-owner", "copyright-holder");
        NORMALIZE_TOKENS.put("sublicense", "sub-license");
        NORMALIZE_TOKENS.put("non-infringement", "noninfringement");
        NORMALIZE_TOKENS.put("(c)", "-c-");
        NORMALIZE_TOKENS.put("\u00a9", "-c-");
        NORMALIZE_TOKENS.put("copyright", "-c-");
        NORMALIZE_TOKENS.put("\"", "'");
        NORMALIZE_TOKENS.put("merchantability", "merchantability");
        SPACE_PATTERN = Pattern.compile("[\\u202F\\u2007\\u2060\\u2009]");
        COMMA_PATTERN = Pattern.compile("[\\uFF0C\\uFE10\\uFE50]");
        PER_CENT_PATTERN = Pattern.compile("per cent", 2);
        COPYRIGHT_HOLDER_PATTERN = Pattern.compile("copyright holder", 2);
        COPYRIGHT_HOLDERS_PATTERN = Pattern.compile("copyright holders", 2);
        COPYRIGHT_OWNERS_PATTERN = Pattern.compile("copyright owners", 2);
        COPYRIGHT_OWNER_PATTERN = Pattern.compile("copyright owner", 2);
        PER_CENT_PATTERN_LF = Pattern.compile("per\\s{0,100}\\n{1,10}\\s{0,100}cent", 2);
        COPYRIGHT_HOLDERS_PATTERN_LF = Pattern.compile("copyright\\s{0,100}\\n{1,10}\\s{0,100}holders", 2);
        COPYRIGHT_HOLDER_PATTERN_LF = Pattern.compile("copyright\\s{0,100}\\n{1,10}\\s{0,100}holder", 2);
        COPYRIGHT_OWNERS_PATTERN_LF = Pattern.compile("copyright\\s{0,100}\\n{1,10}\\s{0,100}owners", 2);
        COPYRIGHT_OWNER_PATTERN_LF = Pattern.compile("copyright\\s{0,100}\\n{1,10}\\s{0,100}owner", 2);
        COPYRIGHT_SYMBOL_PATTERN = Pattern.compile("\\(c\\)", 2);
    }
}

