/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.licenseTemplate;

import org.spdx.licenseTemplate.ILicenseTemplateOutputHandler;
import org.spdx.licenseTemplate.LicenseTemplateRule;
import org.spdx.licenseTemplate.SpdxLicenseTemplateHelper;

public class HtmlTemplateOutputHandler
implements ILicenseTemplateOutputHandler {
    public static final String REPLACEABLE_LICENSE_TEXT_CLASS = "replaceable-license-text";
    public static final String OPTIONAL_LICENSE_TEXT_CLASS = "optional-license-text";
    static final String END_PARAGRAPH_TAG = "</p>";
    private static final String STARTS_WITH_LETTER_REGEX = "[A-Za-z].*";
    StringBuilder htmlString = new StringBuilder();
    int optionalNestLevel = 0;
    boolean movingParagraph = false;

    @Override
    public void text(String text) {
        if (this.optionalNestLevel > 0) {
            this.htmlString.append(SpdxLicenseTemplateHelper.formatEscapeHTML(text, false));
        } else {
            this.htmlString.append(SpdxLicenseTemplateHelper.formatEscapeHTML(text, this.movingParagraph));
            this.movingParagraph = false;
        }
    }

    @Override
    public void variableRule(LicenseTemplateRule rule) {
        this.removeEndParagraphTag();
        this.htmlString.append(HtmlTemplateOutputHandler.formatReplaceabledHTML(rule.getOriginal(), rule.getName()));
    }

    private void addRemovedEndParagraphTag() {
        if (this.movingParagraph) {
            if (this.endsInEndParagraph()) {
                this.htmlString.append(END_PARAGRAPH_TAG);
            }
            this.movingParagraph = false;
        }
    }

    private boolean endsInEndParagraph() {
        int lastEndParagraph = this.htmlString.lastIndexOf(END_PARAGRAPH_TAG);
        return lastEndParagraph == this.htmlString.length() - END_PARAGRAPH_TAG.length();
    }

    private void removeEndParagraphTag() {
        if (this.endsInEndParagraph()) {
            this.movingParagraph = true;
            this.htmlString.delete(this.htmlString.length() - END_PARAGRAPH_TAG.length(), this.htmlString.length());
        }
    }

    public static String formatReplaceabledHTML(String text, String id) {
        StringBuilder sb = new StringBuilder();
        sb.append("\n<span ");
        if (id != null && !id.trim().isEmpty()) {
            sb.append("id=\"");
            sb.append(HtmlTemplateOutputHandler.escapeIdString(id));
            sb.append("\" ");
        }
        sb.append("class=\"");
        sb.append(REPLACEABLE_LICENSE_TEXT_CLASS);
        sb.append("\">");
        sb.append(SpdxLicenseTemplateHelper.formatEscapeHTML(text));
        sb.append("</span>\n");
        return sb.toString();
    }

    public static String escapeIdString(String id) {
        String retval = id;
        if (!retval.matches(STARTS_WITH_LETTER_REGEX)) {
            retval = "X" + retval;
        }
        for (int i = 0; i < retval.length(); ++i) {
            char c = retval.charAt(i);
            if (HtmlTemplateOutputHandler.validIdChar(c)) continue;
            retval = retval.replace(c, '_');
        }
        return retval;
    }

    private static boolean validIdChar(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '-' || c == '_' || c == '.';
    }

    public String getHtml() {
        return this.htmlString.toString();
    }

    @Override
    public void beginOptional(LicenseTemplateRule rule) {
        if (this.optionalNestLevel == 0) {
            this.removeEndParagraphTag();
            this.htmlString.append(HtmlTemplateOutputHandler.formatStartOptionalHTML(rule.getName()));
        }
        ++this.optionalNestLevel;
    }

    public static String formatStartOptionalHTML(String id) {
        StringBuilder sb = new StringBuilder();
        sb.append("\n<div ");
        if (id != null && !id.trim().isEmpty()) {
            sb.append("id=\"");
            sb.append(HtmlTemplateOutputHandler.escapeIdString(id));
            sb.append("\" ");
        }
        sb.append("class=\"");
        sb.append(OPTIONAL_LICENSE_TEXT_CLASS);
        sb.append("\">\n");
        return sb.toString();
    }

    public static String formatEndOptionalHTML(boolean inParagraph) {
        if (inParagraph) {
            return "</div>\n</p>\n";
        }
        return "</div>\n";
    }

    @Override
    public void endOptional(LicenseTemplateRule rule) {
        --this.optionalNestLevel;
        if (this.optionalNestLevel == 0) {
            this.htmlString.append(HtmlTemplateOutputHandler.formatEndOptionalHTML(this.movingParagraph));
            this.movingParagraph = false;
        }
    }

    @Override
    public void completeParsing() {
    }
}

