/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.xml.schemas;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;

public final class SchemaResolver
implements LSResourceResolver {
    private static final String XHTML1_STRICT_XSD = "xhtml1/xhtml1-strict.xsd";
    private static final Logger LOG = LoggerFactory.getLogger(SchemaResolver.class);
    private static final Map<String, String> SCHEMAS_BUILTIN = new HashMap<String, String>();
    private static final Map<String, String> DTD_BUILTIN = new HashMap<String, String>();
    private static final String[] SCHEMA_FOLDERS;

    private static LSInput createLSInput(@Nullable InputStream inputStream) {
        if (inputStream != null) {
            try {
                DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
                DOMImplementation impl = registry.getDOMImplementation("XML 1.0 LS 3.0");
                DOMImplementationLS implls = (DOMImplementationLS)((Object)impl);
                LSInput lsInput = implls.createLSInput();
                lsInput.setByteStream(inputStream);
                return lsInput;
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new IllegalStateException(e);
            }
        }
        return null;
    }

    private static InputStream getBuiltinDTD(String publicId) {
        String fileName = DTD_BUILTIN.get(publicId);
        if (fileName != null) {
            return SchemaResolver.getBuiltinDTDByFileName(fileName);
        }
        return null;
    }

    private static InputStream getBuiltinDTDByFileName(String fileName) {
        return SchemaResolver.class.getResourceAsStream("/org/sonar/plugins/xml/dtd/" + fileName);
    }

    @CheckForNull
    public static InputStream getBuiltinSchema(String systemId) {
        InputStream input = SchemaResolver.getBuiltinSchemaByNamespace(systemId);
        if (input != null) {
            return input;
        }
        input = SchemaResolver.getBuiltinSchemaByFileName(systemId);
        if (input != null) {
            return input;
        }
        input = SchemaResolver.getSchemaByURL(systemId);
        if (input != null) {
            return input;
        }
        try {
            return new FileInputStream(systemId);
        }
        catch (FileNotFoundException e) {
            LOG.warn("Could not find schema " + systemId);
            return null;
        }
    }

    private static InputStream getSchemaByURL(String urlStr) {
        URL url;
        try {
            url = new URL(urlStr);
        }
        catch (MalformedURLException e) {
            return null;
        }
        try {
            return url.openStream();
        }
        catch (IOException e) {
            LOG.debug("Could not get URL {}, due to {}", (Object)urlStr, (Object)e.toString());
            return null;
        }
    }

    private static InputStream getBuiltinSchemaByFileName(String fileName) {
        InputStream input = null;
        try {
            input = SchemaResolver.class.getResourceAsStream(fileName);
        }
        catch (Exception e) {
            LOG.warn("Error while trying to read {}", (Object)fileName, (Object)e);
        }
        if (input == null) {
            String folder;
            String[] stringArray = SCHEMA_FOLDERS;
            int n = stringArray.length;
            for (int i = 0; i < n && (input = SchemaResolver.class.getResourceAsStream((folder = stringArray[i]) + "/" + fileName)) == null; ++i) {
            }
        }
        return input;
    }

    private static InputStream getBuiltinSchemaByNamespace(String nameSpace) {
        String fileName = SCHEMAS_BUILTIN.get(nameSpace);
        if (fileName != null) {
            return SchemaResolver.getBuiltinSchemaByFileName(fileName);
        }
        return null;
    }

    @Override
    public LSInput resolveResource(String type, String namespaceURI, @Nullable String publicId, String systemId, String baseURI) {
        InputStream input;
        LOG.debug("Trying to resolve type = {} namespace = {} publicId = {} systemId = {} baseURI = {}", (Object[])new String[]{type, namespaceURI, publicId, systemId, baseURI});
        if (publicId != null && publicId.contains("//DTD")) {
            input = SchemaResolver.getBuiltinDTD(publicId);
        } else {
            input = SchemaResolver.getBuiltinSchemaByNamespace(namespaceURI);
            if (input == null) {
                input = SchemaResolver.getBuiltinSchemaByFileName(systemId);
            }
            if (input == null) {
                input = StringUtils.startsWithIgnoreCase((String)systemId, (String)"html") ? SchemaResolver.getBuiltinDTDByFileName("html4/" + systemId) : SchemaResolver.getBuiltinDTDByFileName("xhtml1/" + systemId);
            }
        }
        if (input == null) {
            LOG.debug("Could not resolve resource {}", (Object)systemId);
            return null;
        }
        return SchemaResolver.createLSInput(input);
    }

    static {
        SCHEMAS_BUILTIN.put("http://www.w3.org/2001/xml.xsd", "xml.xsd");
        SCHEMAS_BUILTIN.put("http://www.w3.org/XML/1998/namespace", "xml.xsd");
        SCHEMAS_BUILTIN.put("-//W3C//DTD XHTML 1.0 Strict//EN", XHTML1_STRICT_XSD);
        SCHEMAS_BUILTIN.put("-//W3C//DTD XHTML 1.0 Transitional//EN", "xhtml1/xhtml1-transitional.xsd");
        SCHEMAS_BUILTIN.put("-//W3C//DTD XHTML 1.0 Frameset//EN", "xhtml1/xhtml1-frameset.xsd");
        SCHEMAS_BUILTIN.put("http://www.w3.org/1999/xhtml", XHTML1_STRICT_XSD);
        SCHEMAS_BUILTIN.put("xhtml1-strict", XHTML1_STRICT_XSD);
        SCHEMAS_BUILTIN.put("xhtml1-transitional", "xhtml1/xhtml1-transitional.xsd");
        SCHEMAS_BUILTIN.put("xhtml1-frameset", "xhtml1/xhtml1-frameset.xsd");
        SCHEMAS_BUILTIN.put("-//W3C//DTD XHTML 1.1 Strict//EN", "xhtml11/xhtml11.xsd");
        SCHEMAS_BUILTIN.put("http://java.sun.com/jsf/core", "jsf/jsf-core-2.0.xsd");
        SCHEMAS_BUILTIN.put("http://java.sun.com/jsf/html", "jsf/html-basic-2.0.xsd");
        SCHEMAS_BUILTIN.put("http://java.sun.com/jsf/facelets", "jsf/facelets-ui-2.0.xsd");
        SCHEMAS_BUILTIN.put("http://maven.apache.org/POM/4.0.0", "maven/maven-4.0.0.xsd");
        DTD_BUILTIN.put("-//W3C//DTD HTML 3.2//EN", "html32/html32.dtd");
        DTD_BUILTIN.put("-//W3C//DTD HTML 3.2 Final//EN", "html32/html32.dtd");
        DTD_BUILTIN.put("-//W3C//DTD HTML 4.0//EN", "html4/strict.dtd");
        DTD_BUILTIN.put("-//W3C//DTD HTML 4.0 Transitional//EN", "html4/loose.dtd");
        DTD_BUILTIN.put("-//W3C//DTD HTML 4.0 Frameset//EN", "html4/frameset.dtd");
        DTD_BUILTIN.put("-//W3C//DTD HTML 4.01//EN", "html4/strict.dtd");
        DTD_BUILTIN.put("-//W3C//DTD HTML 4.01 Transitional//EN", "html4/loose.dtd");
        DTD_BUILTIN.put("-//W3C//DTD HTML 4.01 Frameset//EN", "html4/frameset.dtd");
        DTD_BUILTIN.put("-//W3C//DTD XHTML 1.0 Strict//EN", "xhtml1/xhtml1-strict.dtd");
        DTD_BUILTIN.put("-//W3C//DTD XHTML 1.0 Transitional//EN", "xhtml1/xhtml1-transitional.dtd");
        DTD_BUILTIN.put("-//W3C//DTD XHTML 1.0 Frameset//EN", "xhtml1/xhtml1-frameset.dtd");
        DTD_BUILTIN.put("//W3C//DTD XHTML 1.1//EN", "xhtml1/xhtml11.dtd");
        SCHEMA_FOLDERS = new String[]{"xhtml1", "jsf"};
    }
}

