/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.xml.parsers;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.xerces.jaxp.SAXParserFactoryImpl;
import org.xml.sax.SAXException;

public abstract class AbstractParser {
    private static final SAXParserFactory SAX_FACTORY_NAMESPACE_AWARE = new SAXParserFactoryImpl();
    private static final SAXParserFactory SAX_FACTORY_NAMESPACE_UNAWARE = new SAXParserFactoryImpl();

    protected SAXParser newSaxParser(boolean namespaceAware) {
        try {
            return namespaceAware ? SAX_FACTORY_NAMESPACE_AWARE.newSAXParser() : SAX_FACTORY_NAMESPACE_UNAWARE.newSAXParser();
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new IllegalStateException(e);
        }
    }

    private static void setCommonConf(SAXParserFactory factory) {
        try {
            factory.setValidating(false);
            factory.setFeature("http://xml.org/sax/features/validation", false);
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new IllegalStateException(e);
        }
    }

    static {
        AbstractParser.setCommonConf(SAX_FACTORY_NAMESPACE_AWARE);
        SAX_FACTORY_NAMESPACE_AWARE.setNamespaceAware(true);
        AbstractParser.setCommonConf(SAX_FACTORY_NAMESPACE_UNAWARE);
        SAX_FACTORY_NAMESPACE_UNAWARE.setNamespaceAware(false);
    }
}

