/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.xml.checks;

import org.apache.commons.lang.StringUtils;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.xml.checks.AbstractXmlCheck;
import org.sonar.plugins.xml.checks.XmlSourceCode;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@Rule(key="IllegalTabCheck")
public class IllegalTabCheck
extends AbstractXmlCheck {
    @RuleProperty(key="markAll", description="Mark all tab errors", defaultValue="false")
    private boolean markAll;
    private boolean validationReady;

    private void findIllegalTabs(Node node) {
        for (Node sibling = node.getPreviousSibling(); sibling != null; sibling = sibling.getPreviousSibling()) {
            String text;
            if (sibling.getNodeType() != 3 || !StringUtils.isWhitespace((String)(text = sibling.getTextContent())) || !StringUtils.contains((String)text, (String)"\t")) continue;
            this.createNewViolation(this.getWebSourceCode().getLineForNode(sibling));
            break;
        }
        for (Node child = node.getFirstChild(); !this.validationReady && child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1) continue;
            this.findIllegalTabs(child);
        }
    }

    private void createNewViolation(int lineNumber) {
        if (!this.markAll) {
            this.createViolation(lineNumber, "Tab characters found (this is the first occurrence)");
            this.validationReady = true;
        } else {
            this.createViolation(lineNumber, "Detect tab characters in your XML files.");
        }
    }

    @Override
    public void validate(XmlSourceCode xmlSourceCode) {
        this.setWebSourceCode(xmlSourceCode);
        this.validationReady = false;
        Document document = this.getWebSourceCode().getDocument(false);
        if (document.getDocumentElement() != null) {
            this.findIllegalTabs(document.getDocumentElement());
        }
    }

    public boolean isMarkAll() {
        return this.markAll;
    }

    public void setMarkAll(boolean markAll) {
        this.markAll = markAll;
    }
}

