/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.xml;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import org.sonar.plugins.xml.compat.CompatibleInputFile;

public class FileUtils {
    private FileUtils() {
    }

    public static List<String> readLines(CompatibleInputFile file) throws IOException {
        try (BufferedReader reader = FileUtils.newBufferedReader(file);){
            List<String> list = reader.lines().collect(Collectors.toList());
            return list;
        }
    }

    private static BufferedReader newBufferedReader(CompatibleInputFile file) throws IOException {
        return new BufferedReader(new StringReader(file.contents()));
    }

    public static String contents(Path path, Charset charset) throws IOException {
        return new String(Files.readAllBytes(path), charset);
    }
}

