/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.test.html;

import java.io.IOException;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.sonar.test.html.HtmlFragmentAssert;
import org.sonar.test.html.MultipartMessageAssert;

public final class MimeMessageAssert
extends AbstractAssert<MimeMessageAssert, MimeMessage> {
    public MimeMessageAssert(MimeMessage mimeMessage) {
        super((Object)mimeMessage, MimeMessageAssert.class);
    }

    public static MimeMessageAssert assertThat(MimeMessage m) {
        return new MimeMessageAssert(m);
    }

    public MultipartMessageAssert isMultipart() {
        this.isNotNull();
        try {
            Object content = ((MimeMessage)this.actual).getContent();
            Assertions.assertThat((Object)content).isInstanceOf(MimeMultipart.class);
            MimeMultipart m = (MimeMultipart)content;
            return new MultipartMessageAssert(m);
        }
        catch (IOException | MessagingException e) {
            throw new IllegalStateException(e);
        }
    }

    public HtmlFragmentAssert isHtml() {
        return this.isMultipart().isHtml();
    }

    public MimeMessageAssert hasRecipient(String userEmail) {
        this.isNotNull();
        try {
            Assertions.assertThat((String)((MimeMessage)this.actual).getHeader("To", null)).isEqualTo(String.format("<%s>", userEmail));
        }
        catch (MessagingException e) {
            throw new IllegalStateException(e);
        }
        return this;
    }

    public MimeMessageAssert subjectContains(String text) {
        this.isNotNull();
        try {
            Assertions.assertThat((String)((MimeMessage)this.actual).getSubject()).contains(new CharSequence[]{text});
        }
        catch (MessagingException e) {
            throw new IllegalStateException(e);
        }
        return this;
    }
}

