/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.test.html;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.jsoup.nodes.Element;
import org.sonar.test.html.HtmlBlockAssert;
import org.sonar.test.html.HtmlParagraphAssert;

public class HtmlListAssert
extends HtmlBlockAssert<HtmlListAssert> {
    private final Iterator<Element> nextBlocks;

    public HtmlListAssert(Element list, Iterator<Element> nextBlocks) {
        super(list, HtmlListAssert.class);
        this.nextBlocks = nextBlocks;
    }

    static void verifyIsList(Element element) {
        ((AbstractStringAssert)Assertions.assertThat((String)element.tagName()).describedAs("next block is neither a <%s> nor a <%s> (got <%s>):\n---fragment---\n%s\n---fragment---", new Object[]{"ul", "ol", element.tagName(), element.toString()})).isIn(new Object[]{"ul", "ol"});
    }

    public HtmlListAssert withItemTexts(String firstItemText, String ... otherItemsText) {
        this.isNotNull();
        List itemsText = ((Element)this.actual).children().stream().filter(t -> t.tagName().equals("li")).map(Element::text).collect(Collectors.toList());
        Object[] itemTexts = (String[])Stream.concat(Stream.of(firstItemText), Arrays.stream(otherItemsText)).toArray(String[]::new);
        ((ListAssert)Assertions.assertThat(itemsText).describedAs("\n---fragment---\n%s\n---fragment---", new Object[]{this.actual})).containsOnly(itemTexts);
        return this;
    }

    public HtmlParagraphAssert hasParagraph(String text) {
        return this.hasParagraph().withText(text);
    }

    public HtmlParagraphAssert hasEmptyParagraph() {
        Element paragraph = this.hasParagraphImpl();
        ((AbstractStringAssert)Assertions.assertThat((String)paragraph.text()).describedAs("\n---fragment---\n%s\n---fragment---", new Object[]{paragraph})).isIn(new Object[]{"", "\u00a0"});
        return new HtmlParagraphAssert(paragraph, this.nextBlocks);
    }

    public HtmlParagraphAssert hasParagraph() {
        Element element = this.hasParagraphImpl();
        return new HtmlParagraphAssert(element, this.nextBlocks);
    }

    private Element hasParagraphImpl() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.nextBlocks.hasNext()).describedAs("no more block", new Object[0])).isTrue();
        Element element = this.nextBlocks.next();
        HtmlParagraphAssert.verifyIsParagraph(element);
        return element;
    }
}

