/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.webhook.ws;

import java.util.Optional;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.webhook.WebhookDto;
import org.sonar.server.user.UserSession;
import org.sonar.server.webhook.ws.WebhookSupport;
import org.sonar.server.webhook.ws.WebhooksWsAction;
import org.sonar.server.ws.WsUtils;

public class UpdateAction
implements WebhooksWsAction {
    private final DbClient dbClient;
    private final UserSession userSession;
    private final WebhookSupport webhookSupport;

    public UpdateAction(DbClient dbClient, UserSession userSession, WebhookSupport webhookSupport) {
        this.dbClient = dbClient;
        this.userSession = userSession;
        this.webhookSupport = webhookSupport;
    }

    public void define(WebService.NewController controller) {
        WebService.NewAction action = controller.createAction("update").setPost(true).setDescription("Update a Webhook.<br>Requires 'Administer' permission on the specified project, or global 'Administer' permission.").setSince("7.1").setHandler((RequestHandler)this);
        action.createParam("webhook").setRequired(true).setMaximumLength(Integer.valueOf(40)).setDescription("The key of the webhook to be updated,auto-generated value can be obtained through api/webhooks/create or api/webhooks/list").setExampleValue((Object)"my_project");
        action.createParam("name").setRequired(true).setMaximumLength(Integer.valueOf(100)).setDescription("new name of the webhook").setExampleValue((Object)"My Webhook");
        action.createParam("url").setRequired(true).setMaximumLength(Integer.valueOf(512)).setDescription("new url to be called by the webhook").setExampleValue((Object)"https://www.my-webhook-listener.com/sonar");
    }

    public void handle(Request request, Response response) throws Exception {
        this.userSession.checkLoggedIn();
        String webhookKey = request.param("webhook");
        String name = request.mandatoryParam("name");
        String url = request.mandatoryParam("url");
        this.webhookSupport.checkUrlPattern(url, "Url parameter with value '%s' is not a valid url", url);
        try (DbSession dbSession = this.dbClient.openSession(false);){
            String projectUuid;
            Optional dtoOptional = this.dbClient.webhookDao().selectByUuid(dbSession, webhookKey);
            WebhookDto webhookDto = (WebhookDto)WsUtils.checkFoundWithOptional(dtoOptional, "No webhook with key '%s'", webhookKey);
            String organizationUuid = webhookDto.getOrganizationUuid();
            if (organizationUuid != null) {
                Optional optionalDto = this.dbClient.organizationDao().selectByUuid(dbSession, organizationUuid);
                OrganizationDto organizationDto = (OrganizationDto)WsUtils.checkStateWithOptional(optionalDto, "the requested organization '%s' was not found", organizationUuid);
                this.webhookSupport.checkPermission(organizationDto);
                this.updateWebhook(dbSession, webhookDto, name, url);
            }
            if ((projectUuid = webhookDto.getProjectUuid()) != null) {
                Optional<Object> optionalDto = Optional.ofNullable(this.dbClient.componentDao().selectByUuid(dbSession, projectUuid).orNull());
                ComponentDto componentDto = (ComponentDto)WsUtils.checkStateWithOptional(optionalDto, "the requested project '%s' was not found", projectUuid);
                this.webhookSupport.checkPermission(componentDto);
                this.updateWebhook(dbSession, webhookDto, name, url);
            }
            dbSession.commit();
        }
        response.noContent();
    }

    private void updateWebhook(DbSession dbSession, WebhookDto webhookDto, String name, String url) {
        this.dbClient.webhookDao().update(dbSession, webhookDto.setName(name).setUrl(url));
    }
}

