/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.webhook;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public final class Branch {
    private final boolean main;
    private final String name;
    private final Type type;

    public Branch(boolean main, @Nullable String name, Type type) {
        this.main = main;
        this.name = name;
        this.type = Objects.requireNonNull(type, "type can't be null");
    }

    public boolean isMain() {
        return this.main;
    }

    public Optional<String> getName() {
        return Optional.ofNullable(this.name);
    }

    public Type getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Branch branch = (Branch)o;
        return this.main == branch.main && Objects.equals(this.name, branch.name) && this.type == branch.type;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.main, this.name, this.type});
    }

    public String toString() {
        return "Branch{main=" + this.main + ", name='" + this.name + '\'' + ", type=" + (Object)((Object)this.type) + '}';
    }

    public static enum Type {
        LONG,
        SHORT,
        PULL_REQUEST;

    }
}

