/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.view.index;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.sort.SortOrder;
import org.sonar.api.ce.ComputeEngineSide;
import org.sonar.api.server.ServerSide;
import org.sonar.server.es.EsClient;
import org.sonar.server.view.index.ViewIndexDefinition;

@ServerSide
@ComputeEngineSide
public class ViewIndex {
    private static final int SCROLL_TIME_IN_MINUTES = 3;
    private final EsClient esClient;

    public ViewIndex(EsClient esClient) {
        this.esClient = esClient;
    }

    public List<String> findAllViewUuids() {
        String scrollId;
        SearchRequestBuilder esSearch = this.esClient.prepareSearch(ViewIndexDefinition.INDEX_TYPE_VIEW).addSort("_doc", SortOrder.ASC).setScroll(TimeValue.timeValueMinutes((long)3L)).setFetchSource(false).setSize(100).setQuery((QueryBuilder)QueryBuilders.matchAllQuery());
        SearchResponse response = (SearchResponse)esSearch.get();
        ArrayList result = Lists.newArrayList();
        do {
            ArrayList hits = Lists.newArrayList((Iterable)response.getHits());
            for (SearchHit hit : hits) {
                result.add(hit.getId());
            }
        } while ((response = (SearchResponse)this.esClient.prepareSearchScroll(scrollId = response.getScrollId()).setScroll(TimeValue.timeValueMinutes((long)3L)).get()).getHits().getHits().length != 0);
        this.esClient.nativeClient().prepareClearScroll().addScrollId(scrollId).get();
        return result;
    }
}

