/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.user.ws;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.protobuf.Message;
import java.util.Collections;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.server.ws.Change;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.core.util.Protobuf;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.user.UserDto;
import org.sonar.server.user.ExternalIdentity;
import org.sonar.server.user.NewUser;
import org.sonar.server.user.UserSession;
import org.sonar.server.user.UserUpdater;
import org.sonar.server.user.ws.EmailValidator;
import org.sonar.server.user.ws.UsersWsAction;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.Users;

public class CreateAction
implements UsersWsAction {
    private final DbClient dbClient;
    private final UserUpdater userUpdater;
    private final UserSession userSession;

    public CreateAction(DbClient dbClient, UserUpdater userUpdater, UserSession userSession) {
        this.dbClient = dbClient;
        this.userUpdater = userUpdater;
        this.userSession = userSession;
    }

    public void define(WebService.NewController controller) {
        WebService.NewAction action = controller.createAction("create").setDescription("Create a user.<br/>If a deactivated user account exists with the given login, it will be reactivated.<br/>Requires Administer System permission").setSince("3.7").setChangelog(new Change[]{new Change("6.3", "The password is only mandatory when creating local users, and should not be set on non local users"), new Change("6.3", "The 'infos' message is no more returned when a user is reactivated")}).setPost(true).setResponseExample(this.getClass().getResource("create-example.json")).setHandler((RequestHandler)this);
        action.createParam("login").setRequired(true).setMaximumLength(Integer.valueOf(255)).setDescription("User login").setExampleValue((Object)"myuser");
        action.createParam("password").setDescription("User password. Only mandatory when creating local user, otherwise it should not be set").setExampleValue((Object)"mypassword");
        action.createParam("name").setRequired(true).setMaximumLength(Integer.valueOf(200)).setDescription("User name").setExampleValue((Object)"My Name");
        action.createParam("email").setMaximumLength(Integer.valueOf(100)).setDescription("User email").setExampleValue((Object)"myname@email.com");
        action.createParam("scmAccounts").setDescription("Comma-separated list of SCM accounts. This parameter is deprecated, please use '%s' instead", new Object[]{"scmAccount"}).setDeprecatedKey("scm_accounts", "6.0").setDeprecatedSince("6.1").setExampleValue((Object)"myscmaccount1,myscmaccount2");
        action.createParam("scmAccount").setDescription("List of SCM accounts. To set several values, the parameter must be called once for each value.").setExampleValue((Object)"scmAccount=firstValue&scmAccount=secondValue&scmAccount=thirdValue");
        action.createParam("local").setDescription("Specify if the user should be authenticated from SonarQube server or from an external authentication system. Password should not be set when local is set to false.").setSince("6.3").setDefaultValue((Object)"true").setBooleanPossibleValues();
    }

    public void handle(Request request, Response response) throws Exception {
        this.userSession.checkLoggedIn().checkIsSystemAdministrator();
        CreateRequest createRequest = CreateAction.toWsRequest(request);
        Preconditions.checkArgument((boolean)EmailValidator.isValidIfPresent(createRequest.getEmail()), (String)"Email '%s' is not valid", (Object[])new Object[]{createRequest.getEmail()});
        WsUtils.writeProtobuf((Message)this.doHandle(createRequest), request, response);
    }

    private Users.CreateWsResponse doHandle(CreateRequest request) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            UserDto existingUser;
            String login = request.getLogin();
            NewUser.Builder newUser = NewUser.builder().setLogin(login).setName(request.getName()).setEmail(request.getEmail()).setScmAccounts(request.getScmAccounts()).setPassword(request.getPassword());
            if (!request.isLocal()) {
                newUser.setExternalIdentity(new ExternalIdentity("sonarqube", login, login));
            }
            if ((existingUser = this.dbClient.userDao().selectByLogin(dbSession, login)) == null) {
                Users.CreateWsResponse createWsResponse = CreateAction.buildResponse(this.userUpdater.createAndCommit(dbSession, newUser.build(), u -> {}, new UserDto[0]));
                return createWsResponse;
            }
            Preconditions.checkArgument((!existingUser.isActive() ? 1 : 0) != 0, (String)"An active user with login '%s' already exists", (Object[])new Object[]{login});
            Users.CreateWsResponse createWsResponse = CreateAction.buildResponse(this.userUpdater.reactivateAndCommit(dbSession, existingUser, newUser.build(), u -> {}, new UserDto[0]));
            return createWsResponse;
        }
    }

    private static Users.CreateWsResponse buildResponse(UserDto userDto) {
        Users.CreateWsResponse.User.Builder userBuilder = Users.CreateWsResponse.User.newBuilder().setLogin(userDto.getLogin()).setName(userDto.getName()).setActive(userDto.isActive()).setLocal(userDto.isLocal()).addAllScmAccounts((Iterable)userDto.getScmAccountsAsList());
        Protobuf.setNullable((Object)Strings.emptyToNull((String)userDto.getEmail()), arg_0 -> ((Users.CreateWsResponse.User.Builder)userBuilder).setEmail(arg_0));
        return Users.CreateWsResponse.newBuilder().setUser(userBuilder).build();
    }

    private static CreateRequest toWsRequest(Request request) {
        return CreateRequest.builder().setLogin(request.mandatoryParam("login")).setPassword(request.param("password")).setName(request.param("name")).setEmail(request.param("email")).setScmAccounts(CreateAction.getScmAccounts(request)).setLocal(request.mandatoryParamAsBoolean("local")).build();
    }

    private static List<String> getScmAccounts(Request request) {
        if (request.hasParam("scmAccount")) {
            return request.multiParam("scmAccount");
        }
        List<String> oldScmAccounts = request.paramAsStrings("scmAccounts");
        return oldScmAccounts != null ? oldScmAccounts : Collections.emptyList();
    }

    static class Builder {
        private String login;
        private String password;
        private String name;
        private String email;
        private List<String> scmAccounts = Collections.emptyList();
        private boolean local = true;

        private Builder() {
        }

        public Builder setLogin(String login) {
            this.login = login;
            return this;
        }

        public Builder setPassword(@Nullable String password) {
            this.password = password;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setEmail(@Nullable String email) {
            this.email = email;
            return this;
        }

        public Builder setScmAccounts(List<String> scmAccounts) {
            this.scmAccounts = scmAccounts;
            return this;
        }

        public Builder setLocal(boolean local) {
            this.local = local;
            return this;
        }

        public CreateRequest build() {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)this.login) ? 1 : 0) != 0, (Object)"Login is mandatory and must not be empty");
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)this.name) ? 1 : 0) != 0, (Object)"Name is mandatory and must not be empty");
            Preconditions.checkArgument((!this.local || !Strings.isNullOrEmpty((String)this.password) ? 1 : 0) != 0, (Object)"Password is mandatory and must not be empty");
            Preconditions.checkArgument((this.local || Strings.isNullOrEmpty((String)this.password) ? 1 : 0) != 0, (Object)"Password should only be set on local user");
            return new CreateRequest(this);
        }
    }

    static class CreateRequest {
        private final String login;
        private final String password;
        private final String name;
        private final String email;
        private final List<String> scmAccounts;
        private final boolean local;

        private CreateRequest(Builder builder) {
            this.login = builder.login;
            this.password = builder.password;
            this.name = builder.name;
            this.email = builder.email;
            this.scmAccounts = builder.scmAccounts;
            this.local = builder.local;
        }

        public String getLogin() {
            return this.login;
        }

        @CheckForNull
        public String getPassword() {
            return this.password;
        }

        public String getName() {
            return this.name;
        }

        @CheckForNull
        public String getEmail() {
            return this.email;
        }

        public List<String> getScmAccounts() {
            return this.scmAccounts;
        }

        public boolean isLocal() {
            return this.local;
        }

        public static Builder builder() {
            return new Builder();
        }
    }
}

