/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.user;

import java.util.Collection;
import java.util.List;
import javax.annotation.CheckForNull;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.permission.OrganizationPermission;
import org.sonar.db.user.GroupDto;
import org.sonar.server.exceptions.UnauthorizedException;
import org.sonar.server.user.UserSession;

public class ThreadLocalUserSession
implements UserSession {
    private static final ThreadLocal<UserSession> DELEGATE = new ThreadLocal();

    public UserSession get() {
        UserSession session = DELEGATE.get();
        if (session != null) {
            return session;
        }
        throw new UnauthorizedException("User is not authenticated");
    }

    public void set(UserSession session) {
        DELEGATE.set(session);
    }

    public void unload() {
        DELEGATE.remove();
    }

    public boolean hasSession() {
        return DELEGATE.get() != null;
    }

    @Override
    @CheckForNull
    public String getLogin() {
        return this.get().getLogin();
    }

    @Override
    @CheckForNull
    public String getUuid() {
        return this.get().getUuid();
    }

    @Override
    @CheckForNull
    public String getName() {
        return this.get().getName();
    }

    @Override
    @CheckForNull
    public Integer getUserId() {
        return this.get().getUserId();
    }

    @Override
    public Collection<GroupDto> getGroups() {
        return this.get().getGroups();
    }

    @Override
    public boolean isLoggedIn() {
        return this.get().isLoggedIn();
    }

    @Override
    public UserSession checkIsRoot() {
        return this.get().checkIsRoot();
    }

    @Override
    public boolean isRoot() {
        return this.get().isRoot();
    }

    @Override
    public UserSession checkLoggedIn() {
        this.get().checkLoggedIn();
        return this;
    }

    @Override
    public boolean hasPermission(OrganizationPermission permission, String organizationUuid) {
        return this.get().hasPermission(permission, organizationUuid);
    }

    @Override
    public UserSession checkPermission(OrganizationPermission permission, String organizationUuid) {
        this.get().checkPermission(permission, organizationUuid);
        return this;
    }

    @Override
    public UserSession checkComponentPermission(String projectPermission, ComponentDto component) {
        this.get().checkComponentPermission(projectPermission, component);
        return this;
    }

    @Override
    public UserSession checkComponentUuidPermission(String permission, String componentUuid) {
        this.get().checkComponentUuidPermission(permission, componentUuid);
        return this;
    }

    @Override
    public boolean isSystemAdministrator() {
        return this.get().isSystemAdministrator();
    }

    @Override
    public UserSession checkIsSystemAdministrator() {
        this.get().checkIsSystemAdministrator();
        return this;
    }

    @Override
    public boolean hasComponentPermission(String permission, ComponentDto component) {
        return this.get().hasComponentPermission(permission, component);
    }

    @Override
    public boolean hasComponentUuidPermission(String permission, String componentUuid) {
        return this.get().hasComponentUuidPermission(permission, componentUuid);
    }

    @Override
    public UserSession checkPermission(OrganizationPermission permission, OrganizationDto organization) {
        this.get().checkPermission(permission, organization);
        return this;
    }

    @Override
    public boolean hasPermission(OrganizationPermission permission, OrganizationDto organization) {
        return this.get().hasPermission(permission, organization);
    }

    @Override
    public List<ComponentDto> keepAuthorizedComponents(String permission, Collection<ComponentDto> components) {
        return this.get().keepAuthorizedComponents(permission, components);
    }
}

