/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.source.index;

import com.google.common.base.Joiner;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.elasticsearch.action.update.UpdateRequest;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;

public class FileSourcesUpdaterHelper {
    private static final String SQL_ALL = "SELECT %s FROM file_sources WHERE data_type='%s' ";
    private static final String PROJECT_FILTER = " AND project_uuid=?";
    private static final String[] FIELDS = new String[]{"project_uuid", "file_uuid", "updated_at", "binary_data"};
    private static final String FIELDS_ONE_LINE = Joiner.on((String)",").join((Object[])FIELDS);

    private FileSourcesUpdaterHelper() {
    }

    public static PreparedStatement preparedStatementToSelectFileSources(DbClient dbClient, DbSession session, String dataType, @Nullable String projectUuid) throws SQLException {
        String sql = FileSourcesUpdaterHelper.createSQL(dataType, projectUuid);
        PreparedStatement stmt = dbClient.getMyBatis().newScrollingSingleRowSelectStatement(session, sql);
        if (projectUuid != null) {
            stmt.setString(1, projectUuid);
        }
        return stmt;
    }

    private static String createSQL(String dataType, @Nullable String projectUuid) {
        StringBuilder sql = new StringBuilder(String.format(SQL_ALL, FIELDS_ONE_LINE, dataType));
        if (projectUuid != null) {
            sql.append(PROJECT_FILTER);
        }
        return sql.toString();
    }

    public static class Row {
        private final String fileUuid;
        private final String projectUuid;
        private final long updatedAt;
        private final List<UpdateRequest> updateRequests = new ArrayList<UpdateRequest>();

        public Row(String projectUuid, String fileUuid, long updatedAt) {
            this.projectUuid = projectUuid;
            this.fileUuid = fileUuid;
            this.updatedAt = updatedAt;
        }

        public String getProjectUuid() {
            return this.projectUuid;
        }

        public String getFileUuid() {
            return this.fileUuid;
        }

        public long getUpdatedAt() {
            return this.updatedAt;
        }

        public List<UpdateRequest> getUpdateRequests() {
            return this.updateRequests;
        }
    }
}

