/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.rule.ws;

import com.google.common.base.Splitter;
import com.google.common.collect.Sets;
import com.google.common.io.Resources;
import com.google.protobuf.Message;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.rule.RuleStatus;
import org.sonar.api.rule.Severity;
import org.sonar.api.server.debt.DebtRemediationFunction;
import org.sonar.api.server.debt.internal.DefaultDebtRemediationFunction;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.KeyValueFormat;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.permission.OrganizationPermission;
import org.sonar.db.rule.RuleDefinitionDto;
import org.sonar.db.rule.RuleDto;
import org.sonar.server.exceptions.NotFoundException;
import org.sonar.server.rule.RuleUpdate;
import org.sonar.server.rule.RuleUpdater;
import org.sonar.server.rule.ws.RuleMapper;
import org.sonar.server.rule.ws.RuleWsSupport;
import org.sonar.server.rule.ws.RulesWsAction;
import org.sonar.server.rule.ws.SearchAction;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.Rules;

public class UpdateAction
implements RulesWsAction {
    public static final String PARAM_KEY = "key";
    public static final String PARAM_TAGS = "tags";
    public static final String PARAM_MARKDOWN_NOTE = "markdown_note";
    public static final String PARAM_REMEDIATION_FN_TYPE = "remediation_fn_type";
    public static final String DEPRECATED_PARAM_REMEDIATION_FN_TYPE = "debt_remediation_fn_type";
    public static final String PARAM_REMEDIATION_FN_BASE_EFFORT = "remediation_fn_base_effort";
    public static final String DEPRECATED_PARAM_REMEDIATION_FN_OFFSET = "debt_remediation_fn_offset";
    public static final String PARAM_REMEDIATION_FN_GAP_MULTIPLIER = "remediation_fy_gap_multiplier";
    public static final String DEPRECATED_PARAM_REMEDIATION_FN_COEFF = "debt_remediation_fy_coeff";
    public static final String PARAM_NAME = "name";
    public static final String PARAM_DESCRIPTION = "markdown_description";
    public static final String PARAM_SEVERITY = "severity";
    public static final String PARAM_STATUS = "status";
    public static final String PARAM_ORGANIZATION = "organization";
    public static final String PARAMS = "params";
    private final DbClient dbClient;
    private final RuleUpdater ruleUpdater;
    private final RuleMapper mapper;
    private final UserSession userSession;
    private final RuleWsSupport ruleWsSupport;

    public UpdateAction(DbClient dbClient, RuleUpdater ruleUpdater, RuleMapper mapper, UserSession userSession, RuleWsSupport ruleWsSupport) {
        this.dbClient = dbClient;
        this.ruleUpdater = ruleUpdater;
        this.mapper = mapper;
        this.userSession = userSession;
        this.ruleWsSupport = ruleWsSupport;
    }

    public void define(WebService.NewController controller) {
        WebService.NewAction action = controller.createAction("update").setPost(true).setResponseExample(Resources.getResource(this.getClass(), (String)"example-update.json")).setDescription("Update an existing rule.<br>Requires the 'Administer Quality Profiles' permission").setSince("4.4").setHandler((RequestHandler)this);
        action.createParam(PARAM_KEY).setRequired(true).setMaximumLength(Integer.valueOf(200)).setDescription("Key of the rule to update").setExampleValue((Object)"javascript:NullCheck");
        action.createParam(PARAM_TAGS).setDescription("Optional comma-separated list of tags to set. Use blank value to remove current tags. Tags are not changed if the parameter is not set.").setExampleValue((Object)"java8,security");
        action.createParam(PARAM_MARKDOWN_NOTE).setDescription("Optional note in markdown format. Use empty value to remove current note. Note is not changedif the parameter is not set.").setExampleValue((Object)"my *note*");
        action.createParam("debt_sub_characteristic").setDescription("Debt characteristics are no more supported. This parameter is ignored.").setDeprecatedSince("5.5");
        action.createParam(PARAM_REMEDIATION_FN_TYPE).setDescription("Type of the remediation function of the rule").setPossibleValues((Object[])DebtRemediationFunction.Type.values()).setSince("5.5");
        action.createParam(DEPRECATED_PARAM_REMEDIATION_FN_TYPE).setDeprecatedSince("5.5").setPossibleValues((Object[])DebtRemediationFunction.Type.values());
        action.createParam(PARAM_REMEDIATION_FN_BASE_EFFORT).setDescription("Base effort of the remediation function of the rule").setExampleValue((Object)"1d").setSince("5.5");
        action.createParam(DEPRECATED_PARAM_REMEDIATION_FN_OFFSET).setDeprecatedSince("5.5");
        action.createParam(PARAM_REMEDIATION_FN_GAP_MULTIPLIER).setDescription("Gap multiplier of the remediation function of the rule").setExampleValue((Object)"3min").setSince("5.5");
        action.createParam(DEPRECATED_PARAM_REMEDIATION_FN_COEFF).setDeprecatedSince("5.5");
        action.createParam(PARAM_NAME).setMaximumLength(Integer.valueOf(200)).setDescription("Rule name (mandatory for custom rule)").setExampleValue((Object)"My custom rule");
        action.createParam(PARAM_DESCRIPTION).setDescription("Rule description (mandatory for custom rule and manual rule)").setExampleValue((Object)"Description of my custom rule");
        action.createParam(PARAM_SEVERITY).setDescription("Rule severity (Only when updating a custom rule)").setPossibleValues((Collection)Severity.ALL);
        action.createParam(PARAM_STATUS).setPossibleValues((Object[])RuleStatus.values()).setDescription("Rule status (Only when updating a custom rule)");
        action.createParam(PARAM_ORGANIZATION).setRequired(false).setInternal(true).setDescription("Organization key").setExampleValue((Object)"my-org").setSince("6.4");
        action.createParam(PARAMS).setDescription("Parameters as semi-colon list of <key>=<value>, for example 'params=key1=v1;key2=v2' (Only when updating a custom rule)");
    }

    public void handle(Request request, Response response) throws Exception {
        this.userSession.checkLoggedIn();
        try (DbSession dbSession = this.dbClient.openSession(false);){
            OrganizationDto organization = this.ruleWsSupport.getOrganizationByKey(dbSession, request.param(PARAM_ORGANIZATION));
            this.userSession.checkPermission(OrganizationPermission.ADMINISTER_QUALITY_PROFILES, organization);
            RuleUpdate update = this.readRequest(dbSession, request, organization);
            this.ruleUpdater.update(dbSession, update, organization, this.userSession);
            Rules.UpdateResponse updateResponse = this.buildResponse(dbSession, update.getRuleKey(), organization);
            WsUtils.writeProtobuf((Message)updateResponse, request, response);
        }
    }

    private RuleUpdate readRequest(DbSession dbSession, Request request, OrganizationDto organization) {
        String params;
        String status;
        String severity;
        String description;
        RuleKey key = RuleKey.parse((String)request.mandatoryParam(PARAM_KEY));
        RuleUpdate update = this.createRuleUpdate(dbSession, key, organization);
        UpdateAction.readTags(request, update);
        UpdateAction.readMarkdownNote(request, update);
        UpdateAction.readDebt(request, update);
        String name = request.param(PARAM_NAME);
        if (name != null) {
            update.setName(name);
        }
        if ((description = request.param(PARAM_DESCRIPTION)) != null) {
            update.setMarkdownDescription(description);
        }
        if ((severity = request.param(PARAM_SEVERITY)) != null) {
            update.setSeverity(severity);
        }
        if ((status = request.param(PARAM_STATUS)) != null) {
            update.setStatus(RuleStatus.valueOf((String)status));
        }
        if ((params = request.param(PARAMS)) != null) {
            update.setParameters(KeyValueFormat.parse((String)params));
        }
        return update;
    }

    private RuleUpdate createRuleUpdate(DbSession dbSession, RuleKey key, OrganizationDto organization) {
        RuleDto rule = (RuleDto)this.dbClient.ruleDao().selectByKey(dbSession, organization, key).orElseThrow(() -> new NotFoundException(String.format("This rule does not exist: %s", key)));
        RuleUpdate ruleUpdate = Optional.ofNullable(rule.getTemplateId()).map(x -> RuleUpdate.createForCustomRule(key)).orElseGet(() -> RuleUpdate.createForPluginRule(key));
        ruleUpdate.setOrganization(organization);
        return ruleUpdate;
    }

    private static void readTags(Request request, RuleUpdate update) {
        String value = request.param(PARAM_TAGS);
        if (value != null) {
            if (StringUtils.isBlank((String)value)) {
                update.setTags(null);
            } else {
                update.setTags(Sets.newHashSet((Iterable)Splitter.on((char)',').omitEmptyStrings().trimResults().split((CharSequence)value)));
            }
        }
    }

    private static void readMarkdownNote(Request request, RuleUpdate update) {
        String value = request.param(PARAM_MARKDOWN_NOTE);
        if (value != null) {
            update.setMarkdownNote(value);
        }
    }

    private static void readDebt(Request request, RuleUpdate update) {
        String value = StringUtils.defaultIfEmpty((String)request.param(PARAM_REMEDIATION_FN_TYPE), (String)request.param(DEPRECATED_PARAM_REMEDIATION_FN_TYPE));
        if (value != null) {
            if (StringUtils.isBlank((String)value)) {
                update.setDebtRemediationFunction(null);
            } else {
                DefaultDebtRemediationFunction fn = new DefaultDebtRemediationFunction(DebtRemediationFunction.Type.valueOf((String)value), StringUtils.defaultIfEmpty((String)request.param(PARAM_REMEDIATION_FN_GAP_MULTIPLIER), (String)request.param(DEPRECATED_PARAM_REMEDIATION_FN_COEFF)), StringUtils.defaultIfEmpty((String)request.param(PARAM_REMEDIATION_FN_BASE_EFFORT), (String)request.param(DEPRECATED_PARAM_REMEDIATION_FN_OFFSET)));
                update.setDebtRemediationFunction((DebtRemediationFunction)fn);
            }
        }
    }

    private Rules.UpdateResponse buildResponse(DbSession dbSession, RuleKey key, OrganizationDto organization) {
        RuleDto rule = (RuleDto)this.dbClient.ruleDao().selectByKey(dbSession, organization, key).orElseThrow(() -> new NotFoundException(String.format("Rule not found: %s", key)));
        ArrayList<RuleDefinitionDto> templateRules = new ArrayList<RuleDefinitionDto>(1);
        if (rule.getDefinition().isCustomRule()) {
            this.dbClient.ruleDao().selectDefinitionById((long)rule.getTemplateId().intValue(), dbSession).ifPresent(templateRules::add);
        }
        List ruleParameters = this.dbClient.ruleDao().selectRuleParamsByRuleIds(dbSession, Collections.singletonList(rule.getId()));
        Rules.UpdateResponse.Builder responseBuilder = Rules.UpdateResponse.newBuilder();
        SearchAction.SearchResult searchResult = new SearchAction.SearchResult().setRules(Collections.singletonList(rule)).setTemplateRules(templateRules).setRuleParameters(ruleParameters).setTotal(1L);
        responseBuilder.setRule(this.mapper.toWsRule(rule.getDefinition(), searchResult, Collections.emptySet(), rule.getMetadata(), this.ruleWsSupport.getUsersByUuid(dbSession, Collections.singletonList(rule))));
        return responseBuilder.build();
    }
}

