/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualityprofile.ws;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.sonar.api.server.ws.Change;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.Paging;
import org.sonar.api.utils.text.JsonWriter;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.qualityprofile.ProjectQprofileAssociationDto;
import org.sonar.db.qualityprofile.QProfileDto;
import org.sonar.server.exceptions.NotFoundException;
import org.sonar.server.qualityprofile.ws.QProfileWsAction;
import org.sonar.server.qualityprofile.ws.QProfileWsSupport;
import org.sonar.server.user.UserSession;

public class ProjectsAction
implements QProfileWsAction {
    private static final int MAX_PAGE_SIZE = 500;
    private final DbClient dbClient;
    private final UserSession userSession;
    private final QProfileWsSupport wsSupport;

    public ProjectsAction(DbClient dbClient, UserSession userSession, QProfileWsSupport wsSupport) {
        this.dbClient = dbClient;
        this.userSession = userSession;
        this.wsSupport = wsSupport;
    }

    public void define(WebService.NewController controller) {
        WebService.NewAction action = controller.createAction("projects").setSince("5.2").setHandler((RequestHandler)this).setDescription("List projects with their association status regarding a quality profile").setResponseExample(this.getClass().getResource("projects-example.json"));
        action.setChangelog(new Change[]{new Change("7.2", "'more' response field is deprecated"), new Change("6.5", "'id' response field is deprecated"), new Change("6.0", "'uuid' response field is deprecated and replaced by 'id'"), new Change("6.0", "'key' response field has been added to return the project key")});
        action.createParam("key").setDescription("Quality profile key").setRequired(true).setExampleValue((Object)"AU-Tpxb--iU5OvuD2FLy");
        action.addSelectionModeParam();
        action.createSearchQuery("sonar", new String[]{"projects"}).setDeprecatedKey("query", "6.5");
        action.createPageParam().setDeprecatedKey("page", "6.5");
        action.createPageSize(100, 500);
    }

    public void handle(Request request, Response response) throws Exception {
        String profileKey = request.mandatoryParam("key");
        try (DbSession session = this.dbClient.openSession(false);){
            this.checkProfileExists(profileKey, session);
            String selected = request.param("selected");
            String query = request.param("q");
            int page = request.mandatoryParamAsInt("p");
            int pageSize = request.mandatoryParamAsInt("ps");
            List projects = (List)this.loadAllProjects(profileKey, session, selected, query).stream().sorted(Comparator.comparing(ProjectQprofileAssociationDto::getProjectName).thenComparing(ProjectQprofileAssociationDto::getProjectUuid)).collect(MoreCollectors.toList());
            Collection projectUuids = (Collection)projects.stream().map(ProjectQprofileAssociationDto::getProjectUuid).collect(MoreCollectors.toSet());
            Set authorizedProjectUuids = this.dbClient.authorizationDao().keepAuthorizedProjectUuids(session, projectUuids, this.userSession.getUserId(), "user");
            Paging paging = Paging.forPageIndex((int)page).withPageSize(pageSize).andTotal(authorizedProjectUuids.size());
            List authorizedProjects = (List)projects.stream().filter(input -> authorizedProjectUuids.contains(input.getProjectUuid())).skip(paging.offset()).limit(paging.pageSize()).collect(MoreCollectors.toList());
            ProjectsAction.writeProjects(response, authorizedProjects, paging);
        }
    }

    private void checkProfileExists(String profileKey, DbSession session) {
        if (this.dbClient.qualityProfileDao().selectByUuid(session, profileKey) == null) {
            throw new NotFoundException(String.format("Could not find a quality profile with key '%s'", profileKey));
        }
    }

    private List<ProjectQprofileAssociationDto> loadAllProjects(String profileKey, DbSession session, String selected, String query) {
        QProfileDto profile = this.dbClient.qualityProfileDao().selectByUuid(session, profileKey);
        OrganizationDto organization = this.wsSupport.getOrganization(session, profile);
        WebService.SelectionMode selectionMode = WebService.SelectionMode.fromParam((String)selected);
        List projects = WebService.SelectionMode.SELECTED == selectionMode ? this.dbClient.qualityProfileDao().selectSelectedProjects(session, organization, profile, query) : (WebService.SelectionMode.DESELECTED == selectionMode ? this.dbClient.qualityProfileDao().selectDeselectedProjects(session, organization, profile, query) : this.dbClient.qualityProfileDao().selectProjectAssociations(session, organization, profile, query));
        return projects;
    }

    private static void writeProjects(Response response, List<ProjectQprofileAssociationDto> projects, Paging paging) {
        JsonWriter json = response.newJsonWriter();
        json.beginObject();
        json.name("results").beginArray();
        for (ProjectQprofileAssociationDto project : projects) {
            json.beginObject().prop("uuid", project.getProjectUuid()).prop("id", project.getProjectUuid()).prop("key", project.getProjectKey()).prop("name", project.getProjectName()).prop("selected", project.isAssociated()).endObject();
        }
        json.endArray();
        json.name("paging").beginObject().prop("pageIndex", (long)paging.pageIndex()).prop("pageSize", (long)paging.pageSize()).prop("total", (long)paging.total()).endObject();
        json.prop("more", paging.hasNextPage());
        json.endObject();
        json.close();
    }
}

