/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualityprofile.ws;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.api.profiles.ProfileExporter;
import org.sonar.api.resources.Languages;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.qualityprofile.QProfileDto;
import org.sonar.server.qualityprofile.QProfileBackuper;
import org.sonar.server.qualityprofile.QProfileExporters;
import org.sonar.server.qualityprofile.ws.QProfileWsAction;
import org.sonar.server.qualityprofile.ws.QProfileWsSupport;
import org.sonar.server.util.LanguageParamUtils;
import org.sonar.server.ws.WsUtils;

public class ExportAction
implements QProfileWsAction {
    private static final String PARAM_EXPORTER_KEY = "exporterKey";
    private final DbClient dbClient;
    private final QProfileBackuper backuper;
    private final QProfileExporters exporters;
    private final Languages languages;
    private final QProfileWsSupport wsSupport;

    public ExportAction(DbClient dbClient, QProfileBackuper backuper, QProfileExporters exporters, Languages languages, QProfileWsSupport wsSupport) {
        this.dbClient = dbClient;
        this.backuper = backuper;
        this.exporters = exporters;
        this.languages = languages;
        this.wsSupport = wsSupport;
    }

    public void define(WebService.NewController controller) {
        WebService.NewAction action = controller.createAction("export").setSince("5.2").setDescription("Export a quality profile.").setResponseExample(this.getClass().getResource("export-example.xml")).setHandler((RequestHandler)this);
        action.createParam("key").setDescription("Quality profile key").setSince("6.5").setDeprecatedSince("6.6").setExampleValue((Object)"AU-Tpxb--iU5OvuD2FLy");
        action.createParam("qualityProfile").setDescription("Quality profile name to export. If left empty, the default profile for the language is exported.", new Object[]{"qualityProfile"}).setDeprecatedKey("name", "6.6").setExampleValue((Object)"My Sonar way");
        action.createParam("language").setDescription("Quality profile language").setExampleValue((Object)LanguageParamUtils.getExampleValue(this.languages)).setPossibleValues(LanguageParamUtils.getLanguageKeys(this.languages));
        QProfileWsSupport.createOrganizationParam(action).setSince("6.4");
        Set exporterKeys = (Set)Arrays.stream(this.languages.all()).map(language -> this.exporters.exportersForLanguage(language.getKey())).flatMap(Collection::stream).map(ProfileExporter::getKey).collect(MoreCollectors.toSet());
        if (!exporterKeys.isEmpty()) {
            action.createParam(PARAM_EXPORTER_KEY).setDescription("Output format. If left empty, the same format as api/qualityprofiles/backup is used. Possible values are described by api/qualityprofiles/exporters.").setPossibleValues((Collection)exporterKeys).setDeprecatedKey("format", "6.3");
        }
    }

    public void handle(Request request, Response response) throws Exception {
        String key = request.param("key");
        String name = request.param("qualityProfile");
        String language = request.param("language");
        WsUtils.checkRequest(key != null ^ language != null, "Either '%s' or '%s' must be provided.", "key", "language");
        try (DbSession dbSession = this.dbClient.openSession(false);){
            OrganizationDto organization = this.wsSupport.getOrganizationByKey(dbSession, request.param("organization"));
            QProfileDto profile = this.loadProfile(dbSession, organization, key, language, name);
            String exporterKey = this.exporters.exportersForLanguage(profile.getLanguage()).isEmpty() ? null : request.param(PARAM_EXPORTER_KEY);
            this.writeResponse(dbSession, profile, exporterKey, response);
        }
    }

    private void writeResponse(DbSession dbSession, QProfileDto profile, @Nullable String exporterKey, Response response) throws IOException {
        Response.Stream stream = response.stream();
        try (OutputStream output = response.stream().output();
             OutputStreamWriter writer = new OutputStreamWriter(output, StandardCharsets.UTF_8);){
            if (exporterKey == null) {
                stream.setMediaType("application/xml");
                this.backuper.backup(dbSession, profile, writer);
            } else {
                stream.setMediaType(this.exporters.mimeType(exporterKey));
                this.exporters.export(dbSession, profile, exporterKey, writer);
            }
        }
    }

    private QProfileDto loadProfile(DbSession dbSession, OrganizationDto organization, @Nullable String key, @Nullable String language, @Nullable String name) {
        if (key != null) {
            QProfileDto profile = this.dbClient.qualityProfileDao().selectByUuid(dbSession, key);
            return WsUtils.checkFound(profile, "Could not find profile with key '%s'", key);
        }
        WsUtils.checkRequest(language != null, "Parameter '%s' must be provided", "language");
        QProfileDto profile = name == null ? this.dbClient.qualityProfileDao().selectDefaultProfile(dbSession, organization, language) : this.dbClient.qualityProfileDao().selectByNameAndLanguage(dbSession, organization, name, language);
        return WsUtils.checkFound(profile, "Could not find profile with name '%s' for language '%s'", name, language);
    }
}

