/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualityprofile.ws;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.CheckForNull;
import org.sonar.api.resources.Languages;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.DateUtils;
import org.sonar.api.utils.text.JsonWriter;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.qualityprofile.QProfileChangeDto;
import org.sonar.db.qualityprofile.QProfileChangeQuery;
import org.sonar.db.qualityprofile.QProfileDto;
import org.sonar.db.rule.RuleDefinitionDto;
import org.sonar.db.user.UserDto;
import org.sonar.server.qualityprofile.ws.QProfileReference;
import org.sonar.server.qualityprofile.ws.QProfileWsAction;
import org.sonar.server.qualityprofile.ws.QProfileWsSupport;

public class ChangelogAction
implements QProfileWsAction {
    private final QProfileWsSupport wsSupport;
    private final Languages languages;
    private DbClient dbClient;

    public ChangelogAction(QProfileWsSupport wsSupport, Languages languages, DbClient dbClient) {
        this.wsSupport = wsSupport;
        this.languages = languages;
        this.dbClient = dbClient;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction wsAction = context.createAction("changelog").setSince("5.2").setDescription("Get the history of changes on a quality profile: rule activation/deactivation, change in parameters/severity. Events are ordered by date in descending order (most recent first).").setHandler((RequestHandler)this).setResponseExample(this.getClass().getResource("changelog-example.json"));
        QProfileWsSupport.createOrganizationParam(wsAction).setSince("6.4");
        QProfileReference.defineParams(wsAction, this.languages);
        wsAction.addPagingParams(50, 500);
        wsAction.createParam("since").setDescription("Start date for the changelog. <br>Either a date (server timezone) or datetime can be provided.").setExampleValue((Object)"2017-10-19 or 2017-10-19T13:00:00+0200");
        wsAction.createParam("to").setDescription("End date for the changelog. <br>Either a date (server timezone) or datetime can be provided.").setExampleValue((Object)"2017-10-19 or 2017-10-19T13:00:00+0200");
    }

    public void handle(Request request, Response response) throws Exception {
        QProfileReference reference = QProfileReference.from(request);
        try (DbSession dbSession = this.dbClient.openSession(false);){
            Date to;
            QProfileDto profile = this.wsSupport.getProfile(dbSession, reference);
            QProfileChangeQuery query = new QProfileChangeQuery(profile.getKee());
            Date since = DateUtils.parseStartingDateOrDateTime((String)request.param("since"));
            if (since != null) {
                query.setFromIncluded(Long.valueOf(since.getTime()));
            }
            if ((to = DateUtils.parseEndingDateOrDateTime((String)request.param("to"))) != null) {
                query.setToExcluded(Long.valueOf(to.getTime()));
            }
            int page = request.mandatoryParamAsInt("p");
            int pageSize = request.mandatoryParamAsInt("ps");
            query.setPage(page, pageSize);
            int total = this.dbClient.qProfileChangeDao().countByQuery(dbSession, query);
            List<Change> changelogs = this.load(dbSession, query);
            Map<String, UserDto> usersByUuid = this.getUsersByUserUuid(dbSession, changelogs);
            Map<Integer, RuleDefinitionDto> rulesByRuleIds = this.getRulesByRuleIds(dbSession, changelogs);
            ChangelogAction.writeResponse(response.newJsonWriter(), total, page, pageSize, changelogs, usersByUuid, rulesByRuleIds);
        }
    }

    private Map<String, UserDto> getUsersByUserUuid(DbSession dbSession, List<Change> changes) {
        Set userUuids = (Set)changes.stream().map(Change::getUserUuid).filter(Objects::nonNull).collect(MoreCollectors.toSet());
        return (Map)this.dbClient.userDao().selectByUuids(dbSession, (Collection)userUuids).stream().collect(MoreCollectors.uniqueIndex(UserDto::getUuid));
    }

    private Map<Integer, RuleDefinitionDto> getRulesByRuleIds(DbSession dbSession, List<Change> changes) {
        Set ruleIds = (Set)changes.stream().map(c -> ((Change)c).ruleId).filter(Objects::nonNull).collect(MoreCollectors.toSet());
        return (Map)this.dbClient.ruleDao().selectDefinitionByIds(dbSession, (Collection)Lists.newArrayList((Iterable)ruleIds)).stream().collect(MoreCollectors.uniqueIndex(RuleDefinitionDto::getId));
    }

    private static void writeResponse(JsonWriter json, int total, int page, int pageSize, List<Change> changelogs, Map<String, UserDto> usersByUuid, Map<Integer, RuleDefinitionDto> rulesByRuleIds) {
        json.beginObject();
        json.prop("total", (long)total);
        json.prop("p", (long)page);
        json.prop("ps", (long)pageSize);
        json.name("events").beginArray();
        changelogs.forEach(change -> {
            RuleDefinitionDto rule;
            JsonWriter changeWriter = json.beginObject();
            changeWriter.prop("date", DateUtils.formatDateTime((long)change.getCreatedAt())).prop("action", change.getType());
            UserDto user = (UserDto)usersByUuid.get(change.getUserUuid());
            if (user != null) {
                changeWriter.prop("authorLogin", user.getLogin()).prop("authorName", user.getName());
            }
            if ((rule = (RuleDefinitionDto)rulesByRuleIds.get(change.getRuleId())) != null) {
                changeWriter.prop("ruleKey", rule.getKey().toString()).prop("ruleName", rule.getName());
            }
            ChangelogAction.writeParameters(json, change);
            json.endObject();
        });
        json.endArray();
        json.endObject().close();
    }

    private static void writeParameters(JsonWriter json, Change change) {
        json.name("params").beginObject().prop("severity", change.getSeverity());
        for (Map.Entry<String, String> param : change.getParams().entrySet()) {
            json.prop(param.getKey(), param.getValue());
        }
        json.endObject();
    }

    public List<Change> load(DbSession dbSession, QProfileChangeQuery query) {
        List changeDtos = this.dbClient.qProfileChangeDao().selectByQuery(dbSession, query);
        return (List)changeDtos.stream().map(x$0 -> Change.from(x$0)).collect(MoreCollectors.toList((int)changeDtos.size()));
    }

    static class Change {
        private String key;
        private String type;
        private long at;
        private String severity;
        private String userUuid;
        private String inheritance;
        private Integer ruleId;
        private final Map<String, String> params = new HashMap<String, String>();

        private Change() {
        }

        public String getKey() {
            return this.key;
        }

        @CheckForNull
        public String getSeverity() {
            return this.severity;
        }

        @CheckForNull
        public String getUserUuid() {
            return this.userUuid;
        }

        public String getType() {
            return this.type;
        }

        @CheckForNull
        public String getInheritance() {
            return this.inheritance;
        }

        @CheckForNull
        public Integer getRuleId() {
            return this.ruleId;
        }

        public long getCreatedAt() {
            return this.at;
        }

        public Map<String, String> getParams() {
            return this.params;
        }

        private static Change from(QProfileChangeDto dto) {
            Map data = dto.getDataAsMap();
            Change change = new Change();
            change.key = dto.getUuid();
            change.userUuid = dto.getUserUuid();
            change.type = dto.getChangeType();
            change.at = dto.getCreatedAt();
            change.severity = (String)data.get("severity");
            String ruleId = (String)data.get("ruleId");
            if (ruleId != null) {
                change.ruleId = Integer.parseInt(ruleId);
            }
            change.inheritance = (String)data.get("inheritance");
            data.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith("param_")).forEach(entry -> change.params.put(((String)entry.getKey()).replace("param_", ""), (String)entry.getValue()));
            return change;
        }
    }
}

