/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualityprofile.index;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.es.EsQueueDto;
import org.sonar.db.qualityprofile.IndexedActiveRuleDto;
import org.sonar.db.qualityprofile.QProfileDto;
import org.sonar.db.qualityprofile.RulesProfileDto;
import org.sonar.db.rule.SeverityUtil;
import org.sonar.server.es.BulkIndexer;
import org.sonar.server.es.EsClient;
import org.sonar.server.es.IndexType;
import org.sonar.server.es.IndexingListener;
import org.sonar.server.es.IndexingResult;
import org.sonar.server.es.OneToOneResilientIndexingListener;
import org.sonar.server.es.ResilientIndexer;
import org.sonar.server.qualityprofile.ActiveRuleChange;
import org.sonar.server.qualityprofile.ActiveRuleInheritance;
import org.sonar.server.qualityprofile.index.ActiveRuleDoc;
import org.sonar.server.rule.index.RuleIndexDefinition;

public class ActiveRuleIndexer
implements ResilientIndexer {
    private static final Logger LOGGER = Loggers.get(ActiveRuleIndexer.class);
    private static final String ID_TYPE_ACTIVE_RULE_ID = "activeRuleId";
    private static final String ID_TYPE_RULE_PROFILE_UUID = "ruleProfileUuid";
    private final DbClient dbClient;
    private final EsClient esClient;

    public ActiveRuleIndexer(DbClient dbClient, EsClient esClient) {
        this.dbClient = dbClient;
        this.esClient = esClient;
    }

    @Override
    public void indexOnStartup(Set<IndexType> uninitializedIndexTypes) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            BulkIndexer bulkIndexer = this.createBulkIndexer(BulkIndexer.Size.LARGE, IndexingListener.FAIL_ON_ERROR);
            bulkIndexer.start();
            this.dbClient.activeRuleDao().scrollAllForIndexing(dbSession, ar -> bulkIndexer.add(ActiveRuleIndexer.newIndexRequest(ar)));
            bulkIndexer.stop();
        }
    }

    @Override
    public Set<IndexType> getIndexTypes() {
        return ImmutableSet.of((Object)RuleIndexDefinition.INDEX_TYPE_ACTIVE_RULE);
    }

    public void commitAndIndex(DbSession dbSession, Collection<ActiveRuleChange> changes) {
        List items = (List)changes.stream().map(ActiveRuleChange::getActiveRule).map(ar -> ActiveRuleIndexer.newQueueDto(String.valueOf(ar.getId()), ID_TYPE_ACTIVE_RULE_ID, String.valueOf(ar.getRuleId()))).collect(MoreCollectors.toArrayList());
        this.dbClient.esQueueDao().insert(dbSession, (Collection)items);
        dbSession.commit();
        this.postCommit(dbSession, items);
    }

    public void commitDeletionOfProfiles(DbSession dbSession, Collection<QProfileDto> profiles) {
        List items = (List)profiles.stream().map(QProfileDto::getRulesProfileUuid).distinct().map(ruleProfileUuid -> ActiveRuleIndexer.newQueueDto(ruleProfileUuid, ID_TYPE_RULE_PROFILE_UUID, null)).collect(MoreCollectors.toArrayList());
        this.dbClient.esQueueDao().insert(dbSession, (Collection)items);
        dbSession.commit();
        this.postCommit(dbSession, items);
    }

    private void postCommit(DbSession dbSession, Collection<EsQueueDto> items) {
        this.index(dbSession, items);
    }

    @Override
    public IndexingResult index(DbSession dbSession, Collection<EsQueueDto> items) {
        IndexingResult result = new IndexingResult();
        if (items.isEmpty()) {
            return result;
        }
        HashMap<Long, EsQueueDto> activeRuleItems = new HashMap<Long, EsQueueDto>();
        HashMap<String, EsQueueDto> ruleProfileItems = new HashMap<String, EsQueueDto>();
        items.forEach(i -> {
            if (ID_TYPE_RULE_PROFILE_UUID.equals(i.getDocIdType())) {
                ruleProfileItems.put(i.getDocId(), (EsQueueDto)i);
            } else if (ID_TYPE_ACTIVE_RULE_ID.equals(i.getDocIdType())) {
                activeRuleItems.put(Long.parseLong(i.getDocId()), (EsQueueDto)i);
            } else {
                LOGGER.error("Unsupported es_queue.doc_id_type. Removing row from queue: " + i);
                this.deleteQueueDto(dbSession, (EsQueueDto)i);
            }
        });
        if (!activeRuleItems.isEmpty()) {
            result.add(this.doIndexActiveRules(dbSession, activeRuleItems));
        }
        if (!ruleProfileItems.isEmpty()) {
            result.add(this.doIndexRuleProfiles(dbSession, ruleProfileItems));
        }
        return result;
    }

    private IndexingResult doIndexActiveRules(DbSession dbSession, Map<Long, EsQueueDto> activeRuleItems) {
        OneToOneResilientIndexingListener listener = new OneToOneResilientIndexingListener(this.dbClient, dbSession, activeRuleItems.values());
        BulkIndexer bulkIndexer = this.createBulkIndexer(BulkIndexer.Size.REGULAR, listener);
        bulkIndexer.start();
        HashMap<Long, EsQueueDto> remaining = new HashMap<Long, EsQueueDto>(activeRuleItems);
        this.dbClient.activeRuleDao().scrollByIdsForIndexing(dbSession, activeRuleItems.keySet(), i -> {
            remaining.remove(i.getId());
            bulkIndexer.add(ActiveRuleIndexer.newIndexRequest(i));
        });
        remaining.values().forEach(item -> bulkIndexer.addDeletion(RuleIndexDefinition.INDEX_TYPE_ACTIVE_RULE, item.getDocId(), item.getDocRouting()));
        return bulkIndexer.stop();
    }

    private IndexingResult doIndexRuleProfiles(DbSession dbSession, Map<String, EsQueueDto> ruleProfileItems) {
        IndexingResult result = new IndexingResult();
        for (Map.Entry<String, EsQueueDto> entry : ruleProfileItems.entrySet()) {
            IndexingResult profileResult;
            String ruleProfileUUid = entry.getKey();
            EsQueueDto item = entry.getValue();
            RulesProfileDto profile = this.dbClient.qualityProfileDao().selectRuleProfile(dbSession, ruleProfileUUid);
            if (profile == null) {
                SearchRequestBuilder search = this.esClient.prepareSearch(RuleIndexDefinition.INDEX_TYPE_ACTIVE_RULE).setQuery((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)"ruleProfile", (String)ruleProfileUUid)));
                profileResult = BulkIndexer.delete(this.esClient, RuleIndexDefinition.INDEX_TYPE_ACTIVE_RULE, search);
            } else {
                BulkIndexer bulkIndexer = this.createBulkIndexer(BulkIndexer.Size.REGULAR, IndexingListener.FAIL_ON_ERROR);
                bulkIndexer.start();
                this.dbClient.activeRuleDao().scrollByRuleProfileForIndexing(dbSession, ruleProfileUUid, i -> bulkIndexer.add(ActiveRuleIndexer.newIndexRequest(i)));
                profileResult = bulkIndexer.stop();
            }
            if (profileResult.isSuccess()) {
                this.deleteQueueDto(dbSession, item);
            }
            result.add(profileResult);
        }
        return result;
    }

    private void deleteQueueDto(DbSession dbSession, EsQueueDto item) {
        this.dbClient.esQueueDao().delete(dbSession, item);
        dbSession.commit();
    }

    private BulkIndexer createBulkIndexer(BulkIndexer.Size size, IndexingListener listener) {
        return new BulkIndexer(this.esClient, RuleIndexDefinition.INDEX_TYPE_ACTIVE_RULE, size, listener);
    }

    private static IndexRequest newIndexRequest(IndexedActiveRuleDto dto) {
        ActiveRuleDoc doc = new ActiveRuleDoc(dto.getId()).setRuleId(dto.getRuleId()).setRuleProfileUuid(dto.getRuleProfileUuid()).setSeverity(SeverityUtil.getSeverityFromOrdinal((int)dto.getSeverity()));
        String inheritance = dto.getInheritance();
        doc.setInheritance(inheritance == null ? ActiveRuleInheritance.NONE.name() : inheritance);
        return new IndexRequest(RuleIndexDefinition.INDEX_TYPE_ACTIVE_RULE.getIndex(), RuleIndexDefinition.INDEX_TYPE_ACTIVE_RULE.getType()).id(doc.getId()).parent(doc.getParent()).routing(doc.getRouting()).source(doc.getFields());
    }

    private static EsQueueDto newQueueDto(String docId, String docIdType, @Nullable String routing) {
        return EsQueueDto.create((String)RuleIndexDefinition.INDEX_TYPE_ACTIVE_RULE.format(), (String)docId, (String)docIdType, (String)routing);
    }
}

