/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualityprofile;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.api.utils.System2;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.qualityprofile.ActiveRuleDto;
import org.sonar.db.qualityprofile.OrgActiveRuleDto;
import org.sonar.db.qualityprofile.QProfileDto;
import org.sonar.server.exceptions.BadRequestException;
import org.sonar.server.qualityprofile.ActiveRuleChange;
import org.sonar.server.qualityprofile.QProfileTree;
import org.sonar.server.qualityprofile.RuleActivation;
import org.sonar.server.qualityprofile.RuleActivationContext;
import org.sonar.server.qualityprofile.RuleActivator;
import org.sonar.server.qualityprofile.index.ActiveRuleIndexer;
import org.sonar.server.ws.WsUtils;

public class QProfileTreeImpl
implements QProfileTree {
    private final DbClient db;
    private final RuleActivator ruleActivator;
    private final System2 system2;
    private final ActiveRuleIndexer activeRuleIndexer;

    public QProfileTreeImpl(DbClient db, RuleActivator ruleActivator, System2 system2, ActiveRuleIndexer activeRuleIndexer) {
        this.db = db;
        this.ruleActivator = ruleActivator;
        this.system2 = system2;
        this.activeRuleIndexer = activeRuleIndexer;
    }

    @Override
    public List<ActiveRuleChange> removeParentAndCommit(DbSession dbSession, QProfileDto profile) {
        List<ActiveRuleChange> changes = this.removeParent(dbSession, profile);
        this.activeRuleIndexer.commitAndIndex(dbSession, changes);
        return changes;
    }

    @Override
    public List<ActiveRuleChange> setParentAndCommit(DbSession dbSession, QProfileDto profile, QProfileDto parentProfile) {
        List<ActiveRuleChange> changes = this.setParent(dbSession, profile, parentProfile);
        this.activeRuleIndexer.commitAndIndex(dbSession, changes);
        return changes;
    }

    private List<ActiveRuleChange> setParent(DbSession dbSession, QProfileDto profile, QProfileDto parent) {
        WsUtils.checkRequest(parent.getLanguage().equals(profile.getLanguage()), "Cannot set the profile '%s' as the parent of profile '%s' since their languages differ ('%s' != '%s')", parent.getKee(), profile.getKee(), parent.getLanguage(), profile.getLanguage());
        ArrayList<ActiveRuleChange> changes = new ArrayList<ActiveRuleChange>();
        if (parent.getKee().equals(profile.getParentKee())) {
            return changes;
        }
        WsUtils.checkRequest(!this.isDescendant(dbSession, profile, parent), "Descendant profile '%s' can not be selected as parent of '%s'", parent.getKee(), profile.getKee());
        changes.addAll(this.removeParent(dbSession, profile));
        profile.setParentKee(parent.getKee());
        this.db.qualityProfileDao().update(dbSession, profile, new QProfileDto[0]);
        List parentActiveRules = this.db.activeRuleDao().selectByProfile(dbSession, parent);
        Collection ruleIds = (Collection)parentActiveRules.stream().map(ActiveRuleDto::getRuleId).collect(MoreCollectors.toArrayList());
        RuleActivationContext context = this.ruleActivator.createContextForUserProfile(dbSession, profile, ruleIds);
        for (ActiveRuleDto parentActiveRule : parentActiveRules) {
            try {
                RuleActivation activation = RuleActivation.create(parentActiveRule.getRuleId(), null, null);
                changes.addAll(this.ruleActivator.activate(dbSession, activation, context));
            }
            catch (BadRequestException badRequestException) {}
        }
        return changes;
    }

    private List<ActiveRuleChange> removeParent(DbSession dbSession, QProfileDto profile) {
        ArrayList<ActiveRuleChange> changes = new ArrayList<ActiveRuleChange>();
        if (profile.getParentKee() == null) {
            return changes;
        }
        profile.setParentKee(null);
        this.db.qualityProfileDao().update(dbSession, profile, new QProfileDto[0]);
        List activeRules = this.db.activeRuleDao().selectByProfile(dbSession, profile);
        Collection ruleIds = (Collection)activeRules.stream().map(ActiveRuleDto::getRuleId).collect(MoreCollectors.toArrayList());
        RuleActivationContext context = this.ruleActivator.createContextForUserProfile(dbSession, profile, ruleIds);
        for (OrgActiveRuleDto activeRule : activeRules) {
            if ("INHERITED".equals(activeRule.getInheritance())) {
                changes.addAll(this.ruleActivator.deactivate(dbSession, context, activeRule.getRuleId(), true));
                continue;
            }
            if (!"OVERRIDES".equals(activeRule.getInheritance())) continue;
            context.reset(activeRule.getRuleId());
            activeRule.setInheritance(null);
            activeRule.setUpdatedAt(this.system2.now());
            this.db.activeRuleDao().update(dbSession, (ActiveRuleDto)activeRule);
            changes.add(new ActiveRuleChange(ActiveRuleChange.Type.UPDATED, (ActiveRuleDto)activeRule, context.getRule().get()).setInheritance(null));
        }
        return changes;
    }

    private boolean isDescendant(DbSession dbSession, QProfileDto childProfile, @Nullable QProfileDto parentProfile) {
        QProfileDto currentParent = parentProfile;
        while (currentParent != null) {
            if (childProfile.getName().equals(currentParent.getName())) {
                return true;
            }
            String parentKey = currentParent.getParentKee();
            if (parentKey != null) {
                currentParent = this.db.qualityProfileDao().selectByUuid(dbSession, parentKey);
                continue;
            }
            currentParent = null;
        }
        return false;
    }
}

