/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualityprofile;

import com.google.common.collect.ImmutableSortedSet;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Comparator;
import java.util.Date;
import java.util.Map;
import java.util.SortedSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.concurrent.Immutable;
import org.sonar.api.utils.text.JsonWriter;
import org.sonar.core.util.UtcDateUtils;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.server.qualityprofile.QualityProfile;

@Immutable
public class QPMeasureData {
    private final SortedSet<QualityProfile> profiles;

    public QPMeasureData(Iterable<QualityProfile> qualityProfiles) {
        this.profiles = ImmutableSortedSet.copyOf((Comparator)QualityProfileComparator.INSTANCE, qualityProfiles);
    }

    public static QPMeasureData fromJson(String json) {
        return new QPMeasureData(StreamSupport.stream(new JsonParser().parse(json).getAsJsonArray().spliterator(), false).map(jsonElement -> {
            JsonObject jsonProfile = jsonElement.getAsJsonObject();
            return new QualityProfile(jsonProfile.get("key").getAsString(), jsonProfile.get("name").getAsString(), jsonProfile.get("language").getAsString(), UtcDateUtils.parseDateTime((String)jsonProfile.get("rulesUpdatedAt").getAsString()));
        }).collect(Collectors.toList()));
    }

    public static String toJson(QPMeasureData data) {
        StringWriter json = new StringWriter();
        try (JsonWriter writer = JsonWriter.of((Writer)json);){
            writer.beginArray();
            for (QualityProfile profile : data.getProfiles()) {
                writer.beginObject().prop("key", profile.getQpKey()).prop("language", profile.getLanguageKey()).prop("name", profile.getQpName()).prop("rulesUpdatedAt", UtcDateUtils.formatDateTime((Date)profile.getRulesUpdatedAt())).endObject();
            }
            writer.endArray();
        }
        return json.toString();
    }

    public SortedSet<QualityProfile> getProfiles() {
        return this.profiles;
    }

    public Map<String, QualityProfile> getProfilesByKey() {
        return (Map)this.profiles.stream().collect(MoreCollectors.uniqueIndex(QualityProfile::getQpKey, Function.identity()));
    }

    private static enum QualityProfileComparator implements Comparator<QualityProfile>
    {
        INSTANCE;


        @Override
        public int compare(QualityProfile o1, QualityProfile o2) {
            int c = o1.getLanguageKey().compareTo(o2.getLanguageKey());
            if (c == 0) {
                c = o1.getQpName().compareTo(o2.getQpName());
            }
            return c;
        }
    }
}

