/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualityprofile;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.server.profile.BuiltInQualityProfilesDefinition;
import org.sonar.server.qualityprofile.QProfileName;

@Immutable
public final class BuiltInQProfile {
    private final QProfileName qProfileName;
    private final boolean isDefault;
    private final List<ActiveRule> activeRules;

    private BuiltInQProfile(Builder builder) {
        this.qProfileName = new QProfileName(builder.language, builder.name);
        this.isDefault = builder.declaredDefault || builder.computedDefault;
        this.activeRules = ImmutableList.copyOf((Collection)builder.activeRules);
    }

    public String getName() {
        return this.qProfileName.getName();
    }

    public String getLanguage() {
        return this.qProfileName.getLanguage();
    }

    public QProfileName getQProfileName() {
        return this.qProfileName;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public List<ActiveRule> getActiveRules() {
        return this.activeRules;
    }

    static final class Builder {
        private String language;
        private String name;
        private boolean declaredDefault;
        private boolean computedDefault;
        private final List<ActiveRule> activeRules = new ArrayList<ActiveRule>();

        Builder() {
        }

        public Builder setLanguage(String language) {
            this.language = language;
            return this;
        }

        Builder setName(String name) {
            this.name = name;
            return this;
        }

        String getName() {
            return this.name;
        }

        Builder setDeclaredDefault(boolean declaredDefault) {
            this.declaredDefault = declaredDefault;
            return this;
        }

        boolean isDeclaredDefault() {
            return this.declaredDefault;
        }

        Builder setComputedDefault(boolean flag) {
            this.computedDefault = flag;
            return this;
        }

        Builder addRule(BuiltInQualityProfilesDefinition.BuiltInActiveRule rule, int ruleId) {
            this.activeRules.add(new ActiveRule(ruleId, rule));
            return this;
        }

        Builder addRule(ActiveRule activeRule) {
            this.activeRules.add(activeRule);
            return this;
        }

        BuiltInQProfile build() {
            return new BuiltInQProfile(this);
        }
    }

    static final class ActiveRule {
        private final int ruleId;
        private final BuiltInQualityProfilesDefinition.BuiltInActiveRule builtIn;

        ActiveRule(int ruleId, BuiltInQualityProfilesDefinition.BuiltInActiveRule builtIn) {
            this.ruleId = ruleId;
            this.builtIn = builtIn;
        }

        public int getRuleId() {
            return this.ruleId;
        }

        public RuleKey getRuleKey() {
            return RuleKey.of((String)this.builtIn.repoKey(), (String)this.builtIn.ruleKey());
        }

        public BuiltInQualityProfilesDefinition.BuiltInActiveRule getBuiltIn() {
            return this.builtIn;
        }
    }
}

