/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualitygate.ws;

import com.google.common.io.Resources;
import com.google.protobuf.Message;
import java.util.Collection;
import javax.annotation.Nullable;
import org.sonar.api.server.ws.Change;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.core.util.Protobuf;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.qualitygate.QualityGateDto;
import org.sonar.server.qualitygate.QualityGateFinder;
import org.sonar.server.qualitygate.ws.QualityGatesWsAction;
import org.sonar.server.qualitygate.ws.QualityGatesWsSupport;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.Qualitygates;

public class ListAction
implements QualityGatesWsAction {
    private final DbClient dbClient;
    private final QualityGatesWsSupport wsSupport;
    private final QualityGateFinder finder;

    public ListAction(DbClient dbClient, QualityGatesWsSupport wsSupport, QualityGateFinder finder) {
        this.dbClient = dbClient;
        this.wsSupport = wsSupport;
        this.finder = finder;
    }

    public void define(WebService.NewController controller) {
        WebService.NewAction action = controller.createAction("list").setDescription("Get a list of quality gates").setSince("4.3").setResponseExample(Resources.getResource(this.getClass(), (String)"list-example.json")).setChangelog(new Change[]{new Change("7.0", "'isDefault' field is added on quality gate"), new Change("7.0", "'default' field on root level is deprecated"), new Change("7.0", "'isBuiltIn' field is added in the response"), new Change("7.0", "'actions' fields are added in the response")}).setHandler((RequestHandler)this);
        this.wsSupport.createOrganizationParam(action);
    }

    public void handle(Request request, Response response) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            OrganizationDto organization = this.wsSupport.getOrganization(dbSession, request);
            QualityGateDto defaultQualityGate = this.finder.getDefault(dbSession, organization);
            Collection qualityGates = this.dbClient.qualityGateDao().selectAll(dbSession, organization);
            WsUtils.writeProtobuf((Message)this.buildResponse(organization, qualityGates, defaultQualityGate), request, response);
        }
    }

    private Qualitygates.ListWsResponse buildResponse(OrganizationDto organization, Collection<QualityGateDto> qualityGates, @Nullable QualityGateDto defaultQualityGate) {
        Long defaultId = defaultQualityGate == null ? null : defaultQualityGate.getId();
        Qualitygates.ListWsResponse.Builder builder = Qualitygates.ListWsResponse.newBuilder().setActions(Qualitygates.ListWsResponse.RootActions.newBuilder().setCreate(this.wsSupport.isQualityGateAdmin(organization))).addAllQualitygates((Iterable)qualityGates.stream().map(qualityGate -> Qualitygates.ListWsResponse.QualityGate.newBuilder().setId(qualityGate.getId().longValue()).setName(qualityGate.getName()).setIsDefault(qualityGate.getId().equals(defaultId)).setIsBuiltIn(qualityGate.isBuiltIn()).setActions(this.wsSupport.getActions(organization, (QualityGateDto)qualityGate, defaultQualityGate)).build()).collect(MoreCollectors.toList()));
        Protobuf.setNullable((Object)defaultId, arg_0 -> ((Qualitygates.ListWsResponse.Builder)builder).setDefault(arg_0));
        return builder.build();
    }
}

