/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualitygate.ws;

import java.util.Optional;
import javax.annotation.Nullable;
import org.sonar.api.server.ws.Change;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.server.component.ComponentFinder;
import org.sonar.server.qualitygate.ws.QualityGatesWsAction;
import org.sonar.server.qualitygate.ws.QualityGatesWsSupport;

public class DeselectAction
implements QualityGatesWsAction {
    private final DbClient dbClient;
    private final ComponentFinder componentFinder;
    private final QualityGatesWsSupport wsSupport;

    public DeselectAction(DbClient dbClient, ComponentFinder componentFinder, QualityGatesWsSupport wsSupport) {
        this.wsSupport = wsSupport;
        this.dbClient = dbClient;
        this.componentFinder = componentFinder;
    }

    public void define(WebService.NewController controller) {
        WebService.NewAction action = controller.createAction("deselect").setDescription("Remove the association of a project from a quality gate.<br>Requires one of the following permissions:<ul><li>'Administer Quality Gates'</li><li>'Administer' rights on the project</li></ul>").setPost(true).setSince("4.3").setHandler((RequestHandler)this).setChangelog(new Change[]{new Change("6.6", "The parameter 'gateId' was removed")});
        action.createParam("projectId").setDescription("Project id").setDeprecatedSince("6.1").setExampleValue((Object)"AU-Tpxb--iU5OvuD2FLy");
        action.createParam("projectKey").setDescription("Project key").setExampleValue((Object)"my_project").setSince("6.1");
        this.wsSupport.createOrganizationParam(action);
    }

    public void handle(Request request, Response response) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            OrganizationDto organization = this.wsSupport.getOrganization(dbSession, request);
            ComponentDto project = this.getProject(dbSession, organization, request.param("projectId"), request.param("projectKey"));
            this.dissociateProject(dbSession, organization, project);
            response.noContent();
        }
    }

    private void dissociateProject(DbSession dbSession, OrganizationDto organization, ComponentDto project) {
        this.wsSupport.checkCanAdminProject(organization, project);
        this.dbClient.propertiesDao().deleteProjectProperty("sonar.qualitygate", project.getId(), dbSession);
        dbSession.commit();
    }

    private ComponentDto getProject(DbSession dbSession, OrganizationDto organization, @Nullable String projectId, @Nullable String projectKey) {
        ComponentDto project = this.selectProjectById(dbSession, projectId).orElseGet(() -> this.componentFinder.getByUuidOrKey(dbSession, projectId, projectKey, ComponentFinder.ParamNames.PROJECT_ID_AND_KEY));
        this.wsSupport.checkProjectBelongsToOrganization(organization, project);
        return project;
    }

    private Optional<ComponentDto> selectProjectById(DbSession dbSession, @Nullable String projectId) {
        if (projectId == null) {
            return Optional.empty();
        }
        try {
            long dbId = Long.parseLong(projectId);
            return Optional.ofNullable(this.dbClient.componentDao().selectById(dbSession, dbId).orNull());
        }
        catch (NumberFormatException e) {
            return Optional.empty();
        }
    }
}

