/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualitygate;

import java.util.Objects;
import java.util.Set;
import javax.annotation.concurrent.Immutable;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.server.qualitygate.Condition;

@Immutable
public class QualityGate {
    private final String id;
    private final String name;
    private final Set<Condition> conditions;

    public QualityGate(String id, String name, Set<Condition> conditions) {
        this.id = Objects.requireNonNull(id, "id can't be null");
        this.name = Objects.requireNonNull(name, "name can't be null");
        this.conditions = (Set)Objects.requireNonNull(conditions, "conditions can't be null").stream().map(c -> Objects.requireNonNull(c, "condition can't be null")).collect(MoreCollectors.toSet((int)conditions.size()));
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Set<Condition> getConditions() {
        return this.conditions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QualityGate that = (QualityGate)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.name, that.name) && Objects.equals(this.conditions, that.conditions);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.conditions);
    }

    public String toString() {
        return "QualityGate{id=" + this.id + ", name='" + this.name + '\'' + ", conditions=" + this.conditions + '}';
    }
}

