/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.projectanalysis.ws;

import org.sonar.api.utils.DateUtils;
import org.sonar.core.util.Protobuf;
import org.sonar.db.component.SnapshotDto;
import org.sonar.db.event.EventDto;
import org.sonar.server.projectanalysis.ws.EventCategory;
import org.sonar.server.projectanalysis.ws.SearchData;
import org.sonarqube.ws.ProjectAnalyses;

class SearchResponseBuilder {
    private final ProjectAnalyses.Analysis.Builder wsAnalysis = ProjectAnalyses.Analysis.newBuilder();
    private final ProjectAnalyses.Event.Builder wsEvent = ProjectAnalyses.Event.newBuilder();
    private final SearchData searchData;

    SearchResponseBuilder(SearchData searchData) {
        this.searchData = searchData;
    }

    ProjectAnalyses.SearchResponse build() {
        ProjectAnalyses.SearchResponse.Builder wsResponse = ProjectAnalyses.SearchResponse.newBuilder();
        this.addAnalyses(wsResponse);
        this.addPagination(wsResponse);
        return wsResponse.build();
    }

    private void addAnalyses(ProjectAnalyses.SearchResponse.Builder wsResponse) {
        this.searchData.analyses.stream().map(this::dbToWsAnalysis).map(this::attachEvents).forEach(arg_0 -> ((ProjectAnalyses.SearchResponse.Builder)wsResponse).addAnalyses(arg_0));
    }

    private ProjectAnalyses.Analysis.Builder dbToWsAnalysis(SnapshotDto dbAnalysis) {
        return this.wsAnalysis.clear().setKey(dbAnalysis.getUuid()).setDate(DateUtils.formatDateTime((long)dbAnalysis.getCreatedAt()));
    }

    private ProjectAnalyses.Analysis.Builder attachEvents(ProjectAnalyses.Analysis.Builder analysis) {
        this.searchData.eventsByAnalysis.get((Object)analysis.getKey()).stream().map(this::dbToWsEvent).forEach(arg_0 -> ((ProjectAnalyses.Analysis.Builder)analysis).addEvents(arg_0));
        return analysis;
    }

    private ProjectAnalyses.Event.Builder dbToWsEvent(EventDto dbEvent) {
        this.wsEvent.clear().setKey(dbEvent.getUuid());
        Protobuf.setNullable((Object)dbEvent.getName(), arg_0 -> ((ProjectAnalyses.Event.Builder)this.wsEvent).setName(arg_0));
        Protobuf.setNullable((Object)dbEvent.getDescription(), arg_0 -> ((ProjectAnalyses.Event.Builder)this.wsEvent).setDescription(arg_0));
        Protobuf.setNullable((Object)dbEvent.getCategory(), cat -> this.wsEvent.setCategory(EventCategory.fromLabel(cat).name()));
        return this.wsEvent;
    }

    private void addPagination(ProjectAnalyses.SearchResponse.Builder wsResponse) {
        wsResponse.getPagingBuilder().setPageIndex(this.searchData.paging.pageIndex()).setPageSize(this.searchData.paging.pageSize()).setTotal(this.searchData.paging.total()).build();
    }
}

