/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.project.ws;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;

class SearchRequest {
    private final String organization;
    private final String query;
    private final List<String> qualifiers;
    private final String visibility;
    private final Integer page;
    private final Integer pageSize;
    private final String analyzedBefore;
    private final boolean onProvisionedOnly;
    private final List<String> projects;
    private final List<String> projectIds;

    public SearchRequest(Builder builder) {
        this.organization = builder.organization;
        this.query = builder.query;
        this.qualifiers = builder.qualifiers;
        this.visibility = builder.visibility;
        this.page = builder.page;
        this.pageSize = builder.pageSize;
        this.analyzedBefore = builder.analyzedBefore;
        this.onProvisionedOnly = builder.onProvisionedOnly;
        this.projects = builder.projects;
        this.projectIds = builder.projectIds;
    }

    @CheckForNull
    public String getOrganization() {
        return this.organization;
    }

    public List<String> getQualifiers() {
        return this.qualifiers;
    }

    @CheckForNull
    public Integer getPage() {
        return this.page;
    }

    @CheckForNull
    public Integer getPageSize() {
        return this.pageSize;
    }

    @CheckForNull
    public String getQuery() {
        return this.query;
    }

    @CheckForNull
    public String getVisibility() {
        return this.visibility;
    }

    @CheckForNull
    public String getAnalyzedBefore() {
        return this.analyzedBefore;
    }

    public boolean isOnProvisionedOnly() {
        return this.onProvisionedOnly;
    }

    @CheckForNull
    public List<String> getProjects() {
        return this.projects;
    }

    @CheckForNull
    public List<String> getProjectIds() {
        return this.projectIds;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String organization;
        private List<String> qualifiers = Collections.singletonList("TRK");
        private Integer page;
        private Integer pageSize;
        private String query;
        private String visibility;
        private String analyzedBefore;
        private boolean onProvisionedOnly = false;
        private List<String> projects;
        private List<String> projectIds;

        public Builder setOrganization(@Nullable String organization) {
            this.organization = organization;
            return this;
        }

        public Builder setQualifiers(List<String> qualifiers) {
            this.qualifiers = Objects.requireNonNull(qualifiers, "Qualifiers cannot be null");
            return this;
        }

        public Builder setPage(@Nullable Integer page) {
            this.page = page;
            return this;
        }

        public Builder setPageSize(@Nullable Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public Builder setQuery(@Nullable String query) {
            this.query = query;
            return this;
        }

        public Builder setVisibility(@Nullable String visibility) {
            this.visibility = visibility;
            return this;
        }

        public Builder setAnalyzedBefore(@Nullable String lastAnalysisBefore) {
            this.analyzedBefore = lastAnalysisBefore;
            return this;
        }

        public Builder setOnProvisionedOnly(boolean onProvisionedOnly) {
            this.onProvisionedOnly = onProvisionedOnly;
            return this;
        }

        public Builder setProjects(@Nullable List<String> projects) {
            this.projects = projects;
            return this;
        }

        public Builder setProjectIds(@Nullable List<String> projectIds) {
            this.projectIds = projectIds;
            return this;
        }

        public SearchRequest build() {
            Preconditions.checkArgument((this.projects == null || !this.projects.isEmpty() ? 1 : 0) != 0, (Object)"Project key list must not be empty");
            Preconditions.checkArgument((this.projectIds == null || !this.projectIds.isEmpty() ? 1 : 0) != 0, (Object)"Project id list must not be empty");
            Preconditions.checkArgument((this.pageSize == null || this.pageSize <= 500 ? 1 : 0) != 0, (String)"Page size must not be greater than %s", (Object[])new Object[]{500});
            return new SearchRequest(this);
        }
    }
}

