/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.plugins.ws;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.updatecenter.common.Plugin;
import org.sonar.updatecenter.common.PluginUpdate;

public class PluginUpdateAggregator {
    public Collection<PluginUpdateAggregate> aggregate(@Nullable Collection<PluginUpdate> pluginUpdates) {
        if (pluginUpdates == null || pluginUpdates.isEmpty()) {
            return Collections.emptyList();
        }
        HashMap builders = Maps.newHashMap();
        for (PluginUpdate pluginUpdate : pluginUpdates) {
            Plugin plugin = pluginUpdate.getPlugin();
            PluginUpdateAggregateBuilder builder = (PluginUpdateAggregateBuilder)builders.get(plugin);
            if (builder == null) {
                builder = PluginUpdateAggregateBuilder.builderFor(plugin);
                builders.put(plugin, builder);
            }
            builder.add(pluginUpdate);
        }
        return Lists.newArrayList((Iterable)Iterables.transform(builders.values(), PluginUpdateAggregateBuilder::build));
    }

    public static class PluginUpdateAggregate {
        private final Plugin plugin;
        private final Collection<PluginUpdate> updates;

        protected PluginUpdateAggregate(PluginUpdateAggregateBuilder builder) {
            this.plugin = builder.plugin;
            this.updates = ImmutableList.copyOf((Collection)builder.updates);
        }

        public Plugin getPlugin() {
            return this.plugin;
        }

        public Collection<PluginUpdate> getUpdates() {
            return this.updates;
        }
    }

    @VisibleForTesting
    static class PluginUpdateAggregateBuilder {
        private final Plugin plugin;
        private final List<PluginUpdate> updates = Lists.newArrayListWithExpectedSize((int)1);

        private PluginUpdateAggregateBuilder(Plugin plugin) {
            this.plugin = plugin;
        }

        public static PluginUpdateAggregateBuilder builderFor(Plugin plugin) {
            return new PluginUpdateAggregateBuilder((Plugin)Preconditions.checkNotNull((Object)plugin));
        }

        public PluginUpdateAggregateBuilder add(PluginUpdate pluginUpdate) {
            Preconditions.checkArgument((boolean)this.plugin.equals((Object)pluginUpdate.getPlugin()), (Object)String.format("This builder only accepts PluginUpdate instances for plugin %s", this.plugin));
            this.updates.add(pluginUpdate);
            return this;
        }

        public PluginUpdateAggregate build() {
            return new PluginUpdateAggregate(this);
        }
    }
}

